/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JfxRuntime;
import com.sun.deploy.config.NativePlatform;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.SyncAccess;
import com.sun.deploy.util.VersionID;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class JREInfo {
    private static ArrayList _jres = new ArrayList();
    private static SyncAccess syncAccess = new SyncAccess(8);
    private String _platform;
    private VersionID _platformVersion;
    private String _product;
    private VersionID _productVersion;
    private String _location;
    private String _path;
    private NativePlatform _nativePlatform;
    private String _vm_args;
    private boolean _enabled;
    private boolean _registered;
    private boolean _system;
    private JfxRuntime _jfxRuntime = null;

    public String getPlatform() {
        return this._platform;
    }

    public VersionID getPlatformVersion() {
        return this._platformVersion;
    }

    public String getProduct() {
        return this._product;
    }

    public VersionID getProductVersion() {
        return this._productVersion;
    }

    public VersionID getFXVersion() {
        return this._jfxRuntime == null ? null : this._jfxRuntime.getProductVersion();
    }

    public JfxRuntime getJfxRuntime() {
        return this._jfxRuntime;
    }

    public String getLocation() {
        return this._location;
    }

    public String getPath() {
        return this._path;
    }

    public String getVmArgs() {
        return this._vm_args;
    }

    public String getDebugJavaPath() {
        return Platform.get().getDebugJavaPath(this._path);
    }

    public String getOSName() {
        return this._nativePlatform.getOSName();
    }

    public String getOSArch() {
        return this._nativePlatform.getOSArch();
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public boolean isRegistered() {
        return this._registered;
    }

    public boolean isSystemJRE() {
        return this._system;
    }

    public void setPlatform(String string) {
        this._platform = string;
        this._platformVersion = new VersionID(string);
    }

    public void setProduct(String string) {
        this._product = string;
        this._productVersion = new VersionID(string);
    }

    public void setLocation(String string) {
        this._location = string;
    }

    public void setPath(String string) {
        this._path = Config.getJavaCommand(Platform.get().getLongPathName(string));
    }

    public void setVmArgs(String string) {
        this._vm_args = string;
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
    }

    public void setRegistered(boolean bl) {
        this._registered = bl;
    }

    public void setSystemJRE(boolean bl) {
        this._system = bl;
    }

    public void setOSName(String string) {
        this._nativePlatform = new NativePlatform(string, this.getOSArch());
    }

    public void setOSArch(String string) {
        this._nativePlatform = new NativePlatform(this.getOSName(), string);
    }

    public JREInfo(String string, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl, boolean bl2) {
        String string8;
        this.setProduct(string2);
        if (null != string) {
            this.setPlatform(string);
        } else {
            this.setPlatform(JREInfo.getPlatformByProduct(string2));
        }
        this._location = string3;
        this._path = Config.getJavaCommand(Platform.get().getLongPathName(string4));
        this._vm_args = string5;
        this._enabled = bl;
        this._registered = bl2;
        this._system = false;
        this._nativePlatform = new NativePlatform(string6, string7);
        if (this._location == null) {
            this._location = Config.getStringProperty("deployment.javaws.installURL");
        }
        JfxRuntime jfxRuntime = this._jfxRuntime = (string8 = Environment.getenv("FORCED_FX_ROOT")) != null ? JfxRuntime.runtimeForPath(string8) : null;
        if (this._jfxRuntime == null) {
            this._jfxRuntime = JfxRuntime.runtimeForPath(string4);
            if (this._jfxRuntime == null) {
                String string9 = Config.getJavaHome(string4);
                this._jfxRuntime = JfxRuntime.runtimeForPath(string9);
                if (this._jfxRuntime == null) {
                    this._jfxRuntime = Platform.get().getStandaloneJfxRuntime();
                }
            }
        }
    }

    public JREInfo(int n, Properties properties, boolean bl) {
        this(properties.getProperty("deployment.javaws.jre." + n + ".platform"), properties.getProperty("deployment.javaws.jre." + n + ".product"), properties.getProperty("deployment.javaws.jre." + n + ".location"), properties.getProperty("deployment.javaws.jre." + n + ".path"), properties.getProperty("deployment.javaws.jre." + n + ".args"), properties.getProperty("deployment.javaws.jre." + n + ".osname"), properties.getProperty("deployment.javaws.jre." + n + ".osarch"), false, false);
        String string = properties.getProperty("deployment.javaws.jre." + n + ".enabled");
        if (string != null && Boolean.valueOf(string).booleanValue()) {
            this.setEnabled(true);
        }
        if ((string = properties.getProperty("deployment.javaws.jre." + n + ".registered")) != null && Boolean.valueOf(string).booleanValue()) {
            this.setRegistered(true);
        }
        this.setSystemJRE(bl);
    }

    public JREInfo(JREInfo jREInfo) {
        this(jREInfo.getPlatform(), jREInfo.getProduct(), jREInfo.getLocation(), jREInfo.getPath(), jREInfo.getVmArgs(), jREInfo.getOSName(), jREInfo.getOSArch(), jREInfo.isEnabled(), jREInfo.isRegistered());
        this.setSystemJRE(jREInfo.isSystemJRE());
    }

    public static void refreshStandaloneJavaFXRuntime() {
        JREInfo[] jREInfoArray = JREInfo.getAll();
        for (int i = 0; i < jREInfoArray.length; ++i) {
            JREInfo.addJRE(new JREInfo(jREInfoArray[i]), true);
        }
    }

    public boolean isOsInfoMatch() {
        return this._nativePlatform.compatible(NativePlatform.getCurrentNativePlatform());
    }

    public boolean isOsInfoMatch(String string, String string2) {
        return this._nativePlatform.compatible(new NativePlatform(string, string2));
    }

    public String toString() {
        int n = JREInfo.findJREByPath_int(this, _jres);
        return (n >= 0 ? "JREInfo for index " + n + ":\n" : "JREInfo (not in list):\n") + "    platform is: " + this._platform + "\n" + "    product is: " + this._product + "\n" + "    location is: " + this._location + "\n" + "    path is: " + this._path + "\n" + "    args is: " + this._vm_args + "\n" + "    native platform is: " + this._nativePlatform.toString() + "\n" + "    JavaFX runtime is: " + this._jfxRuntime + "\n" + "    enabled is: " + this._enabled + "\n" + "    registered is: " + this._registered + "\n" + "    system is: " + this._system + "\n" + "";
    }

    public String getJREPath() {
        return Config.getJavaHome(this.getPath());
    }

    public static String getPlatformByProduct(String string) {
        int n;
        if (string != null && (n = string.indexOf(".", 0)) > 0 && n < string.length() - 1) {
            int n2 = string.indexOf(".", n + 1);
            if (n2 > n) {
                return string.substring(0, n2);
            }
            n2 = string.indexOf("*", n + 1);
            if (n2 > n) {
                return string.substring(0, n2);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findJREByPath(JREInfo jREInfo, ArrayList arrayList) {
        int n;
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            n = JREInfo.findJREByPath_int(jREInfo, arrayList);
            Object var5_4 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.release();
            throw throwable;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findJREByProductVersion(JREInfo jREInfo, ArrayList arrayList) {
        int n;
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            n = JREInfo.findJREByProductVersion_int(jREInfo, arrayList);
            Object var5_4 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.release();
            throw throwable;
        }
        return n;
    }

    public static void addJRE(JREInfo jREInfo) {
        JREInfo.addJRE(jREInfo, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addJRE(JREInfo jREInfo, boolean bl) {
        SyncAccess.Lock lock = syncAccess.lock(4);
        try {
            JREInfo.addJRE_int(jREInfo, bl);
            Object var4_3 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeJRE(int n) {
        SyncAccess.Lock lock = syncAccess.lock(4);
        try {
            _jres.remove(n);
            Object var3_2 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JREInfo getJREInfo(int n) {
        JREInfo jREInfo;
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            jREInfo = (JREInfo)_jres.get(n);
            Object var4_3 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.release();
            throw throwable;
        }
        return jREInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setJREInfo(int n, JREInfo jREInfo) {
        SyncAccess.Lock lock = syncAccess.lock(4);
        try {
            _jres.set(n, jREInfo);
            Object var4_3 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        SyncAccess.Lock lock = syncAccess.lock(4);
        try {
            _jres.clear();
            Object var2_1 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionID getLatestVersion(boolean bl) {
        SyncAccess.Lock lock = syncAccess.lock(4);
        VersionID versionID = null;
        try {
            for (int i = 0; i < _jres.size(); ++i) {
                VersionID versionID2;
                JREInfo jREInfo = (JREInfo)_jres.get(i);
                if (!bl && !jREInfo.isEnabled() || (versionID2 = jREInfo.getProductVersion()) == null || versionID != null && !versionID2.isGreaterThan(versionID)) continue;
                versionID = versionID2;
            }
            VersionID versionID3 = versionID;
            Object var7_7 = null;
            lock.release();
            return versionID3;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JREInfo[] getAll() {
        JREInfo[] jREInfoArray;
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            jREInfoArray = _jres.toArray(new JREInfo[0]);
            Object var3_2 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.release();
            throw throwable;
        }
        return jREInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Properties properties, Properties properties2) {
        SyncAccess.Lock lock = syncAccess.lock(4);
        try {
            Integer n;
            int n2;
            String string;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n3 = -1;
            _jres.clear();
            Enumeration<Object> enumeration = properties2.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (!string.startsWith("deployment.javaws.jre.") || (n2 = JREInfo.getJREIndex_int(string)) < 0 || n2 == n3) continue;
                n = new Integer(n2);
                if (!arrayList.contains(n)) {
                    arrayList.add(n);
                    JREInfo.addJRE_int(new JREInfo(n2, properties2, false), true);
                }
                n3 = n2;
            }
            enumeration = properties.keys();
            n3 = -1;
            arrayList = new ArrayList();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (!string.startsWith("deployment.javaws.jre.") || (n2 = JREInfo.getJREIndex_int(string)) < 0 || n2 == n3) continue;
                n = new Integer(n2);
                if (!arrayList.contains(n)) {
                    arrayList.add(n);
                    JREInfo.addJRE_int(new JREInfo(n2, properties, true), true);
                }
                n3 = n2;
            }
            JREInfo.validateJREs_int();
            JREInfo.validateHomeJRE_int();
            Object var10_9 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importJpiEntries(Properties properties) {
        SyncAccess.Lock lock = syncAccess.lock(4);
        try {
            Object object;
            String string;
            Object object2;
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            HashMap<Object, String> hashMap2 = new HashMap<Object, String>();
            HashMap<Object, Boolean> hashMap3 = new HashMap<Object, Boolean>();
            HashMap<Object, String> hashMap4 = new HashMap<Object, String>();
            HashMap<String, String> hashMap5 = new HashMap<String, String>();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                int n;
                object2 = (String)enumeration.nextElement();
                string = (String)properties.get(object2);
                object = null;
                if (!((String)object2).startsWith("deployment.javapi.jre.")) continue;
                int n2 = "deployment.javapi.jre.".length();
                if (((String)object2).endsWith(".osarch")) {
                    n = ((String)object2).indexOf(".osarch");
                    object = ((String)object2).substring(n2, n);
                    hashMap5.put((String)object, string);
                    continue;
                }
                if (((String)object2).endsWith(".osname")) {
                    n = ((String)object2).indexOf(".osname");
                    object = ((String)object2).substring(n2, n);
                    hashMap4.put(object, string);
                    continue;
                }
                if (((String)object2).endsWith(".path")) {
                    n = ((String)object2).indexOf(".path");
                    object = ((String)object2).substring(n2, n);
                    hashMap.put(object, string);
                    continue;
                }
                if (((String)object2).endsWith(".args")) {
                    n = ((String)object2).indexOf(".args");
                    object = ((String)object2).substring(n2, n);
                    hashMap2.put(object, string);
                    continue;
                }
                if (!((String)object2).endsWith(".enabled")) continue;
                n = ((String)object2).indexOf(".enabled");
                object = ((String)object2).substring(n2, n);
                hashMap3.put(object, Boolean.valueOf(string));
            }
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                string = (String)object2.next();
                String string2 = (String)hashMap.get(string);
                String string3 = (String)hashMap4.get(string);
                String string4 = (String)hashMap5.get(string);
                String string5 = (String)hashMap2.get(string);
                object = (Boolean)hashMap3.get(string);
                boolean bl = object == null ? true : (Boolean)object;
                JREInfo jREInfo = new JREInfo(null, string, null, string2, string5, string3, string4, bl, false);
                JREInfo.addJRE_int(jREInfo, true);
            }
            Object var18_20 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setInstalledJREList(Vector vector) {
        boolean bl = false;
        SyncAccess.Lock lock = syncAccess.lock(4);
        try {
            for (int i = 0; i < vector.size(); i += 2) {
                String string = (String)vector.get(i);
                String string2 = (String)vector.get(i + 1);
                if (string.lastIndexOf(".") <= 2) continue;
                JREInfo jREInfo = new JREInfo(null, string, null, string2, "", Config.getOSName(), Config.getOSArch(), true, true);
                int n = JREInfo.findJREByPath_int(jREInfo, _jres);
                if (n < 0) {
                    JREInfo.addJRE_int(jREInfo, false);
                    bl = true;
                    continue;
                }
                ((JREInfo)_jres.get(n)).setRegistered(true);
            }
            JREInfo.validateJREs_int();
            JREInfo.validateHomeJRE_int();
            Object var9_8 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            lock.release();
            throw throwable;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printJREs() {
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            System.out.println("\nJREInfo: " + _jres.size() + " entries");
            for (int i = 0; i < _jres.size(); ++i) {
                System.out.println("JREInfo " + i + ":");
                System.out.println(_jres.get(i).toString());
            }
            Object var3_2 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceJREs() {
        if (!Trace.isEnabled(TraceLevel.BASIC)) {
            return;
        }
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            Trace.println("\nJREInfo: " + _jres.size() + " entries", TraceLevel.BASIC);
            for (int i = 0; i < _jres.size(); ++i) {
                Trace.println("JREInfo " + i + ":", TraceLevel.BASIC);
                Trace.println(_jres.get(i).toString(), TraceLevel.BASIC);
            }
            Object var3_2 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getKnownPlatforms() {
        StringBuffer stringBuffer = new StringBuffer();
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            for (int i = 0; i < _jres.size(); ++i) {
                JREInfo jREInfo = (JREInfo)_jres.get(i);
                stringBuffer.append(jREInfo.getPlatform());
                stringBuffer.append(" ");
            }
            Object var5_4 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.release();
            throw throwable;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultJavaPath() {
        String string;
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            JREInfo jREInfo = JREInfo.getHomeJRE_int();
            string = jREInfo != null ? jREInfo.getPath() : ((JREInfo)_jres.get(0)).getPath();
            Object var4_3 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.release();
            throw throwable;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JREInfo getHomeJRE() {
        JREInfo jREInfo;
        SyncAccess.Lock lock = syncAccess.lock(2);
        try {
            jREInfo = JREInfo.getHomeJRE_int();
            Object var3_2 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.release();
            throw throwable;
        }
        return jREInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeJREsIn(String string) {
        SyncAccess.Lock lock = syncAccess.lock(4);
        try {
            Iterator iterator = _jres.iterator();
            while (iterator.hasNext()) {
                JREInfo jREInfo = (JREInfo)iterator.next();
                String string2 = jREInfo.getPath();
                if (string2 == null || !string2.startsWith(string)) continue;
                iterator.remove();
            }
            Object var6_5 = null;
            lock.release();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.release();
            throw throwable;
        }
    }

    public static boolean isValidJREPath(String string) {
        if (string != null) {
            File file = new File(string);
            return file.exists() && !file.isDirectory();
        }
        return false;
    }

    private static int findJREByPath_int(JREInfo jREInfo, ArrayList arrayList) {
        JREInfo jREInfo2;
        int n;
        for (n = arrayList.size() - 1; !(n < 0 || jREInfo.isOsInfoMatch((jREInfo2 = (JREInfo)arrayList.get(n)).getOSName(), jREInfo2.getOSArch()) && jREInfo.isSystemJRE() == jREInfo2.isSystemJRE() && jREInfo.getPath() != null && Platform.get().samePaths(jREInfo.getPath(), jREInfo2.getPath())); --n) {
        }
        return n;
    }

    private static int findJREByProductVersion_int(JREInfo jREInfo, ArrayList arrayList) {
        int n;
        String string = jREInfo.getLocation();
        if (string == null) {
            return -1;
        }
        for (n = arrayList.size() - 1; n >= 0; --n) {
            JREInfo jREInfo2 = (JREInfo)arrayList.get(n);
            String string2 = jREInfo2.getLocation();
            if (jREInfo.isSystemJRE() == jREInfo2.isSystemJRE() && string2 != null && string.equals(string2) && jREInfo.getProductVersion().equals(jREInfo2.getProductVersion())) break;
        }
        return n;
    }

    private static void addJRE_int(JREInfo jREInfo, boolean bl) {
        if (jREInfo.getPath() != null && jREInfo.getPlatform() != null && jREInfo.getPlatform().compareTo("1.3") >= 0) {
            JREInfo jREInfo2;
            int n = JREInfo.findJREByPath_int(jREInfo, _jres);
            if (n >= 0 && !bl) {
                return;
            }
            if (n >= 0) {
                jREInfo2 = (JREInfo)_jres.get(n);
                if ((jREInfo.getVmArgs() == null || "".equals(jREInfo.getVmArgs())) && null != jREInfo2.getVmArgs()) {
                    jREInfo.setVmArgs(jREInfo2.getVmArgs());
                }
                _jres.remove(n);
            }
            for (n = 0; n < _jres.size(); ++n) {
                jREInfo2 = (JREInfo)_jres.get(n);
                if (!jREInfo.getProductVersion().isGreaterThanOrEqual(jREInfo2.getProductVersion())) continue;
                _jres.add(n, jREInfo);
                return;
            }
            _jres.add(jREInfo);
        }
    }

    private static void validateHomeJRE_int() {
        JREInfo jREInfo = JREInfo.getHomeJRE_int();
        if (jREInfo != null) {
            int n = JREInfo.findJREByPath_int(jREInfo, _jres);
            if (n < 0) {
                JREInfo.addJRE_int(jREInfo, true);
            }
            JREInfo jREInfo2 = new JREInfo(jREInfo);
            jREInfo2.setSystemJRE(true);
            n = JREInfo.findJREByPath_int(jREInfo2, _jres);
            if (n < 0) {
                JREInfo.addJRE_int(jREInfo2, true);
            }
            for (int i = 0; i < _jres.size(); ++i) {
                JREInfo jREInfo3 = (JREInfo)_jres.get(i);
                if (jREInfo3.isSystemJRE() || !jREInfo3.getProduct().equals(jREInfo.getProduct()) || !jREInfo3.getOSName().equals(jREInfo.getOSName()) || !jREInfo3.getOSArch().equals(jREInfo.getOSArch()) || Platform.get().samePaths(jREInfo3.getPath(), jREInfo.getPath())) continue;
                _jres.remove(i);
            }
        }
    }

    private static void validateJREs_int() {
        for (int i = 0; i < _jres.size(); ++i) {
            JREInfo jREInfo = (JREInfo)_jres.get(i);
            if (!jREInfo.isOsInfoMatch() || JREInfo.isValidJREPath(jREInfo.getPath())) continue;
            _jres.remove(i);
        }
    }

    private static int getJREIndex_int(String string) {
        int n = "deployment.javaws.jre.".length();
        int n2 = string.indexOf(".", n);
        if (n2 > n) {
            String string2 = string.substring(n, n2);
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static JREInfo getHomeJRE_int() {
        String string;
        String string2 = Config.getJavaVersion();
        JREInfo jREInfo = new JREInfo(null, string2, "http://java.sun.com/products/autodl/j2se", string = Platform.get().getLongPathName(Config.getJREHome()), "", Config.getOSName(), Config.getOSArch(), true, false);
        int n = JREInfo.findJREByPath_int(jREInfo, _jres);
        if (n >= 0) {
            JREInfo jREInfo2 = (JREInfo)_jres.get(n);
            if (!jREInfo.getProduct().equals(jREInfo2.getProduct())) {
                jREInfo2.setProduct(jREInfo.getProduct());
            }
            jREInfo = jREInfo2;
        }
        if (!jREInfo.isOsInfoMatch()) {
            jREInfo.setOSName(Config.getOSName());
            jREInfo.setOSArch(Config.getOSArch());
        }
        return jREInfo;
    }

    static {
        JREInfo.validateHomeJRE_int();
    }
}

