/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.deploy.util.VersionID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;

public class SecurityBaseline {
    private static final String BASELINE_VERSION_131 = "1.3.1_21";
    private static final String BASELINE_VERSION_142 = "1.4.2_38";
    private static final String BASELINE_VERSION_150 = "1.5.0_36";
    private static final String BASELINE_VERSION_160 = "1.6.0_33";
    private static final String BASELINE_VERSION_170 = "1.7.0_05";
    private static final String BASELINE_VERSION_180 = "1.8.0";
    private static final String CURRENT_VERSION = "1.7.0_06";
    private static final String CURRENT_NODOT_VERSION = "170";
    private static final String DEPLOY_VERSION = "10.6.2.24";
    private static final String DEPLOY_NODOT_VERSION = "1062";
    private static String baseline_131 = "1.3.1_21";
    private static String baseline_142 = "1.4.2_38";
    private static String baseline_150 = "1.5.0_36";
    private static String baseline_160 = "1.6.0_33";
    private static String baseline_170 = "1.7.0_05";
    private static String baseline_180 = "1.8.0";
    private static boolean baselines_initialized = false;
    private static final boolean DEBUG = Config.getBooleanProperty("deployment.baseline.debug");
    private static final long UPDATE_INTERVAL = DEBUG ? 10000 : 604800000;
    private static final long THREAD_SLEEP_INTERVAL = DEBUG ? 1000 : 60000;
    private static final String BASELINE_FILENAME = "baseline.versions";
    private static final String BASELINE_TIMESTAMP = "baseline.timestamp";
    private static final String UPDATE_TIMESTAMP = "update.timestamp";
    private static final File securityDir = new File(Config.getUserHome(), "security");
    private static final File baselineFile = new File(securityDir, "baseline.versions");
    private static final File baselineTimestampFile = new File(securityDir, "baseline.timestamp");
    private static final File updateTimestampFile = new File(securityDir, "update.timestamp");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void initialize_baselines() {
        block20: {
            if (!baselines_initialized && baselineFile.exists()) {
                BufferedReader bufferedReader;
                block19: {
                    bufferedReader = null;
                    long l = System.currentTimeMillis();
                    bufferedReader = new BufferedReader(new FileReader(baselineFile));
                    boolean bl = false;
                    while (!bl) {
                        String string = bufferedReader.readLine();
                        if (string == null) {
                            bl = true;
                            continue;
                        }
                        if (string.startsWith("1.8")) {
                            baseline_180 = string;
                            Platform.get().cacheSecurityBaseline(BASELINE_VERSION_180, baseline_180);
                            continue;
                        }
                        if (string.startsWith("1.7")) {
                            baseline_170 = string;
                            Platform.get().cacheSecurityBaseline("1.7.0", baseline_170);
                            continue;
                        }
                        if (string.startsWith("1.6")) {
                            baseline_160 = string;
                            Platform.get().cacheSecurityBaseline("1.6.0", baseline_160);
                            continue;
                        }
                        if (string.startsWith("1.5")) {
                            baseline_150 = string;
                            Platform.get().cacheSecurityBaseline("1.5.0", baseline_150);
                            continue;
                        }
                        if (string.startsWith("1.4.2")) {
                            baseline_142 = string;
                            Platform.get().cacheSecurityBaseline("1.4.2", baseline_142);
                            continue;
                        }
                        if (!string.startsWith("1.3.1")) continue;
                        baseline_131 = string;
                        Platform.get().cacheSecurityBaseline("1.3.1", baseline_131);
                    }
                    if (!DEBUG) break block19;
                    Trace.println("It took " + (System.currentTimeMillis() - l) + " Ms. to read baseline file", TraceLevel.BASIC);
                }
                Object var6_5 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block20;
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
                break block20;
                {
                    catch (Exception exception) {
                        Trace.ignored(exception);
                        Object var6_6 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                            break block20;
                        }
                        catch (IOException iOException) {
                            Trace.ignored(iOException);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        Trace.ignored(iOException);
                    }
                    throw throwable;
                }
            }
        }
        baselines_initialized = true;
    }

    public static String getBaselineVersion(String string) {
        if (!baselines_initialized) {
            SecurityBaseline.initialize_baselines();
        }
        String string2 = string.startsWith("1.8") ? baseline_180 : (string.startsWith("1.7") ? baseline_170 : (string.startsWith("1.6") ? baseline_160 : (string.startsWith("1.5") ? baseline_150 : (string.startsWith("1.4.2") ? baseline_142 : (string.startsWith("1.3.1") ? baseline_131 : CURRENT_VERSION)))));
        if (DEBUG) {
            Trace.println("for requested version: " + string + "baseline version is: " + string2, TraceLevel.SECURITY);
        }
        return string2;
    }

    public static boolean satisfiesSecurityBaseline(String string) {
        VersionID versionID = new VersionID(string);
        if (string.compareTo(SecurityBaseline.getBaselineVersion(string)) >= 0) {
            return true;
        }
        return versionID.equals(JREInfo.getLatestVersion(false));
    }

    public static boolean satisfiesBaselineStrictly(String string) {
        VersionID versionID = new VersionID(string);
        return string.compareTo(SecurityBaseline.getBaselineVersion(string)) >= 0;
    }

    public static String getDeployVersion() {
        return DEPLOY_VERSION;
    }

    public static String getDeployNoDotVersion() {
        return DEPLOY_NODOT_VERSION;
    }

    public static String getCurrentVersion() {
        return CURRENT_VERSION;
    }

    public static String getCurrentNoDotVersion() {
        return CURRENT_NODOT_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static synchronized void checkForBaselineUpdates() {
        block24: {
            String string = Config.getStringProperty("deployment.baseline.url");
            if (string != null && string.length() > 0) {
                Exception exception2222;
                FileOutputStream fileOutputStream;
                InputStream inputStream;
                block22: {
                    long l = 0L;
                    if (baselineFile.exists()) {
                        l = baselineFile.lastModified();
                    }
                    inputStream = null;
                    fileOutputStream = null;
                    if (DEBUG) {
                        Trace.println("Checking for baseline at: " + string, TraceLevel.NETWORK);
                    }
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setUseCaches(false);
                    if (uRLConnection.getLastModified() > l) {
                        Trace.println("Updating baseline file at: " + baselineFile + " from url: " + string, TraceLevel.NETWORK);
                        inputStream = uRLConnection.getInputStream();
                        fileOutputStream = new FileOutputStream(baselineFile);
                        byte[] byArray = new byte[8192];
                        int n = 0;
                        while ((n = inputStream.read(byArray)) != -1) {
                            fileOutputStream.write(byArray, 0, n);
                        }
                    }
                    Object var10_9 = null;
                    if (fileOutputStream == null) break block22;
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception2222) {
                        Trace.ignored(exception2222);
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception2222) {
                        Trace.ignored(exception2222);
                    }
                }
                break block24;
                {
                    catch (Exception exception3) {
                        Exception exception42222;
                        Trace.ignored(exception3);
                        Object var10_10 = null;
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Exception exception42222) {
                                Trace.ignored(exception42222);
                            }
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception42222) {
                                Trace.ignored(exception42222);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    Exception exception52222;
                    Object var10_11 = null;
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception52222) {
                            Trace.ignored(exception52222);
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception52222) {
                            Trace.ignored(exception52222);
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    private static long getLastChecked() {
        if (baselineTimestampFile.exists()) {
            return baselineTimestampFile.lastModified();
        }
        return 0L;
    }

    private static void setLastChecked(long l) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(baselineTimestampFile);
            ((OutputStream)fileOutputStream).write(46);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static long getLastUpdateNag() {
        if (updateTimestampFile.exists()) {
            return updateTimestampFile.lastModified();
        }
        return 0L;
    }

    private static void setLastUpdateNag(long l) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(updateTimestampFile);
            ((OutputStream)fileOutputStream).write(46);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void backgroundBaselineUpdate() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                long l = new Date().getTime();
                if (l > SecurityBaseline.getLastChecked() + UPDATE_INTERVAL) {
                    try {
                        Thread.sleep(THREAD_SLEEP_INTERVAL);
                        SecurityBaseline.checkForBaselineUpdates();
                        SecurityBaseline.setLastChecked(l);
                    }
                    catch (Exception exception) {
                        Trace.ignored(exception);
                    }
                }
                if (DEBUG) {
                    Trace.println("Baseline thread exiting time: " + (new Date().getTime() - l), TraceLevel.BASIC);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public static void forceBaselineUpdate() {
        SecurityBaseline.checkForBaselineUpdates();
        SecurityBaseline.initialize_baselines();
        SecurityBaseline.setLastChecked(new Date().getTime());
    }

    public static void checkUpdate() {
        long l;
        String string;
        if (!Environment.isSilentMode() && Config.getBooleanProperty("deployment.java.update.check") && !SecurityBaseline.satisfiesBaselineStrictly(string = JREInfo.getHomeJRE().getProduct()) && (l = new Date().getTime()) > SecurityBaseline.getLastUpdateNag() + UPDATE_INTERVAL) {
            SecurityBaseline.setLastUpdateNag(l);
            URL uRL = null;
            try {
                uRL = new URL("http://java.com/en/download/faq/whatis_java.xml");
            }
            catch (Exception exception) {
                // empty catch block
            }
            UIFactory uIFactory = ToolkitStore.getUI();
            AppInfo appInfo = new AppInfo();
            ToolkitStore.getUI();
            int n = uIFactory.showMessageDialog(null, appInfo, 2, ResourceManager.getMessage("deployment.ssv2.update.title"), ResourceManager.getMessage("deployment.ssv2.update"), null, null, ResourceManager.getString("deployment.ssv2.update.ok"), ResourceManager.getString("deployment.ssv2.update.cancel"), null, uRL, ResourceManager.getMessage("deployment.ssv2.update.more"));
            ToolkitStore.getUI();
            if (n == 0) {
                Platform.get().showDocument("http://java.com");
            }
        }
    }

    static {
        securityDir.mkdirs();
        SecurityBaseline.backgroundBaselineUpdate();
    }
}

