/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.connector.OracleConnectionRequestInfo;
import oracle.jdbc.connector.OracleManagedConnection;

public class OracleManagedConnectionFactory
implements ManagedConnectionFactory {
    private XADataSource xaDataSource = null;
    private String xaDataSourceName = null;
    private static final String RAERR_MCF_SET_XADS = "invalid xads";
    private static final String RAERR_MCF_GET_PCRED = "no password credential";
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Tue_Feb_27_15:19:35_PST_2007";
    static /* synthetic */ Class class$javax$resource$spi$security$PasswordCredential;

    public OracleManagedConnectionFactory() throws ResourceException {
    }

    public OracleManagedConnectionFactory(XADataSource xADataSource) throws ResourceException {
        this.xaDataSource = xADataSource;
        this.xaDataSourceName = "XADataSource";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory(null);
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        if (this.xaDataSource == null) {
            this.setupXADataSource();
        }
        return (DataSource)((Object)this.xaDataSource);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        try {
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            XAConnection xAConnection = null;
            PasswordCredential passwordCredential = this.getPasswordCredential(subject, connectionRequestInfo);
            xAConnection = passwordCredential == null ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(passwordCredential.getUserName(), new String(passwordCredential.getPassword()));
            OracleManagedConnection oracleManagedConnection = new OracleManagedConnection(xAConnection);
            oracleManagedConnection.setPasswordCredential(passwordCredential);
            oracleManagedConnection.setLogWriter(this.getLogWriter());
            return oracleManagedConnection;
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        try {
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            return this.xaDataSource.getLogWriter();
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
    }

    private PasswordCredential getPasswordCredential(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (subject != null) {
            Set set = subject.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential != null ? class$javax$resource$spi$security$PasswordCredential : (class$javax$resource$spi$security$PasswordCredential = OracleManagedConnectionFactory.class$("javax.resource.spi.security.PasswordCredential")));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                PasswordCredential passwordCredential = (PasswordCredential)iterator.next();
                if (!passwordCredential.getManagedConnectionFactory().equals((Object)this)) continue;
                return passwordCredential;
            }
            throw new SecurityException("Can not find user/password information", RAERR_MCF_GET_PCRED);
        }
        if (connectionRequestInfo == null) {
            return null;
        }
        OracleConnectionRequestInfo oracleConnectionRequestInfo = (OracleConnectionRequestInfo)connectionRequestInfo;
        PasswordCredential passwordCredential = new PasswordCredential(oracleConnectionRequestInfo.getUser(), oracleConnectionRequestInfo.getPassword().toCharArray());
        passwordCredential.setManagedConnectionFactory((ManagedConnectionFactory)this);
        return passwordCredential;
    }

    public String getXADataSourceName() {
        return this.xaDataSourceName;
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        PasswordCredential passwordCredential = this.getPasswordCredential(subject, connectionRequestInfo);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            OracleManagedConnection oracleManagedConnection;
            Object e = iterator.next();
            if (!(e instanceof OracleManagedConnection) || !(oracleManagedConnection = (OracleManagedConnection)e).getPasswordCredential().equals((Object)passwordCredential)) continue;
            return oracleManagedConnection;
        }
        return null;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        try {
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            this.xaDataSource.setLogWriter(printWriter);
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
    }

    public void setXADataSourceName(String string) {
        this.xaDataSourceName = string;
    }

    private void setupXADataSource() throws ResourceException {
        try {
            Object object;
            InitialContext initialContext = null;
            try {
                object = System.getProperties();
                initialContext = new InitialContext((Hashtable<?, ?>)object);
            }
            catch (java.lang.SecurityException securityException) {}
            if (initialContext == null) {
                initialContext = new InitialContext();
            }
            if ((object = (XADataSource)initialContext.lookup(this.xaDataSourceName)) == null) {
                throw new ResourceAdapterInternalException("Invalid XADataSource object");
            }
            this.xaDataSource = object;
        }
        catch (NamingException namingException) {
            ResourceException resourceException = new ResourceException("NamingException: " + namingException.getMessage());
            resourceException.setLinkedException((Exception)namingException);
            throw resourceException;
        }
    }
}

