/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RawCommonAccessor;

class RawAccessor
extends RawCommonAccessor {
    static final int MAXLENGTH_NEW = 2000;
    static final int MAXLENGTH_OLD = 255;

    RawAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl) throws SQLException {
        this.init(oracleStatement, 23, 15, s, bl);
        this.initForDataAccess(n2, n, null);
    }

    RawAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s) throws SQLException {
        this.init(oracleStatement, 23, 15, s, false);
        this.initForDescribe(23, n, bl, n2, n3, n4, n5, n6, s, null);
        int n7 = oracleStatement.maxFieldSize;
        if (n7 > 0 && (n == 0 || n7 < n)) {
            n = n7;
        }
        this.initForDataAccess(0, n, null);
    }

    byte[] getBytes(int n) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            int n2 = this.columnIndex + this.byteLength * n;
            byArray = new byte[s];
            System.arraycopy(this.rowSpaceByte, n2 + 2, byArray, 0, s);
        }
        return byArray;
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.externalType = n;
        }
        this.internalTypeMaxLength = this.statement.connection.getVersionNumber() >= 8000 ? 2000 : 255;
        if (n2 > 0 && n2 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n2;
        }
        this.byteLength = this.internalTypeMaxLength + 2;
    }
}

