/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4C8TTILob;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

class T4C8TTIClob
extends T4C8TTILob {
    int[] nBytes = new int[1];
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Tue_Feb_27_15:19:28_PST_2007";

    T4C8TTIClob(T4CMAREngine t4CMAREngine, T4CTTIoer t4CTTIoer) {
        super(t4CMAREngine, t4CTTIoer);
    }

    boolean close(byte[] byArray) throws SQLException, IOException {
        boolean bl = false;
        bl = this._close(byArray, 65536);
        return bl;
    }

    Datum createTemporaryLob(Connection connection, boolean bl, int n) throws SQLException, IOException {
        return this.createTemporaryLob(connection, bl, n, (short)1);
    }

    Datum createTemporaryLob(Connection connection, boolean bl, int n, short s) throws SQLException, IOException {
        if (n == 12) {
            DatabaseError.throwSqlException(158);
        }
        CLOB cLOB = null;
        this.initializeLobdef();
        this.lobops = 272L;
        this.sourceLobLocator = new byte[86];
        this.sourceLobLocator[1] = 84;
        this.lobamt = 10L;
        this.sendLobamt = true;
        this.sourceOffset = s == 1 ? 1L : 2L;
        this.destinationOffset = 112L;
        this.destinationLength = n;
        this.nullO2U = true;
        this.characterSet = s == 2 ? this.meg.conv.getNCharSetId() : this.meg.conv.getServerCharSetId();
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        if (this.sourceLobLocator != null) {
            cLOB = new CLOB((OracleConnection)connection, this.sourceLobLocator);
        }
        return cLOB;
    }

    boolean isOpen(byte[] byArray) throws SQLException, IOException {
        boolean bl = false;
        bl = this._isOpen(byArray, 69632);
        return bl;
    }

    boolean open(byte[] byArray, int n) throws SQLException, IOException {
        boolean bl = false;
        int n2 = 2;
        if (n == 0) {
            n2 = 1;
        }
        bl = this._open(byArray, n2, 32768);
        return bl;
    }

    long read(byte[] byArray, long l, long l2, boolean bl, char[] cArray) throws SQLException, IOException {
        long l3 = 0L;
        byte[] byArray2 = null;
        this.initializeLobdef();
        if ((byArray[6] & 0x80) == 128) {
            this.varWidthChar = true;
        }
        byArray2 = this.varWidthChar ? new byte[(int)l2 * 2] : new byte[(int)l2 * 3];
        if ((byArray[7] & 0x40) > 0) {
            this.littleEndianClob = true;
        }
        this.lobops = 2L;
        this.sourceLobLocator = byArray;
        this.sourceOffset = l;
        this.lobamt = l2;
        this.sendLobamt = true;
        this.outBuffer = byArray2;
        this.marshalFunHeader();
        this.marshalOlobops();
        this.receiveReply();
        long l4 = this.lobamt;
        long l5 = 0L;
        if (this.varWidthChar) {
            if (this.meg.versionNumber < 10101) {
                DBConversion cfr_ignored_0 = this.meg.conv;
                DBConversion.ucs2BytesToJavaChars(byArray2, byArray2.length, cArray);
            } else if (this.littleEndianClob) {
                CharacterSet.convertAL16UTF16LEBytesToJavaChars(byArray2, 0, cArray, 0, (int)this.lobBytesRead, true);
            } else {
                CharacterSet.convertAL16UTF16BytesToJavaChars(byArray2, 0, cArray, 0, (int)this.lobBytesRead, true);
            }
        } else if (!bl) {
            this.nBytes[0] = (int)this.lobBytesRead;
            this.meg.conv.CHARBytesToJavaChars(byArray2, 0, cArray, 0, this.nBytes, cArray.length);
        } else {
            this.nBytes[0] = (int)this.lobBytesRead;
            this.meg.conv.NCHARBytesToJavaChars(byArray2, 0, cArray, 0, this.nBytes, cArray.length);
        }
        return l4;
    }

    long write(byte[] byArray, long l, boolean bl, char[] cArray, long l2, long l3) throws SQLException, IOException {
        boolean bl2 = false;
        if ((byArray[6] & 0x80) == 128) {
            bl2 = true;
        }
        if ((byArray[7] & 0x40) == 64) {
            this.littleEndianClob = true;
        }
        long l4 = 0L;
        byte[] byArray2 = null;
        if (bl2) {
            byArray2 = new byte[(int)l3 * 2];
            if (this.meg.versionNumber < 10101) {
                DBConversion cfr_ignored_0 = this.meg.conv;
                DBConversion.javaCharsToUcs2Bytes(cArray, (int)l2, byArray2, 0, (int)l3);
            } else if (this.littleEndianClob) {
                CharacterSet.convertJavaCharsToAL16UTF16LEBytes(cArray, (int)l2, byArray2, 0, (int)l3);
            } else {
                CharacterSet.convertJavaCharsToAL16UTF16Bytes(cArray, (int)l2, byArray2, 0, (int)l3);
            }
        } else {
            byArray2 = new byte[(int)l3 * 3];
            l4 = !bl ? (long)this.meg.conv.javaCharsToCHARBytes(cArray, (int)l2, byArray2, 0, (int)l3) : (long)this.meg.conv.javaCharsToNCHARBytes(cArray, (int)l2, byArray2, 0, (int)l3);
        }
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = byArray;
        this.sourceOffset = l;
        this.lobamt = l3;
        this.sendLobamt = true;
        this.inBuffer = byArray2;
        this.marshalFunHeader();
        this.marshalOlobops();
        if (bl2) {
            if (this.meg.versionNumber < 10101) {
                this.lobd.marshalLobDataUB2(byArray2, 0L, l3);
            } else {
                this.lobd.marshalLobData(byArray2, 0L, l3 * 2L);
            }
        } else {
            this.lobd.marshalLobData(byArray2, 0L, l4);
        }
        this.receiveReply();
        long l5 = this.lobamt;
        return l5;
    }
}

