/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIMsg;

class T4CTTIoer
extends T4CTTIMsg {
    final int MAXERRBUF = 512;
    long curRowNumber;
    int retCode;
    int arrayElemWError;
    int arrayElemErrno;
    int currCursorID;
    short errorPosition;
    short sqlType;
    byte oerFatal;
    short flags;
    short userCursorOpt;
    short upiParam;
    short warningFlag;
    int osError;
    short stmtNumber;
    short callNumber;
    int pad1;
    long successIters;
    int partitionId;
    int tableId;
    int slotNumber;
    long rba;
    long blockNumber;
    int warnLength = 0;
    int warnFlag = 0;
    int[] errorLength = new int[1];
    byte[] errorMsg;
    T4CConnection connection;
    static final int ORA1403 = 1403;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Tue_Feb_27_15:19:31_PST_2007";

    T4CTTIoer(T4CMAREngine t4CMAREngine) {
        this.setMarshalingEngine(t4CMAREngine);
    }

    T4CTTIoer(T4CMAREngine t4CMAREngine, T4CConnection t4CConnection) {
        this.setMarshalingEngine(t4CMAREngine);
        this.connection = t4CConnection;
    }

    int getCurRowNumber() throws SQLException {
        return (int)this.curRowNumber;
    }

    int getRetCode() {
        return this.retCode;
    }

    void init() {
        this.retCode = 0;
        this.errorMsg = null;
    }

    void print(int n, int n2, int n3) throws SQLException {
        System.out.println("**** Retcode is " + this.retCode);
        if (this.retCode != 0) {
            System.out.println("**** Error Message: " + this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true));
        } else if (this.warnFlag != 0) {
            OracleLog.print(this, n, n2, n3, "Warning Message: " + this.meg.conv.CharBytesToString(this.errorMsg, this.warnLength, true));
        }
    }

    void processError() throws SQLException {
        this.processError(true);
    }

    void processError(OracleStatement oracleStatement) throws SQLException {
        this.processError(true, oracleStatement);
    }

    void processError(boolean bl) throws SQLException {
        this.processError(bl, null);
    }

    void processError(boolean bl, OracleStatement oracleStatement) throws SQLException {
        int n;
        if (this.retCode != 0) {
            switch (this.retCode) {
                case 28: 
                case 600: 
                case 1012: 
                case 3113: 
                case 3114: {
                    this.connection.internalClose();
                    break;
                }
            }
            if (bl) {
                DatabaseError.throwSqlException(this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true), DatabaseError.ErrorToSQLState(this.retCode), this.retCode);
            } else {
                return;
            }
        }
        if (!bl) {
            return;
        }
        if ((this.warningFlag & 1) == 1 && (((n = this.warningFlag & 0xFFFFFFFE) & 0x20) == 32 || (n & 4) == 4)) {
            throw DatabaseError.newSqlException(110);
        }
        if (this.connection != null && this.connection.plsqlCompilerWarnings && (this.flags & 4) == 4) {
            oracleStatement.foundPlsqlCompilerWarning();
        }
    }

    void processWarning() throws SQLException {
        if (this.retCode != 0) {
            throw DatabaseError.newSqlWarning(this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true), DatabaseError.ErrorToSQLState(this.retCode), this.retCode);
        }
    }

    int unmarshal() throws IOException, SQLException {
        if (this.meg.versionNumber >= 10000) {
            short s;
            this.connection.endToEndECIDSequenceNumber = s = (short)this.meg.unmarshalUB2();
        }
        this.curRowNumber = this.meg.unmarshalUB4();
        this.retCode = this.meg.unmarshalUB2();
        this.arrayElemWError = this.meg.unmarshalUB2();
        this.arrayElemErrno = this.meg.unmarshalUB2();
        this.currCursorID = this.meg.unmarshalUB2();
        this.errorPosition = this.meg.unmarshalSB2();
        this.sqlType = this.meg.unmarshalUB1();
        this.oerFatal = this.meg.unmarshalSB1();
        this.flags = this.meg.unmarshalSB2();
        this.userCursorOpt = this.meg.unmarshalSB2();
        this.upiParam = this.meg.unmarshalUB1();
        this.warningFlag = this.meg.unmarshalUB1();
        this.rba = this.meg.unmarshalUB4();
        this.partitionId = this.meg.unmarshalUB2();
        this.tableId = this.meg.unmarshalUB1();
        this.blockNumber = this.meg.unmarshalUB4();
        this.slotNumber = this.meg.unmarshalUB2();
        this.osError = this.meg.unmarshalSWORD();
        this.stmtNumber = this.meg.unmarshalUB1();
        this.callNumber = this.meg.unmarshalUB1();
        this.pad1 = this.meg.unmarshalUB2();
        this.successIters = this.meg.unmarshalUB4();
        if (this.retCode != 0) {
            this.errorMsg = this.meg.unmarshalCLRforREFS();
            this.errorLength[0] = this.errorMsg.length;
        }
        return this.currCursorID;
    }

    void unmarshalWarning() throws IOException, SQLException {
        this.retCode = this.meg.unmarshalUB2();
        this.warnLength = this.meg.unmarshalUB2();
        this.warnFlag = this.meg.unmarshalUB2();
        if (this.retCode != 0 && this.warnLength > 0) {
            this.errorMsg = this.meg.unmarshalCHR(this.warnLength);
            this.errorLength[0] = this.warnLength;
        }
    }
}

