/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import java.util.Vector;

public final class UnpickleContext {
    byte[] image;
    int absoluteOffset;
    int beginOffset;
    int markedOffset;
    Vector patches;
    long[] ldsOffsets;
    boolean[] nullIndicators;
    boolean bigEndian;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Tue_Feb_27_15:19:23_PST_2007";

    public UnpickleContext() {
    }

    public UnpickleContext(byte[] byArray, int n, boolean[] blArray, long[] lArray, boolean bl) {
        this.image = byArray;
        this.beginOffset = n;
        this.absoluteOffset = n;
        this.bigEndian = bl;
        this.nullIndicators = blArray;
        this.patches = null;
        this.ldsOffsets = lArray;
    }

    public int absoluteOffset() throws SQLException {
        return this.absoluteOffset;
    }

    public byte[] image() throws SQLException {
        return this.image;
    }

    public boolean isNull(int n) {
        return this.nullIndicators[n];
    }

    public void mark() throws SQLException {
        this.markedOffset = this.absoluteOffset;
    }

    public void markAndSkip() throws SQLException {
        this.markedOffset = this.absoluteOffset + 4;
        this.absoluteOffset = this.beginOffset + (int)this.readLong();
    }

    public void markAndSkip(long l) throws SQLException {
        this.markedOffset = this.absoluteOffset;
        this.absoluteOffset = this.beginOffset + (int)l;
    }

    public int offset() throws SQLException {
        return this.absoluteOffset - this.beginOffset;
    }

    public byte readByte() throws SQLException {
        try {
            byte by = this.image[this.absoluteOffset];
            Object var3_2 = null;
            ++this.absoluteOffset;
            return by;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.absoluteOffset;
            throw throwable;
        }
    }

    public byte[] readBytes(int n) throws SQLException {
        try {
            byte[] byArray = new byte[n];
            System.arraycopy(this.image, this.absoluteOffset, byArray, 0, n);
            byte[] byArray2 = byArray;
            Object var4_4 = null;
            this.absoluteOffset += n;
            return byArray2;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.absoluteOffset += n;
            throw throwable;
        }
    }

    public byte[] readLengthBytes() throws SQLException {
        long l = this.readLong();
        return this.readBytes((int)l);
    }

    public long readLong() throws SQLException {
        try {
            long l = (((this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF)) * 256 + (this.image[this.absoluteOffset + 2] & 0xFF)) * 256 + (this.image[this.absoluteOffset + 3] & 0xFF);
            Object var4_2 = null;
            this.absoluteOffset += 4;
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.absoluteOffset += 4;
            throw throwable;
        }
    }

    public byte[] readPtrBytes() throws SQLException {
        byte[] byArray = new byte[(this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF) + 2];
        System.arraycopy(this.image, this.absoluteOffset, byArray, 0, byArray.length);
        this.absoluteOffset += byArray.length;
        return byArray;
    }

    public short readShort() throws SQLException {
        try {
            short s = (short)((this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF));
            Object var3_2 = null;
            this.absoluteOffset += 2;
            return s;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.absoluteOffset += 2;
            throw throwable;
        }
    }

    public byte[] readVarNumBytes() throws SQLException {
        byte[] byArray = new byte[this.image[this.absoluteOffset] & 0xFF];
        try {
            System.arraycopy(this.image, this.absoluteOffset + 1, byArray, 0, byArray.length);
        }
        finally {
            Object var3_2 = null;
            this.absoluteOffset += 22;
        }
        return byArray;
    }

    public void reset() throws SQLException {
        this.absoluteOffset = this.markedOffset;
    }

    public void skipBytes(int n) throws SQLException {
        if (n >= 0) {
            this.absoluteOffset += n;
        }
    }

    public void skipLengthBytes() throws SQLException {
        long l = this.readLong();
        this.absoluteOffset = (int)((long)this.absoluteOffset + l);
    }

    public void skipPtrBytes() throws SQLException {
        this.absoluteOffset += (this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF) + 2;
    }

    public void skipTo(int n) throws SQLException {
        if (n > this.absoluteOffset - this.beginOffset) {
            this.absoluteOffset = this.beginOffset + n;
        }
    }

    public void skipTo(long l) throws SQLException {
        if (l > (long)(this.absoluteOffset - this.beginOffset)) {
            this.absoluteOffset = this.beginOffset + (int)l;
        }
    }
}

