/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.sql.PooledConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleConnectionCacheImpl;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionCacheTimeOutThread
extends Thread
implements Serializable {
    private OracleConnectionCacheImpl occi = null;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Tue_Feb_27_15:19:32_PST_2007";

    OracleConnectionCacheTimeOutThread(OracleConnectionCacheImpl oracleConnectionCacheImpl) throws SQLException {
        this.occi = oracleConnectionCacheImpl;
    }

    public void run() {
        long l = 0L;
        long l2 = 0L;
        boolean bl = true;
        try {
            while (bl) {
                l = this.occi.getCacheTimeToLiveTimeout();
                if (l > 0L) {
                    this.runTimeToLiveTimeOut(l);
                }
                if ((l2 = this.occi.getCacheInactivityTimeout()) > 0L) {
                    this.runInactivityTimeOut(l2);
                }
                Thread.sleep(this.occi.getThreadWakeUpInterval() * 1000L);
                if (this.occi.cache != null && (l > 0L || l2 > 0L)) continue;
                bl = false;
            }
        }
        catch (SQLException sQLException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public void runInactivityTimeOut(long l) throws SQLException {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = l * 1000L;
        OraclePooledConnection oraclePooledConnection = null;
        try {
            if (this.occi.cache != null && this.occi.cache.size() > 0 && this.occi.cacheSize > this.occi._MIN_LIMIT) {
                Enumeration enumeration = this.occi.cache.elements();
                while (this.occi.cacheSize > this.occi._MIN_LIMIT && enumeration.hasMoreElements()) {
                    oraclePooledConnection = (OraclePooledConnection)enumeration.nextElement();
                    l2 = oraclePooledConnection.getLastAccessedTime();
                    l3 = System.currentTimeMillis();
                    if (l3 - l2 <= l4) continue;
                    try {
                        this.occi.closeSingleConnection(oraclePooledConnection, false);
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    public void runTimeToLiveTimeOut(long l) throws SQLException {
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        PooledConnection pooledConnection = null;
        n = this.occi.getActiveSize();
        if (n > 0) {
            Enumeration enumeration = this.occi.activeCache.keys();
            while (enumeration.hasMoreElements()) {
                pooledConnection = (PooledConnection)enumeration.nextElement();
                Connection connection = ((OraclePooledConnection)pooledConnection).getLogicalHandle();
                if (connection != null) {
                    l3 = ((OracleConnection)connection).getStartTime();
                }
                if ((l2 = System.currentTimeMillis()) - l3 <= l * 1000L) continue;
                try {
                    ((OracleConnection)connection).cancel();
                }
                catch (SQLException sQLException) {}
                try {
                    if (!connection.getAutoCommit()) {
                        ((OracleConnection)connection).rollback();
                    }
                }
                catch (SQLException sQLException) {}
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

