/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.pool.OracleConnectionCache;
import oracle.jdbc.pool.OracleConnectionCacheImpl;

public class OracleConnectionEventListener
implements ConnectionEventListener,
Serializable {
    static final int _CLOSED_EVENT = 1;
    static final int _ERROROCCURED_EVENT = 2;
    private DataSource dataSource = null;
    protected long lastCleanupTime = -1L;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Tue_Feb_27_15:19:32_PST_2007";

    public OracleConnectionEventListener() {
        this.dataSource = null;
    }

    public OracleConnectionEventListener(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected synchronized void cleanupInvalidConnections(SQLException sQLException) {
        try {
            long l;
            long l2;
            if (this.dataSource != null && this.dataSource instanceof OracleConnectionCacheImpl && (l2 = System.currentTimeMillis()) - this.lastCleanupTime > (l = ((OracleConnectionCacheImpl)this.dataSource).getConnectionCleanupInterval()) * 1000L) {
                if (((OracleConnectionCacheImpl)this.dataSource).isFatalConnectionError(sQLException)) {
                    ((OracleConnectionCacheImpl)this.dataSource).closeConnections();
                }
                this.lastCleanupTime = System.currentTimeMillis();
            }
        }
        catch (Exception exception) {}
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        try {
            if (this.dataSource != null && this.dataSource instanceof OracleConnectionCache) {
                ((OracleConnectionCache)this.dataSource).reusePooledConnection((PooledConnection)connectionEvent.getSource());
            }
        }
        catch (SQLException sQLException) {}
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        try {
            if (this.dataSource != null && this.dataSource instanceof OracleConnectionCache) {
                ((OracleConnectionCache)this.dataSource).closePooledConnection((PooledConnection)connectionEvent.getSource());
            }
        }
        catch (SQLException sQLException) {
            this.cleanupInvalidConnections(sQLException);
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

