/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class MarkerPacket
extends Packet
implements SQLnetDef {
    protected int type;
    protected int data;
    private boolean isReset;
    private boolean isBreak;

    public MarkerPacket(Packet packet) throws NetException {
        super(packet);
        this.type = this.buffer[8];
        switch (this.type) {
            case 0: {
                this.data = 0;
                this.isBreak = true;
                break;
            }
            case 1: {
                this.data = this.buffer[10];
                if (this.data == 2) {
                    this.isReset = true;
                    break;
                }
                this.isBreak = true;
                break;
            }
            default: {
                throw new NetException(205);
            }
        }
    }

    public MarkerPacket(SessionAtts sessionAtts, int n) {
        super(sessionAtts);
        this.createBuffer(11, 12, 0);
        this.buffer[4] = 12;
        this.buffer[8] = 1;
        this.buffer[10] = (byte)n;
    }

    public boolean isBreakPkt() {
        return this.isBreak;
    }
}

