/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.util.ArrayList;
import java.util.Hashtable;
import oracle.net.nl.InvalidSyntaxException;
import oracle.net.nl.NLException;
import oracle.net.nl.NVFactory;
import oracle.net.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.resolver.HostnameNamingAdapter;
import oracle.net.resolver.NamingAdapterInterface;
import oracle.net.resolver.TNSNamesNamingAdapter;

public class NameResolver {
    private String tnsAdmin;
    private String[] readPath;
    private Hashtable adapterHash;
    private static final boolean DEBUG = false;
    private static final String[] DEFAULT_SEARCH_PATH = new String[]{"TNSNAMES", "HOSTNAME"};
    private static final String TNS_ADMIN_PROPERTY = "oracle.net.tns_admin";
    private static final String READ_PATH_PROPERTY = "oracle.net.names.directory_path";

    protected NameResolver(String string) throws NetException {
        this.tnsAdmin = string;
        this.bootNameResolver();
    }

    private void addAdapters() {
        if (this.adapterHash == null) {
            this.adapterHash = new Hashtable();
        }
        this.adapterHash.put("TNSNAMES", new TNSNamesNamingAdapter(this.tnsAdmin));
        this.adapterHash.put("HOSTNAME", new HostnameNamingAdapter());
    }

    private void bootNameResolver() throws NetException {
        if (this.tnsAdmin != null) {
            this.setReadPath();
            this.addAdapters();
        }
    }

    private boolean checkForValidAdapter(String string) {
        int n = DEFAULT_SEARCH_PATH.length;
        int n2 = 0;
        while (n2 < n) {
            if (DEFAULT_SEARCH_PATH[n2].equalsIgnoreCase(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String[] getUserReadPath() throws NetException {
        String string = "NameResolver.getUserReadPath: ";
        String[] stringArray = null;
        String string2 = System.getProperty(READ_PATH_PROPERTY);
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).length() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        if (stringBuffer.charAt(0) == '(') {
            stringBuffer.insert(0, "(path=").append(')');
        } else {
            stringBuffer.insert(0, "(path=(").append("))");
        }
        String string3 = stringBuffer.toString();
        NVFactory nVFactory = new NVFactory();
        NVPair nVPair = null;
        try {
            nVPair = nVFactory.createNVPair(string3);
            if (nVPair.getRHSType() != NVPair.RHS_LIST || nVPair.getListType() != NVPair.LIST_COMMASEP) {
                throw new NetException(121, " Read path specified is " + string2);
            }
            int n = nVPair.getListSize();
            String[] stringArray2 = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray2[n2] = nVPair.getListElement(n2).getName();
                ++n2;
            }
            stringArray = stringArray2;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new NetException(121, " Read path specified is " + string2);
        }
        catch (NLException nLException) {
            throw new NetException(121, " Read path specified is " + string3);
        }
        return stringArray;
    }

    public String resolveName(String string) throws NetException {
        String string2 = "NameResolver.resolveName: ";
        if (string == null) {
            throw new NetException(120);
        }
        String string3 = string.trim();
        if (string3.length() == 0) {
            throw new NetException(120);
        }
        String string4 = null;
        if (this.tnsAdmin == null) {
            HostnameNamingAdapter hostnameNamingAdapter = new HostnameNamingAdapter();
            string4 = hostnameNamingAdapter.resolve(string3);
            return string4;
        }
        NamingAdapterInterface namingAdapterInterface = null;
        int n = 0;
        while (string4 == null && n < this.readPath.length) {
            namingAdapterInterface = (NamingAdapterInterface)this.adapterHash.get(this.readPath[n]);
            try {
                string4 = namingAdapterInterface.resolve(string3);
            }
            catch (NetException netException) {
                // empty catch block
            }
            ++n;
        }
        if (string4 == null) {
            throw new NetException(122, "\"" + string + "\"");
        }
        return string4;
    }

    private void setDefaultPath() {
        this.readPath = DEFAULT_SEARCH_PATH;
    }

    private void setReadPath() throws NetException {
        String string = "NameResolver.setReadPath: ";
        int n = 0;
        String[] stringArray = this.getUserReadPath();
        if (stringArray == null) {
            this.setDefaultPath();
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        n = 0;
        while (n < stringArray.length) {
            if (this.checkForValidAdapter(stringArray[n])) {
                String string2 = stringArray[n];
                if (!arrayList.contains(string2 = string2.toUpperCase())) {
                    arrayList.add(stringArray[n].toUpperCase());
                }
            }
            ++n;
        }
        int n2 = arrayList.size();
        if (n2 == 0) {
            throw new NetException(121, " The Read path did not contain any valid adapters.");
        }
        this.readPath = new String[n2];
        arrayList.toArray(this.readPath);
    }
}

