/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barbecue;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractSvgRenderer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.output.OutputException;

public class BarbecueRenderer
extends JRAbstractSvgRenderer {
    private static final long serialVersionUID = 1L;
    private Barcode barcode;
    private RotationEnum rotation;

    public BarbecueRenderer(Barcode barcode) {
        this.barcode = barcode;
    }

    @Override
    public Dimension2D getDimension(JasperReportsContext jasperReportsContext) {
        if (this.rotation != null) {
            switch (this.rotation) {
                case LEFT: 
                case RIGHT: {
                    return new Dimension((int)this.barcode.getSize().getHeight(), (int)this.barcode.getSize().getWidth());
                }
            }
            return this.barcode.getSize();
        }
        return this.barcode.getSize();
    }

    @Override
    public Dimension2D getDimension() {
        return this.getDimension(DefaultJasperReportsContext.getInstance());
    }

    @Override
    public void render(Graphics2D grx, Rectangle2D rectangle) {
        this.render(DefaultJasperReportsContext.getInstance(), grx, rectangle);
    }

    @Override
    public void render(JasperReportsContext jasperReportsContext, Graphics2D grx, Rectangle2D rectangle) {
        AffineTransform origTransform = grx.getTransform();
        try {
            try {
                block20: {
                    Dimension size;
                    block19: {
                        size = this.barcode.getSize();
                        if (this.rotation == null) break block19;
                        switch (BarbecueRenderer.$SWITCH_TABLE$net$sf$jasperreports$engine$type$RotationEnum()[this.rotation.ordinal()]) {
                            case 2: {
                                grx.translate(rectangle.getX(), rectangle.getY() + rectangle.getHeight());
                                grx.rotate(-1.5707963267948966);
                                if (rectangle.getWidth() != size.getHeight() || rectangle.getHeight() != size.getWidth()) {
                                    grx.scale(rectangle.getHeight() / size.getWidth(), rectangle.getWidth() / size.getHeight());
                                    break;
                                }
                                break block20;
                            }
                            case 3: {
                                grx.translate(rectangle.getX() + rectangle.getWidth(), rectangle.getY());
                                grx.rotate(1.5707963267948966);
                                if (rectangle.getWidth() != size.getHeight() || rectangle.getHeight() != size.getWidth()) {
                                    grx.scale(rectangle.getHeight() / size.getWidth(), rectangle.getWidth() / size.getHeight());
                                    break;
                                }
                                break block20;
                            }
                            case 4: {
                                grx.translate(rectangle.getX() + rectangle.getWidth(), rectangle.getY() + rectangle.getHeight());
                                grx.rotate(Math.PI);
                                if (rectangle.getWidth() != size.getWidth() || rectangle.getHeight() != size.getHeight()) {
                                    grx.scale(rectangle.getWidth() / size.getWidth(), rectangle.getHeight() / size.getHeight());
                                    break;
                                }
                                break block20;
                            }
                            case 1: {
                                grx.translate(rectangle.getX(), rectangle.getY());
                                if (rectangle.getWidth() == size.getWidth() && rectangle.getHeight() == size.getHeight()) break block20;
                                grx.scale(rectangle.getWidth() / size.getWidth(), rectangle.getHeight() / size.getHeight());
                            }
                            default: {
                                break;
                            }
                            {
                            }
                        }
                        break block20;
                    }
                    grx.translate(rectangle.getX(), rectangle.getY());
                    if (rectangle.getWidth() != size.getWidth() || rectangle.getHeight() != size.getHeight()) {
                        grx.scale(rectangle.getWidth() / size.getWidth(), rectangle.getHeight() / size.getHeight());
                    }
                }
                this.barcode.draw(grx, 0, 0);
            }
            catch (OutputException e) {
                throw new JRRuntimeException(e);
            }
        }
        finally {
            grx.setTransform(origTransform);
        }
    }

    public void setRotation(RotationEnum rotation) {
        this.rotation = rotation;
    }
}

