/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.actions;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import net.sf.jasperreports.components.headertoolbar.actions.AbstractVerifiableTableAction;
import net.sf.jasperreports.components.sort.FilterTypeDateOperatorsEnum;
import net.sf.jasperreports.components.sort.FilterTypesEnum;
import net.sf.jasperreports.components.sort.actions.FilterCommand;
import net.sf.jasperreports.components.sort.actions.FilterData;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.web.actions.ActionException;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.commands.ResetInCacheCommand;

public class FilterAction
extends AbstractVerifiableTableAction {
    public FilterData getFilterData() {
        return (FilterData)this.columnData;
    }

    public void setFilterData(FilterData filterData) {
        this.columnData = filterData;
    }

    @Override
    public void performAction() throws ActionException {
        JRDesignDatasetRun datasetRun = (JRDesignDatasetRun)this.table.getDatasetRun();
        String datasetName = datasetRun.getDatasetName();
        JasperDesignCache cache = JasperDesignCache.getInstance(this.getJasperReportsContext(), this.getReportContext());
        JasperDesign jasperDesign = cache.getJasperDesign(this.targetUri);
        JRDesignDataset dataset = (JRDesignDataset)jasperDesign.getDatasetMap().get(datasetName);
        try {
            this.getCommandStack().execute(new ResetInCacheCommand(new FilterCommand(this.getJasperReportsContext(), dataset, this.getFilterData()), this.getJasperReportsContext(), this.getReportContext(), this.targetUri));
        }
        catch (CommandException e) {
            throw new ActionException(e.getMessage());
        }
    }

    @Override
    public void verify() throws ActionException {
        block27: {
            FilterData fd = this.getFilterData();
            if (fd.isClearFilter()) {
                return;
            }
            if (fd.getFilterType() == null || fd.getFilterType().length() == 0) {
                this.errors.addAndThrow("net.sf.jasperreports.components.headertoolbar.actions.filter.invalid.type");
            }
            FilterTypesEnum filterType = FilterTypesEnum.getByName(fd.getFilterType());
            Locale locale = (Locale)this.getReportContext().getParameterValue("REPORT_LOCALE");
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (FilterTypesEnum.DATE.equals(filterType) || FilterTypesEnum.TIME.equals(filterType)) {
                FilterTypeDateOperatorsEnum dateEnum = FilterTypeDateOperatorsEnum.getByEnumConstantName(fd.getFilterTypeOperator());
                boolean containsBetween = FilterTypeDateOperatorsEnum.IS_BETWEEN.equals(dateEnum) || FilterTypeDateOperatorsEnum.IS_NOT_BETWEEN.equals(dateEnum);
                try {
                    DateFormat df = formatFactory.createDateFormat(fd.getFilterPattern(), locale, null);
                    df.setLenient(false);
                    if (containsBetween) {
                        if (fd.getFieldValueStart() == null || fd.getFieldValueStart().length() == 0) {
                            this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.filter.empty.start.date");
                        } else {
                            try {
                                df.parse(fd.getFieldValueStart());
                            }
                            catch (ParseException e) {
                                this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.filter.invalid.start.date", fd.getFieldValueStart());
                            }
                        }
                        if (fd.getFieldValueEnd() != null && fd.getFieldValueEnd().length() > 0) {
                            try {
                                df.parse(fd.getFieldValueEnd());
                            }
                            catch (ParseException e) {
                                this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.filter.invalid.end.date", fd.getFieldValueEnd());
                            }
                        } else {
                            this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.filter.empty.end.date");
                        }
                        break block27;
                    }
                    if (fd.getFieldValueStart() == null || fd.getFieldValueStart().length() == 0) {
                        this.errors.addAndThrow("net.sf.jasperreports.components.headertoolbar.actions.filter.empty.date");
                    }
                    try {
                        df.parse(fd.getFieldValueStart());
                    }
                    catch (ParseException e) {
                        this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.filter.invalid.date", fd.getFieldValueStart());
                    }
                }
                catch (IllegalArgumentException e) {
                    this.errors.addAndThrow("net.sf.jasperreports.components.headertoolbar.actions.filter.invalid.pattern");
                }
            } else if (filterType == FilterTypesEnum.NUMERIC) {
                if (fd.getFieldValueStart() == null || fd.getFieldValueStart().trim().length() == 0) {
                    this.errors.addAndThrow("net.sf.jasperreports.components.headertoolbar.actions.filter.empty.number");
                }
                try {
                    NumberFormat nf = this.createNumberFormat(fd.getFilterPattern(), locale);
                    nf.parse(fd.getFieldValueStart());
                    if (fd.getFieldValueEnd() != null && fd.getFieldValueEnd().length() > 0) {
                        try {
                            nf.parse(fd.getFieldValueEnd());
                        }
                        catch (ParseException e) {
                            this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.filter.invalid.number", fd.getFieldValueEnd());
                        }
                    }
                }
                catch (ParseException e) {
                    this.errors.add("net.sf.jasperreports.components.headertoolbar.actions.filter.invalid.number", fd.getFieldValueStart());
                }
                catch (IllegalArgumentException e) {
                    this.errors.addAndThrow("net.sf.jasperreports.components.headertoolbar.actions.filter.invalid.pattern");
                }
            }
        }
    }
}

