/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ColumnValuesIterator;
import net.sf.jasperreports.data.cache.DataSnapshotException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.IndexedDataSource;

public class ColumnValuesDataSource
implements JRRewindableDataSource,
IndexedDataSource {
    private int size;
    private int iteratorIndex;
    private Map<String, ColumnValuesIterator> iterators;

    public ColumnValuesDataSource(String[] fieldNames, int size, ColumnValues[] values) {
        if (fieldNames == null || values == null || fieldNames.length != values.length) {
            throw new IllegalArgumentException();
        }
        this.iterators = new LinkedHashMap<String, ColumnValuesIterator>();
        this.size = size;
        int i = 0;
        while (i < fieldNames.length) {
            if (size != values[i].size()) {
                throw new IllegalArgumentException();
            }
            this.iterators.put(fieldNames[i], values[i].iterator());
            ++i;
        }
        this.iteratorIndex = 0;
    }

    @Override
    public boolean next() throws JRException {
        if (this.iteratorIndex >= this.size) {
            return false;
        }
        ++this.iteratorIndex;
        for (ColumnValuesIterator iterator : this.iterators.values()) {
            iterator.next();
        }
        return true;
    }

    @Override
    public Object getFieldValue(JRField field) throws DataSnapshotException {
        ColumnValuesIterator iterator = this.iterators.get(field.getName());
        if (iterator == null) {
            throw new DataSnapshotException("Field " + field.getName() + " not present in data snapshot");
        }
        Object value = iterator.get();
        if (value != null && !field.getValueClass().isInstance(value)) {
            throw new DataSnapshotException("Field " + field.getName() + " of type " + field.getValueClassName() + " has snapshot value of type " + value.getClass().getName());
        }
        return value;
    }

    @Override
    public void moveFirst() {
        this.iteratorIndex = 0;
        for (ColumnValuesIterator iterator : this.iterators.values()) {
            iterator.moveFirst();
        }
    }

    @Override
    public int getRecordIndex() {
        return this.iteratorIndex - 1;
    }
}

