/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import net.sf.jasperreports.engine.JRPrintElement;

public class PrintElementId {
    private final int sourceElementId;
    private final int printId;

    public static PrintElementId forElement(JRPrintElement element) {
        return new PrintElementId(element.getSourceElementId(), element.getPrintElementId());
    }

    public static boolean matches(JRPrintElement element1, JRPrintElement element2) {
        return PrintElementId.matches(element1.getSourceElementId(), element1.getPrintElementId(), element2.getSourceElementId(), element2.getPrintElementId());
    }

    protected static boolean matches(int sourceElementId1, int printId1, int sourceElementId2, int printId2) {
        return sourceElementId1 != 0 && sourceElementId1 == sourceElementId2 && printId1 != 0 && printId1 == printId2;
    }

    public PrintElementId(int sourceElementId, int printId) {
        this.sourceElementId = sourceElementId;
        this.printId = printId;
    }

    public int getSourceElementId() {
        return this.sourceElementId;
    }

    public int getPrintId() {
        return this.printId;
    }

    public int hashCode() {
        return 2039 * this.sourceElementId + 1021 * this.printId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PrintElementId)) {
            return false;
        }
        PrintElementId id = (PrintElementId)obj;
        return this.sourceElementId == id.sourceElementId && this.printId == id.printId;
    }

    public String toString() {
        return String.valueOf(this.sourceElementId) + "#" + this.printId;
    }

    public boolean matches(PrintElementId id) {
        return PrintElementId.matches(this.sourceElementId, this.printId, id.sourceElementId, id.printId);
    }

    public boolean matches(JRPrintElement element) {
        return PrintElementId.matches(this.sourceElementId, this.printId, element.getSourceElementId(), element.getPrintElementId());
    }
}

