/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.util.ElementsVisitorUtils;

public class JRBaseElementGroup
implements JRElementGroup,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected List<JRChild> children = new ArrayList<JRChild>();
    protected JRElementGroup elementGroup;

    protected JRBaseElementGroup() {
    }

    protected JRBaseElementGroup(JRElementGroup elementGrp, JRBaseObjectFactory factory) {
        factory.put(elementGrp, this);
        List<JRChild> list = elementGrp.getChildren();
        if (list != null && list.size() > 0) {
            int i = 0;
            while (i < list.size()) {
                JRChild child = list.get(i);
                child = (JRChild)factory.getVisitResult(child);
                this.children.add(child);
                ++i;
            }
        }
        this.elementGroup = (JRElementGroup)factory.getVisitResult(elementGrp.getElementGroup());
    }

    @Override
    public List<JRChild> getChildren() {
        return this.children;
    }

    @Override
    public JRElementGroup getElementGroup() {
        return this.elementGroup;
    }

    public static JRElement[] getElements(List<JRChild> children) {
        JRElement[] elements = null;
        if (children != null) {
            ArrayList<JRElement> allElements = new ArrayList<JRElement>();
            JRChild child = null;
            JRElement[] childElementArray = null;
            int i = 0;
            while (i < children.size()) {
                child = children.get(i);
                if (child instanceof JRElement) {
                    allElements.add((JRElement)child);
                } else if (child instanceof JRElementGroup && (childElementArray = ((JRElementGroup)child).getElements()) != null) {
                    allElements.addAll(Arrays.asList(childElementArray));
                }
                ++i;
            }
            elements = new JRElement[allElements.size()];
            allElements.toArray(elements);
        }
        return elements;
    }

    @Override
    public JRElement[] getElements() {
        return JRBaseElementGroup.getElements(this.children);
    }

    public static JRElement getElementByKey(JRElement[] elements, String key) {
        JRElement element = null;
        if (key != null && elements != null) {
            int i = 0;
            while (element == null && i < elements.length) {
                JRElement elem = elements[i];
                if (key.equals(elem.getKey())) {
                    element = elem;
                } else if (elem instanceof JRFrame) {
                    element = ((JRFrame)elem).getElementByKey(key);
                } else if (elem instanceof JRCrosstab) {
                    element = ((JRCrosstab)elem).getElementByKey(key);
                }
                ++i;
            }
        }
        return element;
    }

    @Override
    public JRElement getElementByKey(String key) {
        return JRBaseElementGroup.getElementByKey(this.getElements(), key);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitElementGroup(this);
        if (ElementsVisitorUtils.visitDeepElements(visitor)) {
            ElementsVisitorUtils.visitElements(visitor, this.children);
        }
    }

    @Override
    public Object clone() {
        JRBaseElementGroup clone = null;
        try {
            clone = (JRBaseElementGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        if (this.children != null) {
            clone.children = new ArrayList<JRChild>(this.children.size());
            int i = 0;
            while (i < this.children.size()) {
                clone.children.add((JRChild)this.children.get(i).clone(clone));
                ++i;
            }
        }
        return clone;
    }

    @Override
    public Object clone(JRElementGroup parentGroup) {
        JRBaseElementGroup clone = (JRBaseElementGroup)this.clone();
        clone.elementGroup = parentGroup;
        return clone;
    }
}

