/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameters;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.PrintElementVisitor;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBaseParagraph;
import net.sf.jasperreports.engine.base.JRBasePrintElement;
import net.sf.jasperreports.engine.fill.TextFormat;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;

public class JRBasePrintText
extends JRBasePrintElement
implements JRPrintText {
    private static final long serialVersionUID = 10200L;
    protected String text = "";
    protected Integer textTruncateIndex;
    protected short[] lineBreakOffsets;
    protected String textTruncateSuffix;
    protected Object value;
    protected float lineSpacingFactor;
    protected float leadingOffset;
    protected HorizontalAlignEnum horizontalAlignmentValue;
    protected VerticalAlignEnum verticalAlignmentValue;
    protected RotationEnum rotationValue;
    protected RunDirectionEnum runDirectionValue = RunDirectionEnum.LTR;
    protected float textHeight;
    protected String markup;
    protected TextFormat textFormat;
    protected String anchorName;
    protected String linkType;
    protected String linkTarget;
    protected String hyperlinkReference;
    protected String hyperlinkAnchor;
    protected Integer hyperlinkPage;
    protected String hyperlinkTooltip;
    protected JRPrintHyperlinkParameters hyperlinkParameters;
    protected int bookmarkLevel = 0;
    protected JRLineBox lineBox = new JRBaseLineBox(this);
    protected JRParagraph paragraph = new JRBaseParagraph(this);
    protected String fontName;
    protected Boolean isBold;
    protected Boolean isItalic;
    protected Boolean isUnderline;
    protected Boolean isStrikeThrough;
    protected Float fontsize;
    protected String pdfFontName;
    protected String pdfEncoding;
    protected Boolean isPdfEmbedded;
    protected String valueClassName;
    protected String pattern;
    protected String formatFactoryClass;
    protected String localeCode;
    protected String timeZoneId;
    private int PSEUDO_SERIAL_VERSION_UID = 50502;
    private Byte horizontalAlignment;
    private Byte verticalAlignment;
    private Byte rotation;
    private Byte lineSpacing;
    private LineSpacingEnum lineSpacingValue;
    private Byte border;
    private Byte topBorder;
    private Byte leftBorder;
    private Byte bottomBorder;
    private Byte rightBorder;
    private Color borderColor;
    private Color topBorderColor;
    private Color leftBorderColor;
    private Color bottomBorderColor;
    private Color rightBorderColor;
    private Integer padding;
    private Integer topPadding;
    private Integer leftPadding;
    private Integer bottomPadding;
    private Integer rightPadding;
    private Boolean isStyledText;
    private byte hyperlinkType;
    private byte hyperlinkTarget;
    private byte runDirection;
    private Integer fontSize;

    public JRBasePrintText(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public String getText() {
        return JRStyledTextUtil.getInstance(DefaultJasperReportsContext.getInstance()).getTruncatedText(this);
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public Integer getTextTruncateIndex() {
        return this.textTruncateIndex;
    }

    @Override
    public void setTextTruncateIndex(Integer textTruncateIndex) {
        this.textTruncateIndex = textTruncateIndex;
    }

    @Override
    public String getTextTruncateSuffix() {
        return this.textTruncateSuffix;
    }

    @Override
    public void setTextTruncateSuffix(String textTruncateSuffix) {
        this.textTruncateSuffix = textTruncateSuffix;
    }

    @Override
    public short[] getLineBreakOffsets() {
        return this.lineBreakOffsets;
    }

    @Override
    public void setLineBreakOffsets(short[] lineBreakOffsets) {
        this.lineBreakOffsets = lineBreakOffsets;
    }

    @Override
    public String getFullText() {
        String fullText = this.text;
        if (this.textTruncateIndex == null && this.textTruncateSuffix != null) {
            fullText = String.valueOf(fullText) + this.textTruncateSuffix;
        }
        return fullText;
    }

    @Override
    public String getOriginalText() {
        return this.text;
    }

    @Override
    public JRStyledText getStyledText(JRStyledTextAttributeSelector attributeSelector) {
        return JRStyledTextUtil.getInstance(DefaultJasperReportsContext.getInstance()).getStyledText(this, attributeSelector);
    }

    @Override
    public JRStyledText getFullStyledText(JRStyledTextAttributeSelector attributeSelector) {
        if (this.getFullText() == null) {
            return null;
        }
        return JRStyledTextParser.getInstance().getStyledText(attributeSelector.getStyledTextAttributes(this), this.getFullText(), !"none".equals(this.getMarkup()), JRStyledTextAttributeSelector.getTextLocale(this));
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    @Override
    public void setLineSpacingFactor(float lineSpacingFactor) {
        this.lineSpacingFactor = lineSpacingFactor;
    }

    @Override
    public float getLeadingOffset() {
        return this.leadingOffset;
    }

    @Override
    public void setLeadingOffset(float leadingOffset) {
        this.leadingOffset = leadingOffset;
    }

    @Override
    public HorizontalAlignEnum getHorizontalAlignmentValue() {
        return JRStyleResolver.getHorizontalAlignmentValue(this);
    }

    @Override
    public HorizontalAlignEnum getOwnHorizontalAlignmentValue() {
        return this.horizontalAlignmentValue;
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignEnum horizontalAlignmentValue) {
        this.horizontalAlignmentValue = horizontalAlignmentValue;
    }

    @Override
    public VerticalAlignEnum getVerticalAlignmentValue() {
        return JRStyleResolver.getVerticalAlignmentValue(this);
    }

    @Override
    public VerticalAlignEnum getOwnVerticalAlignmentValue() {
        return this.verticalAlignmentValue;
    }

    @Override
    public void setVerticalAlignment(VerticalAlignEnum verticalAlignmentValue) {
        this.verticalAlignmentValue = verticalAlignmentValue;
    }

    @Override
    public RotationEnum getRotationValue() {
        return JRStyleResolver.getRotationValue(this);
    }

    @Override
    public RotationEnum getOwnRotationValue() {
        return this.rotationValue;
    }

    @Override
    public void setRotation(RotationEnum rotationValue) {
        this.rotationValue = rotationValue;
    }

    @Override
    public RunDirectionEnum getRunDirectionValue() {
        return this.runDirectionValue;
    }

    @Override
    public void setRunDirection(RunDirectionEnum runDirectionValue) {
        this.runDirectionValue = runDirectionValue;
    }

    @Override
    public float getTextHeight() {
        return this.textHeight;
    }

    @Override
    public void setTextHeight(float textHeight) {
        this.textHeight = textHeight;
    }

    @Override
    public LineSpacingEnum getLineSpacingValue() {
        return this.getParagraph().getLineSpacing();
    }

    @Override
    public LineSpacingEnum getOwnLineSpacingValue() {
        return this.getParagraph().getOwnLineSpacing();
    }

    @Override
    public void setLineSpacing(LineSpacingEnum lineSpacing) {
        this.getParagraph().setLineSpacing(lineSpacing);
    }

    @Override
    public String getMarkup() {
        return JRStyleResolver.getMarkup(this);
    }

    @Override
    public String getOwnMarkup() {
        return this.markup;
    }

    @Override
    public void setMarkup(String markup) {
        this.markup = markup;
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public JRParagraph getParagraph() {
        return this.paragraph;
    }

    public void copyBox(JRLineBox lineBox) {
        this.lineBox = lineBox.clone(this);
    }

    public void copyParagraph(JRParagraph paragraph) {
        this.paragraph = paragraph.clone(this);
    }

    @Override
    public JRFont getFont() {
        return this;
    }

    @Override
    public void setFont(JRFont font) {
        this.fontName = font.getOwnFontName();
        this.isBold = font.isOwnBold();
        this.isItalic = font.isOwnItalic();
        this.isUnderline = font.isOwnUnderline();
        this.isStrikeThrough = font.isOwnStrikeThrough();
        this.fontSize = font.getOwnFontSize();
        this.pdfFontName = font.getOwnPdfFontName();
        this.pdfEncoding = font.getOwnPdfEncoding();
        this.isPdfEmbedded = font.isOwnPdfEmbedded();
    }

    @Override
    public void setTextFormat(TextFormat textFormat) {
        this.textFormat = textFormat;
    }

    @Override
    public String getAnchorName() {
        return this.anchorName;
    }

    @Override
    public void setAnchorName(String anchorName) {
        this.anchorName = anchorName;
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this.getLinkType());
    }

    @Override
    public void setHyperlinkType(HyperlinkTypeEnum hyperlinkType) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(hyperlinkType));
    }

    @Override
    public HyperlinkTargetEnum getHyperlinkTargetValue() {
        return JRHyperlinkHelper.getHyperlinkTargetValue(this.getLinkTarget());
    }

    @Override
    public void setHyperlinkTarget(HyperlinkTargetEnum hyperlinkTarget) {
        this.setLinkTarget(JRHyperlinkHelper.getLinkTarget(hyperlinkTarget));
    }

    @Override
    public String getHyperlinkReference() {
        return this.hyperlinkReference;
    }

    @Override
    public void setHyperlinkReference(String hyperlinkReference) {
        this.hyperlinkReference = hyperlinkReference;
    }

    @Override
    public String getHyperlinkAnchor() {
        return this.hyperlinkAnchor;
    }

    @Override
    public void setHyperlinkAnchor(String hyperlinkAnchor) {
        this.hyperlinkAnchor = hyperlinkAnchor;
    }

    @Override
    public Integer getHyperlinkPage() {
        return this.hyperlinkPage;
    }

    @Override
    public void setHyperlinkPage(Integer hyperlinkPage) {
        this.hyperlinkPage = hyperlinkPage;
    }

    public void setHyperlinkPage(String hyperlinkPage) {
        this.hyperlinkPage = Integer.valueOf(hyperlinkPage);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    @Override
    public void setBookmarkLevel(int bookmarkLevel) {
        this.bookmarkLevel = bookmarkLevel;
    }

    @Override
    public String getFontName() {
        return JRStyleResolver.getFontName(this);
    }

    @Override
    public String getOwnFontName() {
        return this.fontName;
    }

    @Override
    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    @Override
    public boolean isBold() {
        return JRStyleResolver.isBold(this);
    }

    @Override
    public Boolean isOwnBold() {
        return this.isBold;
    }

    @Override
    public void setBold(boolean isBold) {
        this.setBold(isBold ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setBold(Boolean isBold) {
        this.isBold = isBold;
    }

    @Override
    public boolean isItalic() {
        return JRStyleResolver.isItalic(this);
    }

    @Override
    public Boolean isOwnItalic() {
        return this.isItalic;
    }

    @Override
    public void setItalic(boolean isItalic) {
        this.setItalic(isItalic ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setItalic(Boolean isItalic) {
        this.isItalic = isItalic;
    }

    @Override
    public boolean isUnderline() {
        return JRStyleResolver.isUnderline(this);
    }

    @Override
    public Boolean isOwnUnderline() {
        return this.isUnderline;
    }

    @Override
    public void setUnderline(boolean isUnderline) {
        this.setUnderline(isUnderline ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setUnderline(Boolean isUnderline) {
        this.isUnderline = isUnderline;
    }

    @Override
    public boolean isStrikeThrough() {
        return JRStyleResolver.isStrikeThrough(this);
    }

    @Override
    public Boolean isOwnStrikeThrough() {
        return this.isStrikeThrough;
    }

    @Override
    public void setStrikeThrough(boolean isStrikeThrough) {
        this.setStrikeThrough(isStrikeThrough ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setStrikeThrough(Boolean isStrikeThrough) {
        this.isStrikeThrough = isStrikeThrough;
    }

    @Override
    public float getFontsize() {
        return JRStyleResolver.getFontsize(this);
    }

    @Override
    public Float getOwnFontsize() {
        return this.fontsize;
    }

    @Override
    public void setFontSize(Float fontSize) {
        this.fontsize = fontSize;
    }

    @Override
    public int getFontSize() {
        return (int)this.getFontsize();
    }

    @Override
    public Integer getOwnFontSize() {
        return this.fontsize == null ? null : Integer.valueOf(this.fontsize.intValue());
    }

    @Override
    public void setFontSize(int fontSize) {
        this.setFontSize(Float.valueOf(fontSize));
    }

    @Override
    public void setFontSize(Integer fontSize) {
        this.setFontSize(fontSize == null ? null : Float.valueOf(fontSize.floatValue()));
    }

    @Override
    public String getPdfFontName() {
        return JRStyleResolver.getPdfFontName(this);
    }

    @Override
    public String getOwnPdfFontName() {
        return this.pdfFontName;
    }

    @Override
    public void setPdfFontName(String pdfFontName) {
        this.pdfFontName = pdfFontName;
    }

    @Override
    public String getPdfEncoding() {
        return JRStyleResolver.getPdfEncoding(this);
    }

    @Override
    public String getOwnPdfEncoding() {
        return this.pdfEncoding;
    }

    @Override
    public void setPdfEncoding(String pdfEncoding) {
        this.pdfEncoding = pdfEncoding;
    }

    @Override
    public boolean isPdfEmbedded() {
        return JRStyleResolver.isPdfEmbedded(this);
    }

    @Override
    public Boolean isOwnPdfEmbedded() {
        return this.isPdfEmbedded;
    }

    @Override
    public void setPdfEmbedded(boolean isPdfEmbedded) {
        this.setPdfEmbedded(isPdfEmbedded ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setPdfEmbedded(Boolean isPdfEmbedded) {
        this.isPdfEmbedded = isPdfEmbedded;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public String getValueClassName() {
        return this.valueClassName;
    }

    public void setValueClassName(String valueClassName) {
        this.valueClassName = valueClassName;
    }

    @Override
    public String getFormatFactoryClass() {
        return this.formatFactoryClass;
    }

    public void setFormatFactoryClass(String formatFactoryClass) {
        this.formatFactoryClass = formatFactoryClass;
    }

    @Override
    public String getLocaleCode() {
        return this.localeCode;
    }

    public void setLocaleCode(String localeCode) {
        this.localeCode = localeCode;
    }

    @Override
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    @Override
    public JRPrintHyperlinkParameters getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    @Override
    public void setHyperlinkParameters(JRPrintHyperlinkParameters hyperlinkParameters) {
        this.hyperlinkParameters = hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRPrintHyperlinkParameter parameter) {
        if (this.hyperlinkParameters == null) {
            this.hyperlinkParameters = new JRPrintHyperlinkParameters();
        }
        this.hyperlinkParameters.addParameter(parameter);
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    @Override
    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    @Override
    public String getLinkTarget() {
        return this.linkTarget;
    }

    @Override
    public void setLinkTarget(String linkTarget) {
        this.linkTarget = linkTarget;
    }

    @Override
    public String getHyperlinkTooltip() {
        return this.hyperlinkTooltip;
    }

    @Override
    public void setHyperlinkTooltip(String hyperlinkTooltip) {
        this.hyperlinkTooltip = hyperlinkTooltip;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.horizontalAlignmentValue = HorizontalAlignEnum.getByValue(this.horizontalAlignment);
            this.verticalAlignmentValue = VerticalAlignEnum.getByValue(this.verticalAlignment);
            this.rotationValue = RotationEnum.getByValue(this.rotation);
            this.runDirectionValue = RunDirectionEnum.getByValue(this.runDirection);
            this.lineSpacingValue = LineSpacingEnum.getByValue(this.lineSpacing);
            this.horizontalAlignment = null;
            this.verticalAlignment = null;
            this.rotation = null;
            this.lineSpacing = null;
        }
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        if (this.isStyledText != null) {
            this.markup = this.isStyledText != false ? "styled" : "none";
            this.isStyledText = null;
        }
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(HyperlinkTypeEnum.getByValue(this.hyperlinkType));
        }
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(this.hyperlinkTarget));
        }
        if (this.paragraph == null) {
            this.paragraph = new JRBaseParagraph(this);
            this.paragraph.setLineSpacing(this.lineSpacingValue);
            this.lineSpacingValue = null;
        }
        if (this.PSEUDO_SERIAL_VERSION_UID < 50502) {
            this.fontsize = this.fontSize == null ? null : Float.valueOf(this.fontSize.floatValue());
            this.fontSize = null;
        }
    }

    @Override
    public <T> void accept(PrintElementVisitor<T> visitor, T arg) {
        visitor.visit(this, arg);
    }
}

