/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.TabStopAlignEnum;

public class DocxParagraphHelper
extends BaseHelper {
    private static final String HORIZONTAL_ALIGN_LEFT = "left";
    private static final String HORIZONTAL_ALIGN_RIGHT = "right";
    private static final String HORIZONTAL_ALIGN_CENTER = "center";
    private static final String HORIZONTAL_ALIGN_BOTH = "both";
    private static final String TAB_STOP_ALIGN_LEFT = "left";
    private static final String TAB_STOP_ALIGN_RIGHT = "right";
    private static final String TAB_STOP_ALIGN_CENTER = "center";
    protected static final int LINE_SPACING_FACTOR = 240;
    private boolean pageBreak;

    public DocxParagraphHelper(JasperReportsContext jasperReportsContext, Writer writer, boolean pageBreak) {
        super(jasperReportsContext, writer);
        this.pageBreak = pageBreak;
    }

    public void exportProps(JRStyle style) {
        this.exportPropsHeader(null, style.getParagraph());
        this.exportAlignment(DocxParagraphHelper.getHorizontalAlignment(style.getOwnHorizontalAlignmentValue()));
        this.exportTabStops(style.getParagraph());
        this.exportLineSpacing(style.getParagraph());
        this.exportPropsFooter();
    }

    public void exportProps(JRPrintText text) {
        this.exportPropsHeader(text.getStyle() == null ? null : text.getStyle().getName(), text.getParagraph());
        this.exportAlignment(DocxParagraphHelper.getHorizontalAlignment(text.getOwnHorizontalAlignmentValue()));
        this.exportTabStops(text.getParagraph());
        this.exportLineSpacing(text.getParagraph());
        this.exportPropsFooter();
    }

    private void exportPropsHeader(String styleNameReference, JRParagraph paragraph) {
        this.write("      <w:pPr>\n");
        if (styleNameReference != null) {
            this.write("        <w:pStyle w:val=\"" + styleNameReference + "\"/>\n");
        }
        this.write("      <w:ind");
        if (paragraph.getOwnFirstLineIndent() != null) {
            this.write(" w:firstLine=\"" + LengthUtil.twip(paragraph.getOwnFirstLineIndent().intValue()) + "\"");
        }
        if (paragraph.getOwnLeftIndent() != null) {
            this.write(" w:left=\"" + LengthUtil.twip(paragraph.getOwnLeftIndent().intValue()) + "\"");
        }
        if (paragraph.getOwnRightIndent() != null) {
            this.write(" w:right=\"" + LengthUtil.twip(paragraph.getOwnRightIndent().intValue()) + "\"");
        }
        this.write("/>\n");
        if (this.pageBreak) {
            this.write("        <w:pageBreakBefore/>\n");
            this.pageBreak = false;
        }
    }

    private void exportAlignment(String horizontalAlignment) {
        if (horizontalAlignment != null) {
            this.write("   <w:jc w:val=\"" + horizontalAlignment + "\" />\n");
        }
    }

    private void exportTabStops(JRParagraph paragraph) {
        TabStop[] tabStops = paragraph.getTabStops();
        if (tabStops != null && tabStops.length > 0) {
            this.write("   <w:tabs>\n");
            int i = 0;
            while (i < tabStops.length) {
                TabStop tabStop = tabStops[i];
                this.write("   <w:tab w:pos=\"" + LengthUtil.twip(tabStop.getPosition()) + "\" w:val=\"" + DocxParagraphHelper.getTabStopAlignment(tabStop.getAlignment()) + "\"/>\n");
                ++i;
            }
            this.write("   </w:tabs>\n");
        }
    }

    private void exportLineSpacing(JRParagraph paragraph) {
        if (paragraph.getOwnLineSpacing() != null || paragraph.getOwnLineSpacingSize() != null || paragraph.getOwnSpacingBefore() != null || paragraph.getOwnSpacingAfter() != null) {
            String lineSpacing;
            String lineRule;
            switch (paragraph.getLineSpacing()) {
                case AT_LEAST: {
                    lineRule = "atLeast";
                    lineSpacing = String.valueOf(LengthUtil.twip(paragraph.getLineSpacingSize().floatValue()));
                    break;
                }
                case FIXED: {
                    lineRule = "exact";
                    lineSpacing = String.valueOf(LengthUtil.twip(paragraph.getLineSpacingSize().floatValue()));
                    break;
                }
                case PROPORTIONAL: {
                    lineRule = "auto";
                    lineSpacing = String.valueOf((int)(paragraph.getLineSpacingSize().floatValue() * 240.0f));
                    break;
                }
                case DOUBLE: {
                    lineRule = "auto";
                    lineSpacing = String.valueOf(480);
                    break;
                }
                case ONE_AND_HALF: {
                    lineRule = "auto";
                    lineSpacing = String.valueOf(360);
                    break;
                }
                default: {
                    lineRule = "auto";
                    lineSpacing = String.valueOf(240);
                }
            }
            this.write("   <w:spacing w:lineRule=\"" + lineRule + "\" w:line=\"" + lineSpacing + "\"");
            this.write(" w:after=\"" + LengthUtil.twip(paragraph.getSpacingAfter().intValue()) + "\"");
            this.write(" w:before=\"" + LengthUtil.twip(paragraph.getSpacingBefore().intValue()) + "\"/>\n");
        }
    }

    private void exportPropsFooter() {
        this.write("      </w:pPr>\n");
    }

    public void exportEmptyParagraph() {
        this.exportEmptyParagraph(false, 0L, null);
    }

    public void exportEmptyParagraph(boolean startPage, long bookmarkIndex, String pageAnchor) {
        this.write("     <w:p><w:pPr><w:pStyle w:val=\"EMPTY_CELL_STYLE\"/>\n");
        if (this.pageBreak) {
            this.write("        <w:pageBreakBefore/>\n");
            this.pageBreak = false;
        }
        this.write("     </w:pPr>");
        if (startPage) {
            this.write("<w:bookmarkStart w:id=\"" + bookmarkIndex);
            this.write("\" w:name=\"" + pageAnchor);
            this.write("\"/><w:bookmarkEnd w:id=\"" + bookmarkIndex);
            this.write("\"/>");
        }
        this.write("</w:p>\n");
    }

    public static String getHorizontalAlignment(HorizontalAlignEnum horizontalAlignment) {
        if (horizontalAlignment != null) {
            switch (horizontalAlignment) {
                case RIGHT: {
                    return "right";
                }
                case CENTER: {
                    return "center";
                }
                case JUSTIFIED: {
                    return HORIZONTAL_ALIGN_BOTH;
                }
            }
            return "left";
        }
        return null;
    }

    public static String getTabStopAlignment(TabStopAlignEnum alignment) {
        if (alignment != null) {
            switch (alignment) {
                case RIGHT: {
                    return "right";
                }
                case CENTER: {
                    return "center";
                }
            }
            return "left";
        }
        return null;
    }

    public void exportEmptyPage(String pageAnchor, long bookmarkIndex, boolean twice) {
        if (twice) {
            this.write("  <w:p><w:r><w:br w:type=\"page\"/></w:r></w:p>\n");
        }
        this.write("  <w:p><w:bookmarkStart w:id=\"" + bookmarkIndex);
        this.write("\" w:name=\"" + pageAnchor);
        this.write("\"/><w:bookmarkEnd w:id=\"" + bookmarkIndex);
        this.write("\"/></w:p>\n");
        this.write("  <w:p><w:r><w:br w:type=\"page\"/></w:r></w:p>\n");
    }
}

