/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.tabulator;

import net.sf.jasperreports.engine.export.tabulator.Column;
import net.sf.jasperreports.engine.export.tabulator.DimensionControl;
import net.sf.jasperreports.engine.export.tabulator.DimensionEntries;
import net.sf.jasperreports.engine.export.tabulator.EntryIndexes;
import net.sf.jasperreports.engine.export.tabulator.Row;
import net.sf.jasperreports.engine.export.tabulator.Tabulator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Table {
    private static final Log log = LogFactory.getLog(Tabulator.class);
    protected final Tabulator tabulator;
    protected DimensionEntries<Column> columns;
    protected DimensionEntries<Row> rows;

    public Table(Tabulator tabulator) {
        this.tabulator = tabulator;
        ColumnsControl columnsControl = new ColumnsControl();
        this.columns = new DimensionEntries<Column>(columnsControl);
        RowsControl rowsControl = new RowsControl();
        this.rows = new DimensionEntries<Row>(rowsControl);
        if (log.isTraceEnabled()) {
            log.trace((Object)("created columns " + this.columns + " and rows " + this.rows));
        }
    }

    public void removeColumn(Column column, Column prevColumn) {
        this.columns.removeEntry(column, prevColumn);
        for (Row row : this.rows.getEntries()) {
            row.setCell(column, null);
        }
        ((ColumnsControl)this.columns.getControl()).indexes.recycle(column.index);
    }

    public void removeRow(Row row, Row prevRow) {
        this.rows.removeEntry(row, prevRow);
    }

    public DimensionEntries<Column> getColumns() {
        return this.columns;
    }

    public DimensionEntries<Row> getRows() {
        return this.rows;
    }

    protected class ColumnsControl
    implements DimensionControl<Column> {
        protected EntryIndexes indexes = new EntryIndexes();

        @Override
        public Column entryKey(int coord) {
            return Table.this.tabulator.columnKey(coord);
        }

        @Override
        public Column createEntry(int startCoord, int endCoord) {
            Column column = new Column(startCoord);
            column.endCoord = endCoord;
            column.index = this.indexes.next();
            return column;
        }

        @Override
        public void entrySplit(Column splitEntry, Column newEntry) {
            Table.this.tabulator.columnSplit(Table.this, splitEntry, newEntry);
        }
    }

    protected class RowsControl
    implements DimensionControl<Row> {
        protected RowsControl() {
        }

        @Override
        public Row entryKey(int coord) {
            return Table.this.tabulator.rowKey(coord);
        }

        @Override
        public Row createEntry(int startCoord, int endCoord) {
            Row row = new Row(startCoord);
            row.endCoord = endCoord;
            return row;
        }

        @Override
        public void entrySplit(Row splitEntry, Row newEntry) {
            Table.this.tabulator.rowSplit(Table.this, splitEntry, newEntry);
        }
    }
}

