/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.type.ModeEnum;

public final class StyleUtil {
    private static final StyleUtil INSTANCE = new StyleUtil();
    private static final BoxSideSelector RIGHT_SIDE = new BoxSideSelector(){

        @Override
        public JRBoxPen getPen(JRLineBox lineBox) {
            return lineBox.getRightPen();
        }

        @Override
        public Integer getPadding(JRLineBox lineBox) {
            return lineBox.getOwnRightPadding();
        }
    };
    private static final BoxSideSelector TOP_SIDE = new BoxSideSelector(){

        @Override
        public JRBoxPen getPen(JRLineBox lineBox) {
            return lineBox.getTopPen();
        }

        @Override
        public Integer getPadding(JRLineBox lineBox) {
            return lineBox.getOwnTopPadding();
        }
    };
    private static final BoxSideSelector LEFT_SIDE = new BoxSideSelector(){

        @Override
        public JRBoxPen getPen(JRLineBox lineBox) {
            return lineBox.getLeftPen();
        }

        @Override
        public Integer getPadding(JRLineBox lineBox) {
            return lineBox.getOwnLeftPadding();
        }
    };
    private static final BoxSideSelector BOTTOM_SIDE = new BoxSideSelector(){

        @Override
        public JRBoxPen getPen(JRLineBox lineBox) {
            return lineBox.getBottomPen();
        }

        @Override
        public Integer getPadding(JRLineBox lineBox) {
            return lineBox.getOwnBottomPadding();
        }
    };

    public static StyleUtil instance() {
        return INSTANCE;
    }

    private StyleUtil() {
    }

    public ModeEnum resolveMode(JRStyleContainer styleContainer) {
        JRStyle style = styleContainer.getStyle();
        if (style != null) {
            ModeEnum styleMode = style.getOwnModeValue();
            if (styleMode != null) {
                JRConditionalStyle[] conditionalStyles = style.getConditionalStyles();
                if (conditionalStyles != null) {
                    JRConditionalStyle[] jRConditionalStyleArray = conditionalStyles;
                    int n = conditionalStyles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JRConditionalStyle conditionalStyle = jRConditionalStyleArray[n2];
                        ModeEnum conditionalMode = conditionalStyle.getOwnModeValue();
                        if (conditionalMode != null && conditionalMode != styleMode) {
                            return null;
                        }
                        ++n2;
                    }
                }
                return styleMode;
            }
            return this.resolveMode(style);
        }
        if (styleContainer.getStyleNameReference() != null) {
            return null;
        }
        return ModeEnum.TRANSPARENT;
    }

    public ModeEnum resolveElementMode(JRElement element) {
        ModeEnum elementMode = element.getOwnModeValue();
        if (elementMode != null) {
            return elementMode;
        }
        return this.resolveMode(element);
    }

    public boolean hasBox(JRBoxContainer boxContainer) {
        return this.hasBorder(boxContainer, RIGHT_SIDE) || this.hasBorder(boxContainer, TOP_SIDE) || this.hasBorder(boxContainer, LEFT_SIDE) || this.hasBorder(boxContainer, BOTTOM_SIDE) || this.hasPadding(boxContainer, RIGHT_SIDE) || this.hasPadding(boxContainer, TOP_SIDE) || this.hasPadding(boxContainer, LEFT_SIDE) || this.hasPadding(boxContainer, BOTTOM_SIDE);
    }

    protected boolean hasBorder(JRBoxContainer boxContainer, BoxSideSelector selector) {
        JRLineBox lineBox = boxContainer.getLineBox();
        Float rightLineWidth = selector.getPen(lineBox).getOwnLineWidth();
        if (rightLineWidth != null) {
            return rightLineWidth.floatValue() > 0.0f;
        }
        Float lineWidth = lineBox.getPen().getOwnLineWidth();
        if (lineWidth != null) {
            return lineWidth.floatValue() > 0.0f;
        }
        JRStyle style = boxContainer.getStyle();
        if (style != null) {
            return this.hasBorder(style, selector);
        }
        String styleReference = boxContainer.getStyleNameReference();
        return styleReference != null;
    }

    protected boolean hasPadding(JRBoxContainer boxContainer, BoxSideSelector penSelector) {
        JRLineBox lineBox = boxContainer.getLineBox();
        Integer sidePadding = penSelector.getPadding(lineBox);
        if (sidePadding != null) {
            return sidePadding > 0;
        }
        Integer padding = lineBox.getOwnPadding();
        if (padding != null) {
            return padding > 0;
        }
        JRStyle style = boxContainer.getStyle();
        if (style != null) {
            return this.hasPadding(style, penSelector);
        }
        String styleReference = boxContainer.getStyleNameReference();
        return styleReference != null;
    }

    private static interface BoxSideSelector {
        public JRBoxPen getPen(JRLineBox var1);

        public Integer getPadding(JRLineBox var1);
    }
}

