/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.message;

import com.sun.deploy.Environment;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.Waiter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.Message;
import sun.plugin2.message.Queue;
import sun.plugin2.message.transport.Transport;
import sun.plugin2.util.PojoUtil;
import sun.plugin2.util.SystemUtil;

public class Pipe {
    private static final boolean DEBUG = SystemUtil.isDebug();
    private static final String logDir = Environment.getenv((String)"JPI2_PIPE_LOGDIR");
    private final PrintWriter logger;
    private Transport transport;
    private boolean initiatingSide;
    private static final ThreadLocal perThreadMsgQueue = new ThreadLocal();
    private Queue mainMsgQueue = new Queue();
    private Map activeConversations = new HashMap();
    private int curConversationID;
    private volatile boolean shouldShutdown;
    private volatile boolean shutdownComplete;

    public Pipe(Transport transport, boolean bl) {
        Object object;
        if (DEBUG) {
            System.out.println("Pipe.cstr: " + transport.toString());
        }
        PrintWriter printWriter = null;
        if (logDir != null && !bl) {
            object = new File(logDir);
            if (((File)object).isDirectory() && ((File)object).canWrite()) {
                try {
                    File file = new File(logDir, "pipe_" + System.currentTimeMillis());
                    file.createNewFile();
                    printWriter = new PrintWriter(new FileWriter(file));
                    Trace.println((String)("Pipe traffic logged in " + file.getAbsolutePath()));
                }
                catch (IOException iOException) {
                    Trace.println((String)"Failed to setup pipe logger.");
                    Trace.ignored((Throwable)iOException);
                }
            } else {
                Trace.println((String)"Ignore pipe log request, JPI2_PIPE_LOGDIR should be a writable directory.");
            }
        }
        this.logger = printWriter;
        this.transport = transport;
        this.initiatingSide = bl;
        object = new WorkerThread();
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    protected void finalize() throws Exception {
        if (this.logger != null) {
            this.logger.close();
        }
    }

    public static boolean isLoggingEnabled() {
        return logDir != null;
    }

    private void logMessage(Message message, boolean bl) {
        if (this.logger != null) {
            String string = bl ? "-> Sent " : "<- Recv ";
            string = string + " at " + System.currentTimeMillis();
            string = string + "\n  by thread[" + Thread.currentThread().getId() + "]" + Thread.currentThread().getName();
            string = string + "\n  " + message.getClass().getCanonicalName();
            string = string + "\n" + PojoUtil.toJson(message);
            this.logger.println(string);
            this.logger.flush();
        }
    }

    public void send(Message message) throws IOException {
        this.logMessage(message, true);
        this.transport.write(message);
    }

    public Message poll() throws IOException {
        this.checkForShutdown();
        return this.mainMsgQueue.get();
    }

    public Message poll(Conversation conversation) throws IOException {
        this.checkForShutdown();
        Queue queue = (Queue)perThreadMsgQueue.get();
        if (queue == null) {
            return null;
        }
        return queue.get(-1, conversation);
    }

    public Message receive(final long l) throws InterruptedException, IOException {
        this.checkForShutdown();
        try {
            return (Message)Waiter.runAndWait((Waiter.WaiterTask)new Waiter.WaiterTask(){

                public Object run() throws InterruptedException {
                    return Pipe.this.mainMsgQueue.waitForMessage(l);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof InterruptedException) {
                throw (InterruptedException)exception;
            }
            return null;
        }
    }

    public Message receive(final long l, final Conversation conversation) throws InterruptedException, IOException {
        this.checkForShutdown();
        Queue queue = (Queue)this.activeConversations.get(conversation);
        final Queue queue2 = (Queue)perThreadMsgQueue.get();
        if (queue == null || queue != queue2) {
            Trace.ignored((Throwable)new Throwable("Conversation is not matching thread queue, something is not right..."));
            Trace.println((String)("Conversation " + conversation + " bound to queue " + queue), (TraceLevel)TraceLevel.BASIC);
            Trace.println((String)("Thread " + Thread.currentThread().getName() + " bound to queue " + queue2), (TraceLevel)TraceLevel.BASIC);
        }
        if (queue2 == null) {
            Trace.ignored((Throwable)new Throwable("No queue bound to this thread, somthing is not right..."));
            return null;
        }
        try {
            return (Message)Waiter.runAndWait((Waiter.WaiterTask)new Waiter.WaiterTask(){

                public Object run() throws InterruptedException {
                    return queue2.waitForMessage(l, -1, conversation);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof InterruptedException) {
                throw (InterruptedException)exception;
            }
            return null;
        }
    }

    public synchronized Conversation beginConversation() {
        int n = this.curConversationID++;
        Conversation conversation = new Conversation(this.initiatingSide, n);
        Queue queue = (Queue)perThreadMsgQueue.get();
        if (queue == null) {
            queue = new Queue();
            perThreadMsgQueue.set(queue);
        }
        this.activeConversations.put(conversation, queue);
        return conversation;
    }

    public synchronized boolean joinConversation(Conversation conversation) {
        Queue queue = (Queue)this.activeConversations.get(conversation);
        Queue queue2 = (Queue)perThreadMsgQueue.get();
        if (queue != null) {
            return queue == queue2;
        }
        if (queue2 == null) {
            queue2 = new Queue();
            perThreadMsgQueue.set(queue2);
        }
        this.activeConversations.put(conversation, queue2);
        return true;
    }

    public void endConversation(Conversation conversation) {
        this.activeConversations.remove(conversation);
    }

    public void shutdown() {
        this.shouldShutdown = true;
    }

    private synchronized Queue getQueue(Conversation conversation) {
        return (Queue)this.activeConversations.get(conversation);
    }

    private synchronized void interruptActiveQueues() {
        this.mainMsgQueue.interrupt();
        Iterator iterator = this.activeConversations.values().iterator();
        while (iterator.hasNext()) {
            ((Queue)iterator.next()).interrupt();
        }
    }

    public boolean shutdownComplete() {
        return this.shutdownComplete;
    }

    private void checkForShutdown() throws IOException {
        if (this.shutdownComplete) {
            throw new IOException("Pipe is already shut down");
        }
    }

    class WorkerThread
    extends Thread {
        public WorkerThread() {
            super("Java Plug-In Pipe Worker Thread (" + (Pipe.this.initiatingSide ? "Server-Side" : "Client-Side") + ")");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                block12: {
                    try {
                        while (!Pipe.this.shouldShutdown) {
                            Message message = null;
                            Pipe.this.transport.waitForData(500L);
                            while ((message = Pipe.this.transport.read()) != null) {
                                Queue queue;
                                Pipe.this.logMessage(message, false);
                                Conversation conversation = message.getConversation();
                                boolean bl = false;
                                if (conversation != null && (queue = Pipe.this.getQueue(conversation)) != null) {
                                    queue.put(message);
                                    bl = true;
                                }
                                if (bl) continue;
                                Pipe.this.mainMsgQueue.put(message);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        Pipe.this.interruptActiveQueues();
                        if (!DEBUG) break block12;
                        System.out.println("Terminating " + Thread.currentThread().getName() + " due to exception:");
                        iOException.printStackTrace();
                    }
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                Pipe.this.shutdownComplete = true;
                Pipe pipe = Pipe.this;
                synchronized (pipe) {
                    Pipe.this.notifyAll();
                }
                throw throwable;
            }
            Pipe.this.shutdownComplete = true;
            Pipe pipe = Pipe.this;
            synchronized (pipe) {
                Pipe.this.notifyAll();
            }
        }
    }
}

