/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.parserapplications.filterbuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.parserapplications.filterbuilder.SubFilterList;
import org.htmlparser.parserapplications.filterbuilder.layouts.VerticalLayoutManager;

public abstract class Filter
extends JComponent
implements NodeFilter {
    protected static Hashtable mWrappers = new Hashtable();
    protected static String mNewLine = System.getProperty("line.separator");

    public static Filter instantiate(String class_name) {
        Filter ret = null;
        try {
            Class<?> cls = Class.forName(class_name);
            ret = (Filter)cls.newInstance();
            mWrappers.put(ret.getNodeFilter().getClass().getName(), class_name);
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("can't find class " + class_name);
        }
        catch (InstantiationException ie) {
            System.out.println("can't instantiate class " + class_name);
        }
        catch (IllegalAccessException ie) {
            System.out.println("class " + class_name + " has no public constructor");
        }
        catch (ClassCastException cce) {
            System.out.println("class " + class_name + " is not a Filter");
        }
        return ret;
    }

    public Filter() {
        this.setToolTipText(this.getDescription());
        this.setLayout(new VerticalLayoutManager());
        this.setSelected(false);
        JLabel label = new JLabel(this.getDescription(), this.getIcon(), 2);
        label.setBackground(Color.green);
        label.setAlignmentX(0.0f);
        label.setHorizontalAlignment(2);
        this.add(label);
        Dimension dimension = label.getMaximumSize();
        Insets insets = this.getInsets();
        dimension.setSize(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
        this.setSize(dimension);
    }

    public abstract String getDescription();

    public abstract NodeFilter getNodeFilter();

    public abstract void setNodeFilter(NodeFilter var1, Parser var2);

    public abstract NodeFilter[] getSubNodeFilters();

    public abstract void setSubNodeFilters(NodeFilter[] var1);

    public abstract String toJavaCode(StringBuffer var1, int[] var2);

    public Icon getIcon() {
        ImageIcon ret = null;
        try {
            ret = new ImageIcon(this.getClass().getResource(this.getIconSpec()));
        }
        catch (NullPointerException npe) {
            System.err.println("can't find icon " + this.getIconSpec());
        }
        return ret;
    }

    public abstract String getIconSpec();

    public String toString() {
        return this.getDescription() + " [" + this.getClass().getName() + "]";
    }

    public static byte[] pickle(Object object) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(object);
        oos.close();
        byte[] ret = bos.toByteArray();
        return ret;
    }

    public static Object unpickle(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ObjectInputStream ois = new ObjectInputStream(bis);
        Object ret = ois.readObject();
        ois.close();
        return ret;
    }

    public static String serialize(byte[] data) {
        StringBuffer ret = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            String string = Integer.toString(0xFF & data[i], 16);
            if (string.length() < 2) {
                ret.append("0");
            }
            ret.append(string);
        }
        return ret.toString();
    }

    public static byte[] deserialize(String string) {
        byte[] ret = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            ret[i / 2] = (byte)Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return ret;
    }

    public static String deconstitute(Filter[] filters) throws IOException {
        StringBuffer ret = new StringBuffer(1024);
        for (int i = 0; i < filters.length; ++i) {
            ret.append("[");
            ret.append(Filter.serialize(Filter.pickle(filters[i].getNodeFilter())));
            ret.append("]");
        }
        return ret.toString();
    }

    public static Filter[] reconstitute(String string, Parser context) {
        Vector<Filter> vector = new Vector<Filter>();
        try {
            int index;
            while (string.startsWith("[") && -1 != (index = string.indexOf(93))) {
                String code = string.substring(1, index);
                string = string.substring(index + 1);
                Object object = Filter.unpickle(Filter.deserialize(code));
                if (object instanceof NodeFilter) {
                    Filter filter = Filter.wrap((NodeFilter)object, context);
                    if (null == filter) continue;
                    vector.addElement(filter);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Object[] ret = new Filter[vector.size()];
        vector.copyInto(ret);
        return ret;
    }

    protected static SubFilterList getEnclosed(Component component) {
        if (component instanceof Container) {
            Component[] list = ((Container)component).getComponents();
            for (int i = 0; i < list.length; ++i) {
                if (!(list[i] instanceof SubFilterList)) continue;
                return (SubFilterList)list[i];
            }
        }
        return null;
    }

    public static Filter wrap(NodeFilter filter, Parser context) {
        Filter ret;
        block6: {
            ret = null;
            String class_name = filter.getClass().getName();
            if (null != (class_name = (String)mWrappers.get(class_name))) {
                try {
                    ret = Filter.instantiate(class_name);
                    ret.setNodeFilter(filter, context);
                    NodeFilter[] filters = ret.getSubNodeFilters();
                    if (0 == filters.length) break block6;
                    SubFilterList list = Filter.getEnclosed(ret);
                    if (null != list) {
                        ret.setSubNodeFilters(new NodeFilter[0]);
                        for (int i = 0; i < filters.length; ++i) {
                            list.addFilter(Filter.wrap(filters[i], context));
                        }
                        break block6;
                    }
                    throw new IllegalStateException("filter can't have subnodes without a SubFilterList on the wrapper");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println(class_name + " is not registered for wrapping.");
            }
        }
        return ret;
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.setBorder(new CompoundBorder(new EtchedBorder(), new CompoundBorder(new LineBorder(Color.blue, 2), new EmptyBorder(1, 1, 1, 1))));
        } else {
            this.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(3, 3, 3, 3)));
        }
    }

    public void setExpanded(boolean expanded) {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof JLabel) continue;
            components[i].setVisible(expanded);
        }
    }

    public static void spaces(StringBuffer out, int count) {
        for (int i = 0; i < count; ++i) {
            out.append(' ');
        }
    }

    public static void newline(StringBuffer out) {
        out.append(mNewLine);
    }

    public abstract /* synthetic */ boolean accept(Node var1);
}

