/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.parserapplications.filterbuilder.wrappers;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.Tag;
import org.htmlparser.filters.HasAttributeFilter;
import org.htmlparser.parserapplications.filterbuilder.Filter;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class HasAttributeFilterWrapper
extends Filter
implements ActionListener,
DocumentListener {
    protected HasAttributeFilter mFilter = new HasAttributeFilter();
    protected JComboBox mAttributeName = new JComboBox();
    protected JCheckBox mValued;
    protected JTextArea mAttributeValue;

    public HasAttributeFilterWrapper() {
        this.mAttributeName.setEditable(true);
        this.add(this.mAttributeName);
        this.mAttributeName.addItem(this.mFilter.getAttributeName());
        this.mAttributeName.addActionListener(this);
        String value = this.mFilter.getAttributeValue();
        this.mValued = new JCheckBox("Has Value");
        this.add(this.mValued);
        this.mValued.setSelected(null != value);
        this.mValued.addActionListener(this);
        this.mAttributeValue = new JTextArea(2, 20);
        this.mAttributeValue.setBorder(new BevelBorder(1));
        this.add(this.mAttributeValue);
        if (null != value) {
            this.mAttributeValue.setText(value);
        } else {
            this.mAttributeValue.setVisible(false);
        }
        this.mAttributeValue.getDocument().addDocumentListener(this);
    }

    protected void addAttributes(Set set, Node node) {
        if (node instanceof Tag) {
            NodeList children;
            int i;
            Vector attributes = ((Tag)node).getAttributesEx();
            for (i = 1; i < attributes.size(); ++i) {
                Attribute attribute = (Attribute)attributes.elementAt(i);
                String name = attribute.getName();
                if (null == name) continue;
                set.add(name);
            }
            if (node instanceof CompositeTag && null != (children = ((CompositeTag)node).getChildren())) {
                for (i = 0; i < children.size(); ++i) {
                    this.addAttributes(set, children.elementAt(i));
                }
            }
        }
    }

    protected void addAttributeValues(Set set, Node node) {
        if (node instanceof Tag) {
            NodeList children;
            int i;
            Vector attributes = ((Tag)node).getAttributesEx();
            for (i = 1; i < attributes.size(); ++i) {
                String value;
                Attribute attribute = (Attribute)attributes.elementAt(i);
                if (null == attribute.getName() || null == (value = attribute.getValue())) continue;
                set.add(value);
            }
            if (node instanceof CompositeTag && null != (children = ((CompositeTag)node).getChildren())) {
                for (i = 0; i < children.size(); ++i) {
                    this.addAttributeValues(set, children.elementAt(i));
                }
            }
        }
    }

    public String getDescription() {
        return "Has attribute";
    }

    public String getIconSpec() {
        return "images/HasAttributeFilter.gif";
    }

    public NodeFilter getNodeFilter() {
        HasAttributeFilter ret = new HasAttributeFilter();
        ret.setAttributeName(this.mFilter.getAttributeName());
        ret.setAttributeValue(this.mFilter.getAttributeValue());
        return ret;
    }

    public void setNodeFilter(NodeFilter filter, Parser context) {
        String value;
        Object iterator;
        this.mFilter = (HasAttributeFilter)filter;
        HashSet set = new HashSet();
        context.reset();
        try {
            iterator = context.elements();
            while (iterator.hasMoreNodes()) {
                this.addAttributes(set, iterator.nextNode());
            }
        }
        catch (ParserException pe) {
            // empty catch block
        }
        iterator = set.iterator();
        while (iterator.hasNext()) {
            this.mAttributeName.addItem(iterator.next());
        }
        String name = this.mFilter.getAttributeName();
        if (!name.equals("")) {
            this.mAttributeName.setSelectedItem(name);
        }
        if (null != (value = this.mFilter.getAttributeValue())) {
            this.mValued.setSelected(true);
            this.mAttributeValue.setVisible(true);
            this.mAttributeValue.setText(value);
        } else {
            this.mValued.setSelected(false);
            this.mAttributeValue.setVisible(false);
        }
    }

    public NodeFilter[] getSubNodeFilters() {
        return new NodeFilter[0];
    }

    public void setSubNodeFilters(NodeFilter[] filters) {
    }

    public String toJavaCode(StringBuffer out, int[] context) {
        int n = context[1];
        context[1] = n + 1;
        String ret = "filter" + n;
        Filter.spaces(out, context[0]);
        out.append("HasAttributeFilter ");
        out.append(ret);
        out.append(" = new HasAttributeFilter ();");
        Filter.newline(out);
        Filter.spaces(out, context[0]);
        out.append(ret);
        out.append(".setAttributeName (\"");
        out.append(this.mFilter.getAttributeName());
        out.append("\");");
        Filter.newline(out);
        if (null != this.mFilter.getAttributeValue()) {
            Filter.spaces(out, context[0]);
            out.append(ret);
            out.append(".setAttributeValue (\"");
            out.append(this.mFilter.getAttributeValue());
            out.append("\");");
            Filter.newline(out);
        }
        return ret;
    }

    public boolean accept(Node node) {
        return this.mFilter.accept(node);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.mAttributeName) {
            Object[] selection = this.mAttributeName.getSelectedObjects();
            if (null != selection && 0 != selection.length) {
                this.mFilter.setAttributeName((String)selection[0]);
            }
        } else if (source == this.mValued) {
            boolean valued = this.mValued.isSelected();
            if (valued) {
                this.mFilter.setAttributeValue(this.mAttributeValue.getText());
                this.mAttributeValue.setVisible(true);
            } else {
                this.mAttributeValue.setVisible(false);
                this.mAttributeValue.setText("");
                this.mFilter.setAttributeValue(null);
            }
        }
    }

    public void insertUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        try {
            this.mFilter.setAttributeValue(doc.getText(0, doc.getLength()));
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        try {
            this.mFilter.setAttributeValue(doc.getText(0, doc.getLength()));
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }
}

