/**
 * 系统登录controller.
 * @author 奚志敏
 * @version 1.0.0, 2015-07-07
 */
Ext.onReady(function() {
	//获取用户名
	var txtUserName = Ext.get('userName');
	//获取密码
	var txtPassword = Ext.get('password');
	//获取登录按钮
	var btnLogin = Ext.get('btnLogin');
	//获取重置按钮
	var btnReset = Ext.get('btnReset');
	
	/**
	 * 文本框按键处理方法
	 */
	var onKeydown = function(e, field) {
		if (e.getKey() == Ext.EventObject.ENTER) {	//回车按键
			if("password" == field.name) {//密码框
				//触发登录按钮单击事件
				btnLogin.dom.click();
			} else if("userName" == field.name) {//用户名框
				//密码框获得焦点
				txtPassword.dom.focus();
			}
		}
	};
	
	if(null != txtUserName && undefined != txtUserName) {
		//绑定用户名框按键事件
		txtUserName.on('keydown', onKeydown);
	}
	
	if(null != txtPassword && undefined != txtPassword) {
		//绑定密码框按键事件
		txtPassword.on('keydown', onKeydown);
	}
	
	/**
	 * 检测输入
	 * @return true: 验证通过; false: 验证不通过
	 */
	var checkInput = function() {
		var userName = txtUserName.dom.value;
		if('' == userName) {
			ACBEE.Ext.Util.showAlertBox("请输入用户名！", null, 200, function() {
				txtUserName.dom.focus();
			});
			return false;
		}
		
		var password = txtPassword.dom.value;
		if('' == password) {
			ACBEE.Ext.Util.showAlertBox("请输入密码！", null, 200,  function() {
				txtPassword.dom.focus();
			});
			return false;
		}
		
		return true;
	};
	
	/**
	 * 登录处理方法
	 */
	var onLoginClick = function(btn) {
		//验证表单
		if(!checkInput()){
			return false;
		}

		//提交表单
		ACBEE.Ext.Util.ajaxSubmitData('login.action', {
			userName: txtUserName.dom.value,
			password: txtPassword.dom.value
		}, null, "登录失败，请重试", function() {
			Ext.getBody().mask('正在加载数据，请稍候...');
			
			//跳转到主界面
			location.href="index.action?cc=" + Ext.Date.now();  
		});
	};
	
	if(null != btnLogin && undefined != btnLogin) {
		//绑定登录按钮单击事件
		btnLogin.on('click', onLoginClick);
		
		//绑定登录按钮鼠标移上事件
		btnLogin.on('mouseover', function() {
			btnLogin.dom.className = 'loginbtn_on';
		});
		//绑定登录按钮鼠标离开事件
		btnLogin.on('mouseout', function() {
			btnLogin.dom.className = 'loginbtn';
		});
		//绑定登录按钮鼠标按下事件
		btnLogin.on('mousedown', function() {
			btnLogin.dom.className = 'loginbtn_down';
		});
		//绑定登录按钮鼠标抬起事件
		btnLogin.on('mouseup', function() {
			btnLogin.dom.className = 'loginbtn';
		});
	}
	
	if(null != btnReset && undefined != btnReset) {
		//绑定重置按钮单击事件
		btnReset.on('click', function(btn) {
			txtUserName.dom.value = "";
			txtPassword.dom.value = "";
		});
		
		//绑定重置按钮鼠标移上事件
		btnReset.on('mouseover', function() {
			btnReset.dom.className = 'resetbtn_on';
		});
		//绑定重置按钮鼠标离开事件
		btnReset.on('mouseout', function() {
			btnReset.dom.className = 'resetbtn';
		});
		//绑定重置按钮鼠标按下事件
		btnReset.on('mousedown', function() {
			btnReset.dom.className = 'resetbtn_down';
		});
		//绑定重置按钮鼠标抬起事件
		btnReset.on('mouseup', function() {
			btnReset.dom.className = 'resetbtn';
		});
	}
});