/**
 * 需求方信息编辑controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-09
 */
Ext.define('WMS.controller.baseinfo.DemanderEditCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'baseinfo.DemanderEditView'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//保存按钮事件
			'demandereditview  button[name=btn-save]': {
				click: this.onSave
			},
	    	//窗体事件
	    	'demandereditview' : {
	    		//视图显示事件
				show: this.onShow
	    	}
		});
		
	},
	/**
     * 视图显示事件
     */
	onShow: function(view, eOpts) {
    	//刷新供应商性质下拉框数据
    	view.down('combobox[name=demanderNature]').getStore().reload();
    },
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得需方商window
		var win=button.up('window');
		//取得表单
		var form=win.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！");
			return false;
		}
		if(form.down('textfield[name=contacts1]').getValue() != "" && form.down('textfield[name=contacts2]').getValue() != "")
			if(form.down('textfield[name=contacts1]').getValue() == form.down('textfield[name=contacts2]').getValue()){
			ACBEE.Ext.Util.showAlertBox("联系人1与联系人2不能相同", null, 300);
			return false;
		}
		
		var hasError = false;
		//获取服务器时间
		ACBEE.Ext.Util.ajaxRequest("date/getServerTime.action",null,function(result){
			if(undefined != result && null != result) {
				//取得当前服务器日期
				var curDate = Ext.Date.format(new Date(result), "Y-m-d");
				var appointmentDate = win.down('datefield[name=demanderBeginDate]').getValue();
				appointmentDate = Ext.Date.format(new Date(appointmentDate), "Y-m-d");
				if(appointmentDate < curDate) {
					ACBEE.Ext.Util.showAlertBox("需方开始日期不能早于当前日期[" + curDate + "]！", null, 300);
					hasError = true;
					return false;
				}
				
			} else {
				ACBEE.Ext.Util.showAlertBox("无法取得服务器时间，保存入库预约单失败！", null, 300);
				hasError = true;
				return false;
			} 
				
	  	});
		
		if(hasError) {
			return false;
		}
		
		//取得当前登录的操作员Id
		var userId=ACBEE.Ext.Util.loginUserId;
		//取得需方商Id
		var oldDemanderId=win.oldDemanderId;
		//提交表单数据到后台
		ACBEE.Ext.Util.submitFormData(form, 'demander/saveDemander.action', {userId: userId,oldDemanderId: oldDemanderId}, 
			"需方商信息保存成功", "需方商信息保存失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
	}
});