/**
 * 需求方信息管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-09
 */
Ext.define('WMS.controller.baseinfo.DemanderSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'baseinfo.DemanderSearchView'
	],
	requires: [
	    'WMS.view.baseinfo.DemanderEditView',
	    'WMS.controller.baseinfo.DemanderEditCtl'
   	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//复选框显示禁用项改变事件
	    	'demandersearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
        	//添加按钮事件
	    	'demandersearchview button[name=btn-add]': {
	    		click: this.onAddDemander
	    	},
	    	//查询按钮事件
	    	'demandersearchview button[name=btn-search]': {
	    		click: this.onSearchDemander
	    	},
	    	//删除按钮事件
	    	'demandersearchview button[name=btn-delete]': {
	    		click: this.onDeleteDemander
	    	},
	    	//重置按钮事件
	    	'demandersearchview button[name=btn-clear]': {
	    		click: this.onClearDemander
	    	},
	    	//导入按钮事件
	    	'demandersearchview button[name=btn-import]': {
	    		click: this.onImportDemander
	    	},
	    	//导出按钮事件
	    	'demandersearchview button[name=btn-export]': {
	    		click: this.onExportDemander
	    	},
	    	//启用按钮事件
	    	'demandersearchview button[name=btn-openStatus]': {
	    		click: this.onOpenState
	    	},
	    	//禁用按钮事件
	    	'demandersearchview button[name=btn-closeStatus]': {
	    		click: this.onCloseState
	    	},
	    	//表格事件
	    	'demandersearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	
    	//刷新需方商性质下拉框数据
    	grid.down('combobox[name=demanderNature]').getStore().reload();
    },
	 //复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		var form = combobox.up('form');
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();

		//根据显示禁用项的值重新加载需方商性质下拉框数据
		var demanderNatureCbx = form.down('combobox[name=demanderNature]');
		var demanderNatureStore = demanderNatureCbx.getStore();
		if(!showForbidden){//不显示禁用项时取状态为启用的需方商性质
			//修改库区store参数
			demanderNatureStore.proxy.extraParams = {
				dictType: 2,
				status: 1
			};
		}else{
			//修改需方商性质store参数
			demanderNatureStore.proxy.extraParams = {
				dictType: 2,
				status: -1
			};
		}
		//重加载需方商性质下拉框数据
		demanderNatureStore.load();
		
		//显示禁用项改变时，需方商性质改为全部
		if(showForbidden != null){
			demanderNatureCbx.setValue();
		}
	     //调用查询按钮事件
		this.onSearchDemander(combobox);
	},
	//添加按钮事件处理
	onAddDemander:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载需方商编辑控制器
	  	ACBEE.Ext.Util.loadController(this.application, "baseinfo.DemanderEditCtl");
		//取得需方商window
	  	var win = ACBEE.Ext.Util.getWin('demandereditview');
		//设置编辑框可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')], win.down('form'), false);
		//清除表单内容
	  	win.down('form').getForm().reset();
		//设置需方商Id为零
	  	win.oldDemanderId=0;
		//保存当前表格的store
	  	win.parentStore=button.up('grid').getStore();
		win.setTitle('添加需求方信息');
	  	win.show();
	},
	//查询按钮事件处理
	onSearchDemander:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportDemander(button, 1);
	},
	//删除按钮事件处理
	onDeleteDemander:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在的表格
		var grid = button.up('grid');
		//提交删除表格的多条数据
		ACBEE.Ext.Util.ajaxDelGridData(grid, 'demanderId', 'demander/delDemander.action', '需方商');
	},
	//导入按钮事件
	onImportDemander:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		ACBEE.Ext.Util.importExcelFile(this.application, "demander/importDemander.action", 
				"需方商信息",  button.up('grid').getStore());
	},
	//导出按钮事件
	onExportDemander:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportDemander(button, 2);
	},
	/**
	 * 查询或导出需方商信息
	 * @param button 按钮对象
	 * @param dealType	处理类型 1: 查询; 2: 导出
	 */
	onSearchOrExportDemander: function(button, dealType) {
		//取得按钮所在表格
		var grid = button.up('grid');

		//取得表单对象
		var form = grid.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
			return false;
		}

		//取得查询条件
		//取得需方商名称
		var demanderName=grid.down('textfield[name=demanderName]').getValue();
		//取得需方商编码
		var demanderCode=grid.down('textfield[name=demanderCode]').getValue();
		//取得需方商性质
		var demanderNature=grid.down('combobox[name=demanderNature]').getValue();
		//取得需方商联系人
		var contacts1=grid.down('textfield[name=contacts1]').getValue();
		//取得需方商联系电话
		var tel1=grid.down('textfield[name=tel1]').getValue();
	    //取得需方开始时间
		var demanderBeginDate=grid.down('datefield[name=demanderBeginDate]').getValue();
		demanderBeginDate = (null == demanderBeginDate ? "" : demanderBeginDate);
	    //取得需方结束时间
		var demanderEndDate=grid.down('datefield[name=demanderEndDate]').getValue();
		demanderEndDate = (null == demanderEndDate ? "" : demanderEndDate);
	    //取得需方商状态
		var status=grid.down('combobox[name=status]').getValue(); 
	    //取得显示禁用项
	    var showForbidden=grid.down('checkbox[name=showForbidden]').getValue();
		
		if(1 == dealType) {//查询
			//设置查询参数
			grid.getStore().proxy.extraParams = {
				demanderName: demanderName,
				demanderCode: demanderCode,
				demanderNature: demanderNature,
				contacts1: contacts1,
				tel1: tel1,
				demanderBeginDate: demanderBeginDate,
				demanderEndDate: demanderEndDate,
				status: status == -1 ? (showForbidden ? -1 : 1) : status,
				demanderStatus: showForbidden ? -1 : 1
			};
			//重新加载store
			grid.getStore().loadPage(1);
		} else {//导出
			//导出需方商信息
			ACBEE.Ext.Util.submitDummyForm("demander/exportDemander.action", {
				demanderName: demanderName,
				demanderCode: demanderCode,
				demanderNature: demanderNature,
				contacts1: contacts1,
				tel1: tel1,
				demanderBeginDate: demanderBeginDate,
				demanderEndDate: demanderEndDate,
				status: status == -1 ? (showForbidden ? -1 : 1 ): status,
				demanderStatus: showForbidden ? -1 : 1
	        });
		}
	},
	//重置按钮事件
	onClearDemander:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在的表格
		var grid=button.up('grid');
		
		//查询条件
		grid.down('textfield[name=demanderName]').setValue('');
		grid.down('textfield[name=demanderCode]').setValue('');
		grid.down('combobox[name=demanderNature]').setValue(-1);
		grid.down('textfield[name=contacts1]').setValue('');
		grid.down('textfield[name=tel1]').setValue('');
		grid.down('datefield[name=demanderBeginDate]').setValue('');
		grid.down('datefield[name=demanderEndDate]').setValue('');
		grid.down('combobox[name=status]').setValue('-1');
		grid.down('checkbox[name=showForbidden]').reset();
	  	
	  	//调用查询按钮事件
	  	this.onSearchDemander(button);
	},
	//启用按钮事件
	onOpenState:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'demanderId', 'demander/updateStatus.action', '需方商', 1, 'status');
	},
	//禁用按钮事件
	onCloseState:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'demanderId', 'demander/updateStatus.action', '需方商', 0, 'status');
	},
	//修改按钮事件
	onUpdateDemander:function (grid,record){
		//加载需方商编辑控制器
	  	ACBEE.Ext.Util.loadController(this.application, "baseinfo.DemanderEditCtl");
		//取得需方商window
	  	var win = ACBEE.Ext.Util.getWin('demandereditview');
	  	//设置编辑框可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')], win.down('form'), false);
		//保存原需方商Id
	  	win.oldDemanderId=record.data.demanderId;
		//保存当前表格的store
	  	win.parentStore=grid.getStore();
	  	//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('修改需求方 [' + record.get('demanderName') + ']');
	  	win.show();
	},
	//显示详情事件
	onShowInfo : function(grid, record){
		//加载需方商编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "baseinfo.DemanderEditCtl");
		//取得需方商window
		var win = ACBEE.Ext.Util.getWin('demandereditview');
		//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('需求方 [' + record.get('demanderName') + '] 详细信息');
		//设置编辑框不可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')], win.down('form'), true);
		win.show();
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(9== cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-edit')) {//点击了编辑
				this.onUpdateDemander(grid, record);
			} else if(target.hasCls('btn-delete')) {//点击了删除
				var delInfo = '需方商 [' + record.get('demanderName') + ']';
				var id = record.get('demanderId');
			
				//提交删除当前行数据
				ACBEE.Ext.Util.ajaxDelSingleData(grid, delInfo, id, 'demander/delDemander.action');
			} else if(target.hasCls('btn-detail')) {//点击了详情
				this.onShowInfo(grid, record);
			}
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('edit')) {
			this.onUpdateDemander(grid, record);
		}
	}
});