/**
 * 货物信息编辑controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-09
 */
Ext.define('WMS.controller.baseinfo.GoodsEditCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'baseinfo.GoodsEditView'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//保存按钮事件
			'goodseditview  button[name=btn-save]': {
				click: this.onSave
			},
	    	//窗体事件
	    	'goodseditview' : {
	    		//视图显示事件
				show: this.onShow
	    	},
	    	//货物类别选择事件
			'goodseditview treecombox[name=gcId]': {
				select: this.onSelectGcId
			}
		});
	},
	/**
     * 视图显示事件
     */
	onShow: function(view, eOpts) {
		//刷新货物类别下拉框树数据
    	view.down('treecombox[name=gcId]').store.reload();
    	//刷新供应商性质下拉框数据
    	view.down('combobox[name=supplierId]').getStore().reload();
    },
    onSelectGcId: function(combobox, record, value){
    	//取得货物window
		var win=combobox.up('window');
		//取得表单
		var form=win.down('form');
    	//取得货物类别树下拉框对象
		var gcTreeCbx = form.down('treecombox[name=gcId]');
		//取得树最后选中结点
		var selectNode = gcTreeCbx.getPicker().getSelectionModel().lastSelected;
		if(1 == selectNode.getDepth() || (null != selectNode && undefined != selectNode && !selectNode.data.leaf)) {
			ACBEE.Ext.Util.showAlertBox("货物类别只能选择二级类别！");
			combobox.setValue('');
			return false;
		}
    },
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得货物window
		var win=button.up('window');
		//取得表单
		var form=win.down('form');
        //验证表单
		if(!form.isValid()){//表单失败
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！");
			return false;			
		}
		//比较最大库存量和最小库存量
		//取得最大库存量
		var maxStock = form.down('textfield[name=maxStock]').getValue();
		//取得最小库存量
		var minStock = form.down('textfield[name=minStock]').getValue();
		if(maxStock < minStock){
			ACBEE.Ext.Util.showAlertBox("最大库存量应大于最小库存量！");
			return false;
		}
		//取得货物类别树下拉框对象
		var gcTreeCbx = form.down('treecombox[name=gcId]');
		//取得树最后选中结点
		var selectNode = gcTreeCbx.getPicker().getSelectionModel().lastSelected;
		if(null != selectNode && undefined != selectNode && !selectNode.data.leaf) {
			ACBEE.Ext.Util.showAlertBox("货物类别只能选择二级类别！");
			return false;
		}
		
		//取得需方商Id
		var oldGoodsId=win.oldGoodsId;
		//提交表单数据到后台
		ACBEE.Ext.Util.submitFormData(form, 'goods/saveGoods.action', {oldGoodsId: oldGoodsId}, 
			"货物信息保存成功", "货物信息保存失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
		}
});