/**
 * 货物信息管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-09
 */
Ext.define('WMS.controller.baseinfo.GoodsSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'baseinfo.GoodsSearchView'
	],
	requires: [
	    'WMS.view.baseinfo.GoodsEditView',
	    'WMS.controller.baseinfo.GoodsEditCtl'
   	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//复选框显示禁用项改变事件
	    	'goodssearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
        	//添加按钮事件
	    	'goodssearchview button[name=btn-add]': {
	    		click: this.onAddGoods
	    	},
	    	//查询按钮事件
	    	'goodssearchview button[name=btn-search]': {
	    		click: this.onSearchGoods
	    	},
	    	//删除按钮事件
	    	'goodssearchview button[name=btn-delete]': {
	    		click: this.onDeleteGoods
	    	},
	    	//重置按钮事件
	    	'goodssearchview button[name=btn-clear]': {
	    		click: this.onClearGoods
	    	},
	    	//导入按钮事件
	    	'goodssearchview button[name=btn-import]': {
	    		click: this.onImportGoods
	    	},
	    	//导出按钮事件
	    	'goodssearchview button[name=btn-export]': {
	    		click: this.onExportGoods
	    	},
	    	//启用按钮事件
	    	'goodssearchview button[name=btn-openStatus]': {
	    		click: this.onOpenState
	    	},
	    	//禁用按钮事件
	    	'goodssearchview button[name=btn-closeStatus]': {
	    		click: this.onCloseState
	    	},
	    	//表格事件
	    	'goodssearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	
    	//刷新货物类别下拉框树数据
    	grid.down('treecombox[name=goodsCategoryName]').store.reload();
    	//刷新供应商性质下拉框数据
    	grid.down('combobox[name=supplierId]').getStore().reload();
    },
	//复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		var form = combobox.up('form');
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();

		//根据显示禁用项的值重新加载供应商、货物类别下拉框数据
		var supplierCbx = form.down('combobox[name=supplierId]');
		var goodsCategoryCbx = form.down('treecombox[name=goodsCategoryName]');
		var supplierStore = supplierCbx.getStore();
		var goodsCategoryStore = goodsCategoryCbx.store;
		if(!showForbidden){//不显示禁用项时取状态为启用的供应商、货物类别
			//修改供应商store参数
			supplierStore.proxy.extraParams = {
				status: 1
			};
			//修改货物类别store参数
			goodsCategoryStore.proxy.extraParams = {
				status: 1
			};
		}else{
			//修改供应商store参数
			supplierStore.proxy.extraParams = {
				status: -1
			};
			//修改货物类别store参数
			goodsCategoryStore.proxy.extraParams = {
				status: -1
			};
		}
		//重加载供应商/货物类别下拉框数据
		supplierStore.load();
		goodsCategoryStore.load();
		
		//显示禁用项改变时，供应商、货物类别改为全部
		if(showForbidden != null){
			supplierCbx.setValue();
			goodsCategoryCbx.setValue(-1);
		}
	     //调用查询按钮事件
		this.onSearchGoods(combobox);
	},
	/**
	 * 查询或导出货物信息
	 * @param button 按钮对象
	 * @param dealType	处理类型 1: 查询; 2: 导出
	 */
	onSearchOrExportGoods: function(button, dealType) {
		//取得按钮所在表格
		var grid = button.up('grid');

		//取得表单对象
		var form = grid.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
			return false;
		}
		
		//获取到查询条件
		//取得货物编号
		var goodsCode=grid.down('textfield[name=goodsCode]').getValue();
		//取得品名
		var goodsName=grid.down('textfield[name=goodsName]').getValue();
		//取得供应商Id
		var supplierId=grid.down('combobox[name=supplierId]').getValue();
		//取得状态
		var status=grid.down('combobox[name=status]').getValue();
		//取得供应商状态
		var supplierStatus=-1;
		//取得货物类别状态
		var goodsCategoryStatus=-1;
	    //取得显示禁用项
	    var showForbidden=grid.down('checkbox[name=showForbidden]').getValue();
		//取得货物类别
		var goodsCategoryName=grid.down('treecombox[name=goodsCategoryName]').getRawValue();
		
		if(1 == dealType) {//查询
			//设置查询参数
			grid.getStore().proxy.extraParams = {
				goodsCode: goodsCode,
				goodsName: goodsName,
				supplierId: supplierId,
				goodsCategoryName: goodsCategoryName,
				status: showForbidden ? status : status==0 ? 2 : 1,
				supplierStatus: showForbidden ? supplierStatus : 1,
				goodsCategoryStatus: showForbidden ? goodsCategoryStatus : 1
			};
			//重新加载store
			grid.getStore().loadPage(1);
		} else {//导出
			//导出货物信息
			ACBEE.Ext.Util.submitDummyForm("goods/exportGoods.action", {
				goodsCode: goodsCode,
				goodsName: goodsName,
				supplierId: supplierId,
				goodsCategoryName: goodsCategoryName,
				status: showForbidden ? status : status==0 ? 2 : 1,
				supplierStatus: showForbidden ? supplierStatus : 1,
				goodsCategoryStatus: showForbidden ? goodsCategoryStatus : 1
	        });
		}
	},
	//添加按钮事件处理
	onAddGoods:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载货物编辑控制器
	  	ACBEE.Ext.Util.loadController(this.application, "baseinfo.GoodsEditCtl");
		//取得货物window
	  	var win = ACBEE.Ext.Util.getWin('goodseditview');
		//设置编辑框可编辑
		ACBEE.Ext.Util.disableCompoment(win.down('button[name=btn-save]'), win.down('form'), false);
		//清除表单内容
	  	win.down('form').getForm().reset();
	  	//设置货物Id为零
	  	win.oldGoodsId=0;
	  	//保存当前表格的store
	  	win.parentStore=button.up('grid').getStore();
		win.setTitle('添加货物信息');
	  	win.show();
	},
	//查询按钮事件处理
	onSearchGoods:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportGoods(button, 1);
	},
	//删除按钮事件处理
	onDeleteGoods:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		//提交删除表格多条数据
		ACBEE.Ext.Util.ajaxDelGridData(grid, 'goodsId', 'goods/delGoods.action', '货物');
	},
	//重置按钮事件
	onClearGoods:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
			
		//清空查询条件
		grid.down('textfield[name=goodsCode]').setValue('');
		grid.down('textfield[name=goodsName]').setValue('');
		grid.down('treecombox[name=goodsCategoryName]').setValue('');
		grid.down('combobox[name=supplierId]').setValue('');
		grid.down('combobox[name=status]').setValue('-1');
		grid.down('checkbox[name=showForbidden]').reset();
	     //调用查询按钮事件
		this.onSearchGoods(button);
	},
	//导入按钮事件
	onImportGoods:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		ACBEE.Ext.Util.importExcelFile(this.application, "goods/importGoods.action", 
				"货物信息",  button.up('grid').getStore());
	},
	//导出按钮事件
	onExportGoods:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportGoods(button, 2);
	},
	//启用按钮事件
	onOpenState:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'goodsId', 'goods/updateStatus.action', '货物', 1, 'status');
	},
	//禁用按钮事件
	onCloseState:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'goodsId', 'goods/updateStatus.action', '货物', 0, 'status');
	},
	//修改按钮事件
	onUpdateDemander:function (grid,record){
		//加载货物编辑控制器
	  	ACBEE.Ext.Util.loadController(this.application, "baseinfo.GoodsEditCtl");
		//取得货物window
	  	var win = ACBEE.Ext.Util.getWin('goodseditview');
	  	//设置编辑框可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')], win.down('form'), false);
		
		//保存原需方商Id
	  	win.oldGoodsId=record.data.goodsId;
		//保存当前表格的store
	  	win.parentStore=grid.getStore();
	  	win.down('button[name=btn-save]').show();
	  	//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('修改货物 [' + record.get('goodsName') + ']');
	  	win.show();
	},
	//显示详情事件
	onShowInfo : function(grid, record){
		//加载货物编辑控制器
	  	ACBEE.Ext.Util.loadController(this.application, "baseinfo.GoodsEditCtl");
		//取得货物window
	  	var win = ACBEE.Ext.Util.getWin('goodseditview');
		//设置编辑框不可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')],win.down('form'),true);
		//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('货物 [' + record.get('goodsName') + '] 详细信息');
		win.show();
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(9 == cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-edit')) {//点击了编辑
				this.onUpdateDemander(grid,record);
			} else if(target.hasCls('btn-delete')) {//点击了删除
				var delInfo = '货物 [' + record.get('goodsName') + ']';
				var id=record.get('goodsId');
				//提交删除当前行的数据
				ACBEE.Ext.Util.ajaxDelSingleData(grid, delInfo, id, 'goods/delGoods.action');
			} else if(target.hasCls('btn-detail')) {//点击了详情
				this.onShowInfo(grid, record);
			}
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('edit')) {
			this.onUpdateDemander(grid, record);
		}
	}
});