/**
 * 供应商信息管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-07
 */
Ext.define('WMS.controller.baseinfo.SupplierSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'baseinfo.SupplierSearchView'
	],
	requires: [
	    'WMS.view.baseinfo.SupplierEditView',
	    'WMS.controller.baseinfo.SupplierEditCtl'
   	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//复选框显示禁用项改变事件
	    	'suppliersearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
        	//添加按钮事件
	    	'suppliersearchview button[name=btn-add]': {
	    		click: this.onAddSupplier
	    	},
	    	//删除按钮事件
	    	'suppliersearchview button[name=btn-delete]': {
	    		click: this.onDeleteSupplier
	    	},
	    	//查询按钮事件
	    	'suppliersearchview button[name=btn-search]': {
	    		click: this.onSearchSupplier
	    	},
	    	//重置按钮事件
	    	'suppliersearchview button[name=btn-clear]': {
	    		click: this.onClearSupplier
	    	},
	    	//导入按钮事件
	    	'suppliersearchview button[name=btn-import]': {
	    		click: this.onImportSupplier
	    	},
	    	//导出按钮事件
	    	'suppliersearchview button[name=btn-export]': {
	    		click: this.onExportSupplier
	    	},
	    	//启用按钮事件
	    	'suppliersearchview button[name=btn-openStatus]': {
	    		click: this.onOpenState
	    	},
	    	//禁用按钮事件
	    	'suppliersearchview button[name=btn-closeStatus]': {
	    		click: this.onCloseState
	    	},
	    	//表格事件
	    	'suppliersearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	
    	//刷新供应商性质下拉框数据
    	grid.down('combobox[name=supplierNature]').getStore().reload();
    	/*//开关头部事件
		this.onSwitchHeader(panel);*/
    },
	 //复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		var form = combobox.up('form');
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();

		//根据显示禁用项的值重新加载供应商性质下拉框数据
		var supplierNatureCbx = form.down('combobox[name=supplierNature]');
		var supplierNatureStore = supplierNatureCbx.getStore();
		if(!showForbidden){//不显示禁用项时取状态为启用的供应商性质
			//修改库区store参数
			supplierNatureStore.proxy.extraParams = {
				dictType: 1,
				status: 1
			};
		}else{
			//修改供应商性质store参数
			supplierNatureStore.proxy.extraParams = {
				dictType: 1,
				status: -1
			};
		}
		//重加载供应商性质下拉框数据
		supplierNatureStore.load();
		
		//显示禁用项改变时，供应商性质改为全部
		if(showForbidden != null){
			supplierNatureCbx.setValue();
		}
	     //调用查询按钮事件
		this.onSearchSupplier(combobox);
	},
    /**
	 * 查询或导出供应商信息
	 * @param button 按钮对象
	 * @param dealType	处理类型 1: 查询; 2: 导出
	 */
    onSearchOrExportSupplier: function(button, dealType) {
		//取得按钮所在表格
		var grid = button.up('grid');

		//取得表单对象
		var form = grid.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
			return false;
		}
		
		//取得查询条件
		//取得供应商名称
		var supplierName=grid.down('textfield[name=supplierName]').getValue();
		//取得供应商编码
	    var supplierCode=grid.down('textfield[name=supplierCode]').getValue();
	    //取得供应商性质
	    var supplierNature=grid.down('combobox[name=supplierNature]').getValue();
	    //取得供应商状态
	    var status=grid.down('combobox[name=status]').getValue();
	    //取得联系人
	    var contacts1=grid.down('textfield[name=contacts1]').getValue();
	    //取得电话号码
	    var tel1=grid.down('textfield[name=tel1]').getValue();
	    //取得供应开始时间
	    var supplyBeginDate=grid.down('datefield[name=supplyBeginDate]').getValue();
	    //取得供应结束时间
	    var supplyEndDate=grid.down('datefield[name=supplyEndDate]').getValue();
	    //取得显示禁用项
	    var showForbidden=grid.down('checkbox[name=showForbidden]').getValue();
		    
		if(1 == dealType) {//查询
			//设置查询参数
			grid.getStore().proxy.extraParams = {
				supplierName: supplierName,
				supplierCode: supplierCode,
				contacts1: contacts1,
				tel1: tel1,
				supplyBeginDate: supplyBeginDate,
				supplyEndDate: supplyEndDate,
				supplierNature: supplierNature,
				status: status == -1 ? (showForbidden ? -1 : 1) : status,
				supplierStatus: showForbidden ? -1 : 1
			};
			
			//重新加载store
			grid.getStore().loadPage(1);
		} else {//导出
			//导出供应商信息
			ACBEE.Ext.Util.submitDummyForm("supplier/exportSupplier.action", {
				supplierName: supplierName,
				supplierCode: supplierCode,
				supplierNature: supplierNature,
				contacts1: contacts1,
				tel1: tel1,
				supplyBeginDate: supplyBeginDate,
				supplyEndDate: supplyEndDate,
				status: status == -1 ? (showForbidden ? -1 : 1) : status,
				supplierStatus: showForbidden ? -1 : 1
	        });
		}
	},
	//添加按钮事件处理
	onAddSupplier:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载供应商编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "baseinfo.SupplierEditCtl");
		//取得供应商window
		var win = ACBEE.Ext.Util.getWin('suppliereditview');
		//设置编辑框可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')], win.down('form'), false);
		//清除表单内容
		win.down('form').getForm().reset();
		//设置供应商Id为零
		win.oldSupplierId = 0;
		//保存当前表格的store
		win.parentStore = button.up('grid').getStore();
		win.setTitle('添加供应商信息');
		win.show();
	},
	//修改按钮事件
	onUpdateSupplier:function(grid, record){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载供应商编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "baseinfo.SupplierEditCtl");
		//取得供应商window
		var win = ACBEE.Ext.Util.getWin('suppliereditview');
		//设置编辑框可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')], win.down('form'), false);
		//保存原供应商Id
		win.oldSupplierId = record.data.supplierId;
		//保存父窗体表格store
		win.parentStore = grid.getStore();
		//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('修改供应商 [' + record.get('supplierName') + ']');
		win.show();
	},
	//显示详情事件
	onShowInfo : function(grid, record){
		//加载供应商编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "baseinfo.SupplierEditCtl");
		//取得供应商window
		var win = ACBEE.Ext.Util.getWin('suppliereditview');
		//设置编辑框不可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')], win.down('form'), true);
		//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('供应商 [' + record.get('supplierName') + '] 详细信息');
		win.show();
	},
	//删除按钮事件
	onDeleteSupplier:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		//提交删除表格多条数据
		ACBEE.Ext.Util.ajaxDelGridData(grid, 'supplierId', 'supplier/delSupplier.action', '供应商');
	},
	//查询按钮事件
	onSearchSupplier:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportSupplier(button, 1);
	},
	//清空按钮事件
	onClearSupplier:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所处的表格
		var supplierGrid=button.up('grid');
		
		//查询条件
	    supplierGrid.down('textfield[name=supplierName]').setValue('');
	    supplierGrid.down('textfield[name=supplierCode]').setValue('');
	    supplierGrid.down('combobox[name=supplierNature]').setValue(-1);
	    supplierGrid.down('combobox[name=status]').setValue('-1');
	    supplierGrid.down('textfield[name=contacts1]').setValue('');
	    supplierGrid.down('textfield[name=tel1]').setValue('');
	    supplierGrid.down('datefield[name=supplyBeginDate]').setValue('');
	    supplierGrid.down('datefield[name=supplyEndDate]').setValue('');
	    supplierGrid.down('checkbox[name=showForbidden]').reset();
	     //调用查询按钮事件
		this.onSearchSupplier(button);
	},
	//导入按钮事件
	onImportSupplier:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		ACBEE.Ext.Util.importExcelFile(this.application, "supplier/importSupplier.action", 
			"供应商信息",  button.up('grid').getStore());
	},
	//导出按钮事件
	onExportSupplier:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportSupplier(button, 2);
	},
	//启用按钮事件
	onOpenState:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'supplierId', 'supplier/updateStatus.action', '供应商', 1, 'status');
	},
	//禁用按钮事件
	onCloseState:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'supplierId', 'supplier/updateStatus.action', '供应商', 0, 'status');
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(9== cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-edit')) {//点击了编辑
				this.onUpdateSupplier(grid, record);
			} else if(target.hasCls('btn-delete')) {//点击了删除
				var delInfo = '供应商 [' + record.get('supplierName') + ']';
				var id = record.get('supplierId');
			
				//提交删除当前行数据
				ACBEE.Ext.Util.ajaxDelSingleData(grid, delInfo, id, 'supplier/delSupplier.action');
			} else if(target.hasCls('btn-detail')) {//点击了详情
				this.onShowInfo(grid, record);
			}
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('edit')) {
			this.onUpdateSupplier(grid, record);
		}
	}
});