/**
 * 库区信息编辑controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-09
 */
Ext.define('WMS.controller.baseinfo.WarehouseAreaEditCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'baseinfo.WarehouseAreaEditView'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//保存按钮事件
			'warehouseareaeditview  button[name=btn-save]': {
				click: this.onSave
			}
		});
	},
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得库区window
		var win=button.up('window');
		//取得表单
		var form=win.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！");
			return false;
		}
		if(form.down('textfield[name=manager1]').getValue() != "" && form.down('textfield[name=manager2]').getValue() != "")
			if(form.down('textfield[name=manager1]').getValue() == form.down('textfield[name=manager2]').getValue()){
			ACBEE.Ext.Util.showAlertBox("管理人员1与管理人员2不能相同", null, 300);
			return false;
		}
		//取得库区Id
		var oldAreaId=win.oldAreaId;
		//提交表单数据到后台
		ACBEE.Ext.Util.submitFormData(form, 'warehouseArea/saveArea.action', {oldAreaId: oldAreaId}, 
			"库区信息保存成功", "库区信息保存失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
	}
});