/**
 * 库区信息管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-09
 */
Ext.define('WMS.controller.baseinfo.WarehouseAreaSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'baseinfo.WarehouseAreaSearchView'
	],
	requires: [
	    'WMS.view.baseinfo.WarehouseAreaEditView',
	    'WMS.controller.baseinfo.WarehouseAreaEditCtl'
   	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	/**
			 * @author 李树雪 2015年12月22日 上午10.34
			 * @bug 714
			 * @code:19-27
			 */
	    	//复选框显示禁用项改变事件
	    	'warehouseareasearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
        	//添加按钮事件
	    	'warehouseareasearchview button[name=btn-add]': {
	    		click: this.onAddWarehouseArea
	    	},
	    	//删除按钮事件
	    	'warehouseareasearchview button[name=btn-delete]': {
	    		click: this.onDeleteWarehouseArea
	    	},
	    	//查询按钮事件
	    	'warehouseareasearchview button[name=btn-search]': {
	    		click: this.onSearchWarehouseAreaSearch
	    	},
	    	//清空按钮事件
	    	'warehouseareasearchview button[name=btn-clear]': {
	    		click: this.onClearWarehouseArea
	    	},
	    	//导入按钮事件
	    	'warehouseareasearchview button[name=btn-import]': {
	    		click: this.onImportWarehouseArea
	    	},
	    	//导出按钮事件
	    	'warehouseareasearchview button[name=btn-export]': {
	    		click: this.onExportWarehouseArea
	    	},
	    	//启用按钮事件
	    	'warehouseareasearchview button[name=btn-openStatus]': {
	    		click: this.onOpenState
	    	},
	    	//禁用按钮事件
	    	'warehouseareasearchview button[name=btn-closeStatus]': {
	    		click: this.onCloseState
	    	},
	    	//表格事件
	    	'warehouseareasearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    },
    
    /**
	 * @author 李树雪 2015年12月22日 上午10.34
	 * @bug 714
	 * @code:79-90
	 */
    //复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();
	     //调用查询按钮事件
		this.onSearchWarehouseAreaSearch(combobox);
	},
	
	
	/**
	 * 查询或导出库区信息
	 * @param button 按钮对象
	 * @param dealType	处理类型 1: 查询; 2: 导出
	 */
	onSearchOrExportWarehouseArea: function(button, dealType) {
		//取得按钮所在表格
		var grid = button.up('grid');

		//取得表单对象
		var form = grid.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
			return false;
		}
		//获取查询数据
		//获取库区名称
		var areaName=grid.down('textfield[name=areaName]').getValue();
		//获取库区编码
		var areaCode=grid.down('textfield[name=areaCode]').getValue();
		//获取库区性质
		var areaNature=grid.down('combobox[name=areaNature]').getValue();
		//获取库区地点
		var address=grid.down('textfield[name=address]').getValue();
		//获取管理人员
		var manager1=grid.down('textfield[name=manager1]').getValue();
		//获取联系电话
		var tel1=grid.down('textfield[name=tel1]').getValue();
		//获取状态
		var status=grid.down('combobox[name=status]').getValue();
	
		/**
		 * @author 李树雪 2015年12月22日 上午10.34
		 * @bug 714
		 * @code:125-131, 143, 156
		 */
		//取得显示禁用项
	    var showForbidden=grid.down('checkbox[name=showForbidden]').getValue();
		//取得入库需求单的store
		var store = grid.getStore();
		if(1 == dealType) {//查询
			//设置查询参数
			store.proxy.extraParams = {
				areaName: areaName,
				areaCode: areaCode,
				areaNature: areaNature,
				address: address,
				manager1: manager1,
				tel1: tel1,
				status: status == -1 ?  showForbidden ? -1 : 1 : status
			};
			//重新加载store
			store.loadPage(1);
		} else {//导出
			//导出库区信息
			ACBEE.Ext.Util.submitDummyForm("warehouseArea/exportWarehouseArea.action", {
				areaName: areaName,
				areaCode: areaCode,
				areaNature: areaNature,
				address: address,
				manager1: manager1,
				tel1: tel1,
				status: status == -1 ?  showForbidden ? -1 : 1 : status
	        });
		}
	},
	//添加按钮事件处理
	onAddWarehouseArea:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载库区编辑控制器
       ACBEE.Ext.Util.loadController(this.application, "baseinfo.WarehouseAreaEditCtl");
		//显示库区window
		var win = ACBEE.Ext.Util.getWin('warehouseareaeditview');
		//设置编辑框可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')], win.down('form'), false);
		//清除表单内容
	  	win.down('form').getForm().reset();
		//设置库区Id为零
	  	win.oldAreaId=0;
		//保存当前表格的store
	  	win.parentStore=button.up('grid').getStore();
	  	win.setTitle('添加库区信息');
	  	win.show();
	},
	//修改按钮事件
	onUpdateArea:function (grid,record){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载库区编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "baseinfo.WarehouseAreaEditCtl");
		//显示库区window
		var win = ACBEE.Ext.Util.getWin('warehouseareaeditview');
		//设置编辑框可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')], win.down('form'), false);
		//保存原库区Id
	  	win.oldAreaId=record.data.areaId;
		//保存当前表格的store
	  	win.parentStore=grid.getStore();
	  	win.down('button[name=btn-save]').show();
	  	//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('修改库区 [' + record.get('areaName') + ']');
	  	win.show();
	},
	//删除事件处理
	onDeleteWarehouseArea:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		//提交删除表格多条数据
		ACBEE.Ext.Util.ajaxDelGridData(grid, 'areaId', 'warehouseArea/delArea.action', '库区');
	},
	//查询事件处理
	onSearchWarehouseAreaSearch:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportWarehouseArea(button, 1);
	},
	//重置事件处理
	onClearWarehouseArea:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
			
		//清空查询条件
		grid.down('textfield[name=areaName]').setValue('');
		grid.down('textfield[name=areaCode]').setValue('');
		grid.down('combobox[name=areaNature]').setValue('-1');
		grid.down('textfield[name=address]').setValue('');
		grid.down('textfield[name=manager1]').setValue('');
		grid.down('textfield[name=tel1]').setValue('');
		grid.down('combobox[name=status]').setValue('-1');
	     //调用查询按钮事件
		this.onSearchWarehouseAreaSearch(button);
		},
	//导入事件处理
	onImportWarehouseArea:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		ACBEE.Ext.Util.importExcelFile(this.application, "warehouseArea/importWarehouseArea.action", 
				"库区信息",  button.up('grid').getStore());
	},
	//导出事件处理
	onExportWarehouseArea:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportWarehouseArea(button, 2);
	},
	//启用事件处理
	onOpenState:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'areaId', 'warehouseArea/updateStatus.action', '库区', 1, 'status');
	},
	//禁用事件处理
	onCloseState:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'areaId', 'warehouseArea/updateStatus.action', '库区', 0, 'status');
	},	
	//显示详情事件
	onShowInfo : function(grid, record){
		//加载库区编辑控制器
       ACBEE.Ext.Util.loadController(this.application, "baseinfo.WarehouseAreaEditCtl");
		//显示库区window
		var win = ACBEE.Ext.Util.getWin('warehouseareaeditview');
		//设置编辑框不可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')], win.down('form'), true);
		//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('库区 [' + record.get('areaName') + '] 详细信息');
		win.show();
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(8 == cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-edit')) {//点击了编辑
				this.onUpdateArea(grid, record);
			} else if(target.hasCls('btn-delete')) {//点击了删除
				var delInfo='货物 ['+record.get("areaName")+']';	
				var id=record.get('areaId');
				//提交删除表格多条数据
				ACBEE.Ext.Util.ajaxDelSingleData(grid, delInfo, id,'warehouseArea/delArea.action');
			} else if(target.hasCls('btn-detail')) {//点击了详情
				this.onShowInfo(grid, record);
			}
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('edit')) {
			this.onUpdateArea(grid, record);
		}
	}
});