/**
 * 库位信息编辑controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-10
 */
Ext.define('WMS.controller.baseinfo.WarehouseLocationEditCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'baseinfo.WarehouseLocationEditView'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//保存按钮事件
			'warehouselocationeditview  button[name=btn-save]': {
				click: this.onSave
			},
			//所属库区改变事件
	    	'warehouselocationeditview combobox[name=areaId]': {
	    		change: this.onAreaNatureChange
	    	},
	    	//窗体事件
	    	'warehouselocationeditview' : {
	    		//视图显示事件
				show: this.onShow
	    	}
		});
	},
	/**
     * 视图显示事件
     */
	onShow: function(view, eOpts) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//刷新所属库区下拉框数据
		view.down('combobox[name=areaId]').getStore().reload();
		//刷新库位性质下拉框数据
		view.down('combobox[name=natureId]').getStore().reload();
    },
	/**
	 * 所属库区改变事件
	 */
	onAreaNatureChange: function(combobox, record, value){
		var areaId = combobox.getValue();
		if(areaId == null){
			areaId = 0;
		}
		
		//取得库位性质下拉框对象
		var natureCbx = combobox.up('form').down('combobox[name=natureId]');
		natureCbx.setValue('');
		var store = natureCbx.getStore();
		//修改库位性质store参数
		store.proxy.extraParams = {
		    status: 1,
			areaId: areaId
		};
		store.load();
	},
	//保存按钮事件
	onSave: function(button) {
		//取得库位window
		var win=button.up('window');
		//取得表单
		var form=win.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！");
			return false;
		}
		//取得库区Id
		var oldLocationId=win.oldLocationId;
		//提交表单数据到后台
		ACBEE.Ext.Util.submitFormData(form, 'warehouseLocation/saveLocation.action', {oldLocationId: oldLocationId}, 
			"库位信息保存成功", "库位信息保存失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
	}
});