/**
 * 库位信息管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-10
 */
Ext.define('WMS.controller.baseinfo.WarehouseLocationSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'baseinfo.WarehouseLocationSearchView'
	],
	requires: [
	    'WMS.view.baseinfo.WarehouseLocationEditView',
	    'WMS.controller.baseinfo.WarehouseLocationEditCtl'
   	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//复选框显示禁用项改变事件
	    	'warehouselocationsearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
        	//添加按钮事件
	    	'warehouselocationsearchview button[name=btn-add]': {
	    		click: this.onAddWarehouseLocation
	    	},
	    	//删除按钮事件
	    	'warehouselocationsearchview button[name=btn-delete]': {
	    		click: this.onDeleteWarehouseLocation
	    	},
	    	//查询按钮事件
	    	'warehouselocationsearchview button[name=btn-search]': {
	    		click: this.onSearchWarehouseLocation
	    	},
	    	//清空按钮事件
	    	'warehouselocationsearchview button[name=btn-clear]': {
	    		click: this.onClearWarehouseLocation
	    	},
	    	//导入按钮事件
	    	'warehouselocationsearchview button[name=btn-import]': {
	    		click: this.onImportWarehouseLocation
	    	},
	    	//导出按钮事件
	    	'warehouselocationsearchview button[name=btn-export]': {
	    		click: this.onExportWarehouseLocation
	    	},
	    	//启用按钮事件
	    	'warehouselocationsearchview button[name=btn-openStatus]': {
	    		click: this.onOpenState
	    	},
	    	//禁用按钮事件
	    	'warehouselocationsearchview button[name=btn-closeStatus]': {
	    		click: this.onCloseState
	    	},
	    	//表格事件
	    	'warehouselocationsearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	
    	//刷新库位性质下拉框数据
    	grid.down('combobox[name=natureId]').getStore().reload();
    	//刷新所属库区下拉框数据
    	grid.down('combobox[name=areaName]').getStore().reload();
    },
	//复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		var form = combobox.up('form');
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();

		//根据显示禁用项的值重新加载库位性质、所属库区下拉框数据
		var locationNatureCbx = form.down('combobox[name=natureId]');
		var areaCbx = form.down('combobox[name=areaName]');
		
		var locationNatureStore = locationNatureCbx.getStore();
		var areaStore = areaCbx.getStore();
		if(!showForbidden){//不显示禁用项时取状态为启用的供应商性质
			//修改库位性质store参数
			locationNatureStore.proxy.extraParams = {
				status: 1,
        	 	areaId:-1
			};
			//修改所属库区store参数
			areaStore.proxy.extraParams = {
				status: 1,
        	 	areaNature: -1
			};
		}else{
			//修改库位性质store参数
			locationNatureStore.proxy.extraParams = {
				status: -1,
        	 	areaId:-1
			};
			//修改所属库区store参数
			areaStore.proxy.extraParams = {
				status: -1,
        	 	areaNature: -1
			};
		}
		//重加载库位性质、所属库区下拉框数据
		locationNatureStore.load();
		areaStore.load();
		
		//显示禁用项改变时，库位性质、所属库区改为全部
		if(showForbidden != null){
			locationNatureCbx.setValue(-1);
			areaCbx.setValue(-1);
		}
	     //调用查询按钮事件
		this.onSearchWarehouseLocation(combobox);
	},
	/**
	 * 查询或导出库位信息
	 * @param button 按钮对象
	 * @param dealType	处理类型 1: 查询; 2: 导出
	 */
	onSearchOrExportWarehouseLocation: function(button, dealType) {
		//取得按钮所在表格
		var grid = button.up('grid');

		//取得表单对象
		var form = grid.down('form');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
			return false;
		}
		
		//获取查询数据
		//获取所属库区Id
		var areaId=grid.down('textfield[name=areaName]').getValue();
		//获取库位号
		var locationNo=grid.down('textfield[name=locationNo]').getValue();
		//获取库位性质
		var natureId=grid.down('combobox[name=natureId]').getValue();
		//获取管理人员
		var manager1=grid.down('textfield[name=manager1]').getValue();
		//获取联系电话
		var tel1=grid.down('textfield[name=tel1]').getValue();
		//获取状态
		var status=grid.down('combobox[name=status]').getValue();
	    //取得显示禁用项
	    var showForbidden=grid.down('checkbox[name=showForbidden]').getValue();
		
		if(1 == dealType) {//查询
			//设置查询参数
			grid.getStore().proxy.extraParams = {
				areaId:areaId,
				locationNo:locationNo,
				natureId:natureId,
				manager1:manager1,
				tel1:tel1,
				status: status == -1 ?  showForbidden ? -1 : 1 : status,
				areaStatus:showForbidden ? -1 : 1,
				locationNatureStatus:showForbidden ? -1 : 1
			};
			//重新加载store
			grid.getStore().loadPage(1);
		} else {//导出
			//导出库位信息
			ACBEE.Ext.Util.submitDummyForm("warehouseLocation/exportWarehouseLocation.action", {
				areaId:areaId,
				locationNo:locationNo,
				natureId:natureId,
				manager1:manager1,
				tel1:tel1,
				status: status == -1 ?  showForbidden ? -1 : 1 : status,
				areaStatus:showForbidden ? -1 : 1,
				locationNatureStatus:showForbidden ? -1 : 1
	        });
		}
	},
	//添加按钮事件处理
	onAddWarehouseLocation:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载库区编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "baseinfo.WarehouseLocationEditCtl");
		//显示库区window
		var win = ACBEE.Ext.Util.getWin('warehouselocationeditview');
		//设置编辑框可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')], win.down('form'), false);
		//清除表单内容
	  	win.down('form').getForm().reset();
		//设置库区Id为零
	  	win.oldLocationId=0;
		//保存当前表格的store
	  	win.parentStore=button.up('grid').getStore();
	  	win.setTitle('添加库位信息');
	  	win.show();
	},
	//删除事件处理
	onDeleteWarehouseLocation:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		//提交删除表格多条数据
		ACBEE.Ext.Util.ajaxDelGridData(grid, 'locationId', 'warehouseLocation/delLocation.action', '库位');
	},
	//查询事件处理
	onSearchWarehouseLocation:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportWarehouseLocation(button, 1);
	},
	//重置事件处理
	onClearWarehouseLocation:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
			
		//清空查询条件
		grid.down('combobox[name=areaName]').setValue(-1);
		grid.down('textfield[name=locationNo]').setValue('');
		grid.down('combobox[name=natureId]').setValue(-1);
		grid.down('textfield[name=manager1]').setValue('');
		grid.down('textfield[name=tel1]').setValue('');
		grid.down('combobox[name=status]').setValue('-1');
		grid.down('checkbox[name=showForbidden]').reset();
	     //调用查询按钮事件
		this.onSearchWarehouseLocation(button);
	},
	//导入事件处理
	onImportWarehouseLocation:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		ACBEE.Ext.Util.importExcelFile(this.application, "warehouseLocation/importWarehouseLocation.action", 
				"库位信息",  button.up('grid').getStore());
	},
	//导出事件处理
	onExportWarehouseLocation:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		this.onSearchOrExportWarehouseLocation(button, 2);
	},
	//启用事件处理
	onOpenState:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'locationId', 'warehouseLocation/updateStatus.action', '库位', 1, 'status');
	},
	//禁用事件处理
	onCloseState:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		
		ACBEE.Ext.Util.ajaxSwitchGridStatus(grid, 'locationId', 'warehouseLocation/updateStatus.action', '库位', 0, 'status');
	},	
	//修改按钮事件
	onUpdateLocation:function (grid,record){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载库区编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "baseinfo.WarehouseLocationEditCtl");
		//显示库区window
		var win = ACBEE.Ext.Util.getWin('warehouselocationeditview');
		//设置编辑框可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')], win.down('form'), false);
		//保存原库区Id
	  	win.oldLocationId=record.data.locationId;
		//保存当前表格的store
	  	win.parentStore=grid.getStore();
	  	win.down('button[name=btn-save]').show();
	  	//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('修改库位 [' + record.get('locationNo') + ']');
	  	win.show();
	},
	//显示详情事件
	onShowInfo : function(grid, record){
		//加载库区编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "baseinfo.WarehouseLocationEditCtl");
		//显示库区window
		var win = ACBEE.Ext.Util.getWin('warehouselocationeditview');
		//设置编辑框可编辑
		ACBEE.Ext.Util.disableCompoment([win.down('button[name=btn-save]')], win.down('form'), true);
		//获取保存按钮
		win.down('button[name=btn-save]').hide();
		//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('库位 [' + record.get('locationNo') + '] 详细信息');
		win.show();
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(8== cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-edit')) {//点击了编辑
				this.onUpdateLocation(grid, record);
			} else if(target.hasCls('btn-delete')) {//点击了删除
				var delInfo='库位号 ['+record.get("locationNo")+']';	
				var id=record.get('locationId');
				//提交删除表格多条数据
				ACBEE.Ext.Util.ajaxDelSingleData(grid, delInfo, id,'warehouseLocation/delLocation.action');
			} else if(target.hasCls('btn-detail')) {//点击了详情
				this.onShowInfo(grid, record);
			}
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('edit')) {
			this.onUpdateLocation(grid, record);
		}
	}
});