/**
 * 退库操作信息编辑controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.controller.cancelstock.CancelstockBillEditCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'cancelstock.CancelstockBillEditView',
		'cancelstock.LocationNoView'
	],
	stores:[
	    'WMS.store.cancelstock.CancelStockDemandBillGridStr',
	    'WMS.store.common.LocationNoStr'
	],
	requires: [
	    'WMS.controller.cancelstock.LocationNoViewCtl',
	    'WMS.view.cancelstock.LocationNoView'
   	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//保存按钮事件
			'cancelstockbilleditview  button[name=btn-save]': {
				click: this.onSave
			},
			'cancelstockbilleditview':{
				beforeshow: this.OnBeforeShow
			},
			'cancelstockbilleditview grid':{
	    		cellclick: this.onGridEditCellClick
			}
		});
	},
	OnBeforeShow : function(win,e){
		var store = win.down('grid').getStore();
		store.load({
			url: 'cancel/searchCancelStockDemandBillItemList.action',
			params: {cancelstockDemandBillId: win.oldCancelstockDemandBillId}
		});
		
		//刷新实际退库组下拉框数据
		win.down('combobox[name=actualCancelstockGroup]').getStore().reload();
	},
	onGridEditCellClick : function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts){
		if(6 == cellIndex){
			//加载退库库位号列表控制器
		    ACBEE.Ext.Util.loadController(this.application, "cancelstock.LocationNoViewCtl");
			//显示退库库位号列表window
			var win = ACBEE.Ext.Util.getWin('locationnoview');
			win.goodsId = record.data.goodsId;
			win.productBatch = record.data.productBatch;
			win.supplierId =grid.up('window').down('hiddenfield').getValue();
			win.rowIndex = rowIndex;
			win.editView = "cancelstockbilleditview";
			win.showAt(e.getXY());
		}
	},
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		//取得表单对象
		var form = win.down('form');
		//取得表格对象
		var grid = win.down('grid');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！");
			return false;
		}
		
		//验证表格数据
		if(!this.checkGridData(grid)) {
			return false;
		}
		//获取预约日期
		var appointmentDate = win.down('displayfield[name=appointmentDate]').getValue();
		appointmentDate =  Ext.Date.format(new Date(appointmentDate), "Y-m-d");
		//获取实际退库时间
		var actualCancelTime = win.down('datefield[name=actualCancelTime]').getValue();
		actualCancelTime = Ext.Date.format(new Date(actualCancelTime), "Y-m-d");
		if(actualCancelTime < appointmentDate) {
			ACBEE.Ext.Util.showAlertBox("实际退库日期不能早于预约日期[" + appointmentDate + "]！", null, 300);
			hasError = true;
			return false;
		}

		var store = grid.getStore();
		var totalQuantity = 0;
		var totalPrice = 0.0;
		for (var i = 0; i < store.getCount(); i++) {
			price = store.getAt(i).get('price');
			planCancelQuantity = store.getAt(i).get('planCancelQuantity');
			totalQuantity = totalQuantity * 1 + planCancelQuantity * 1;
			totalPrice = totalPrice * 1 + ((price * 1) * (planCancelQuantity * 1));
		}
		
		//取得表格数据
		var goods = ACBEE.Ext.Util.getStoreArrayData(grid.getStore());
		var oldCancelstockDemandBillId=win.oldCancelstockDemandBillId;
		//提交表单数据到后台
		ACBEE.Ext.Util.submitFormData(form, 'cancel/saveCancelstockDemandBill.action', {
			oldCancelstockDemandBillId: oldCancelstockDemandBillId,
			goods:goods,
			totalPrice:totalPrice,
			totalQuantity:totalQuantity,
			flag : 1
		}, "退库操作成功", "退库操作失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
	},
	//验证表格数据
	checkGridData: function(grid) {
		var store = grid.getStore();
		var actualCancelQuantity;
		var locationNo;
		var status;
		//未上架、实际退库数量为空个数
		var downCount = 0;
		//未上架个数
		 var count = 0;
		//遍历表格数据
		for (var i = 0; i < store.getCount(); i++) {
			actualCancelQuantity = store.getAt(i).get('actualCancelQuantity');
			if(actualCancelQuantity == null){
				ACBEE.Ext.Util.showAlertBox("请填写第 "+(i+1)+" 行实际退库数量！", null, 300);
				return false;
			}
			locationNo = store.getAt(i).get('locationNo');
			if(locationNo == null){
				ACBEE.Ext.Util.showAlertBox("请选择第 "+(i+1)+" 行退库库位号！", null, 300);
				return false;
			}
			status = store.getAt(i).get('status');
			if (status==0){
				count++;
			}
		    if(undefined == actualCancelQuantity && status==0){//未上架的并且实际退库数量为空
		   		downCount++;
		    } 
		}
		if(downCount == count){
			ACBEE.Ext.Util.showAlertBox("必须下架一批货物！", null, 300);
			return false;
		} 
		
		return true;
	}
});