/**
 * 退库操作信息管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.controller.cancelstock.CancelstockBillSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'cancelstock.CancelstockBillSearchView'
	],
	requires: [
	    'WMS.view.cancelstock.CancelstockBillEditView',
	    'WMS.controller.cancelstock.CancelstockBillEditCtl'
   	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//复选框显示禁用项改变事件
	    	'cancelstockbillsearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
	    	//查询按钮事件
	    	'cancelstockbillsearchview button[name=btn-search]': {
	    		click: this.onSearchCancelstockBillItem
	    	},
	    	//清空按钮事件
	    	'cancelstockbillsearchview button[name=btn-clear]': {
	    		click: this.onClearCancelstockBillItem
	    	},
	    	//表格事件
	    	'cancelstockbillsearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	
    	//刷新供应商下拉框数据
    	grid.down('combobox[name=supplierId]').getStore().reload();
    	//刷新退库原因下拉框数据
    	grid.down('combobox[name=cancelCause]').getStore().reload();
    },
	//复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		var form = combobox.up('form');
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();

		//根据显示禁用项的值重新加载供应商、退库原因下拉框数据
		var supplierCbx = form.down('combobox[name=supplierId]');
		var cancelCauseCbx = form.down('combobox[name=cancelCause]');
		var supplierStore = supplierCbx.getStore();
		var cancelCauseStore = cancelCauseCbx.getStore();
		if(!showForbidden){//不显示禁用项时取状态为启用的供应商、退库原因
			//修改供应商store参数
			supplierStore.proxy.extraParams = {
				status: 1
			};
			//修改退库原因store参数
			cancelCauseStore.proxy.extraParams = {
				dictType: 5,
				status: 1
			};
		}else{
			//修改供应商store参数
			supplierStore.proxy.extraParams = {
				status: -1
			};
			//修改退库原因store参数
			cancelCauseStore.proxy.extraParams = {
				dictType: 5,
				status: -1
			};
		}
		//重加载库区下拉框数据
		supplierStore.load();
		cancelCauseStore.load();
		
		//显示禁用项改变时，供应商改为全部
		if(showForbidden != null){
			supplierCbx.setValue();
			cancelCauseCbx.setValue(-1);
		}
	     //调用查询按钮事件
		this.onSearchCancelstockBillItem(combobox);
	},
	//查询按钮事件处理
	onSearchCancelstockBillItem:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var cancelstockDemandBillGrid = button.up('grid');
		//取得表单对象
		var form = cancelstockDemandBillGrid.down('form');
		//验证表单
		if(!form.isValid()){
        	ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
        	return false;
		}
		
		//获得查询条件
		//取得退库需求号
		var demandNo = cancelstockDemandBillGrid.down('textfield[name=demandNo]').getValue();
		//取得预约开始日期
		if(cancelstockDemandBillGrid.down('datefield[name=cancelBillBeginDate]').getValue()==null)
			var cancelBillBeginDate=null;
	    else
		    cancelBillBeginDate = Ext.Date.format(new Date(cancelstockDemandBillGrid.down('datefield[name=cancelBillBeginDate]').getValue()),'Y-m-d H:i:s');
		//取得预约结束日期
		if(cancelstockDemandBillGrid.down('datefield[name=cancelBillEndDate]').getValue()==null)
			var cancelBillEndDate=null;
	    else    
		    cancelBillEndDate = Ext.Date.format(new Date(cancelstockDemandBillGrid.down('datefield[name=cancelBillEndDate]').getValue()),'Y-m-d H:i:s');
		 //取得计划退库开始
		if(cancelstockDemandBillGrid.down('datetimefield[name=planCancelBeginTime]').getValue()==null)
	    	var planCancelBeginTime=null;
	    else
			planCancelBeginTime = Ext.Date.format(new Date(cancelstockDemandBillGrid.down('datetimefield[name=planCancelBeginTime]').getValue()),'Y-m-d H:i:s');
		//取得计划退库结束时间
	    if(cancelstockDemandBillGrid.down('datetimefield[name=planCancelEndTime]').getValue()==null)
    		var planCancelEndTime=null;
    	else
			planCancelEndTime = Ext.Date.format(new Date(cancelstockDemandBillGrid.down('datetimefield[name=planCancelEndTime]').getValue()),'Y-m-d H:i:s');
        //取得订单号
		var orderNo = cancelstockDemandBillGrid.down('textfield[name=orderNo]').getValue();
        //取得供应商
		var supplierId = cancelstockDemandBillGrid.down('combobox[name=supplierId]').getValue();
        //取得退库状态
		var status = cancelstockDemandBillGrid.down('combobox[name=status]').getValue();
        //取得退库原因
		var cancelCause = cancelstockDemandBillGrid.down('combobox[name=cancelCause]').getValue();
		//取得退库需求单的store
		var store=cancelstockDemandBillGrid.getStore();
	    //取得显示禁用项
	    var showForbidden=cancelstockDemandBillGrid.down('checkbox[name=showForbidden]').getValue();
			
		//设置查询参数
		store.proxy.extraParams = {
			demandNo : demandNo,
			orderNo : orderNo,
			supplierId : supplierId,
			status : status,
			cancelCause : cancelCause,
			cancelBillBeginDate : cancelBillBeginDate,
			cancelBillEndDate : cancelBillEndDate,
			planCancelBeginTime : planCancelBeginTime,
			planCancelEndTime : planCancelEndTime,
			supplierStatus: showForbidden ? -1 : 1,
			causeStatus: showForbidden ? -1 : 1,
			flag : 1
		};
		store.loadPage(1);
	},
	//清空按钮事件
	onClearCancelstockBillItem:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var cancelstockDemandBillGrid = button.up('grid');
		///清空查询条件
		cancelstockDemandBillGrid.down('textfield[name=demandNo]').setValue('');
		cancelstockDemandBillGrid.down('textfield[name=orderNo]').setValue('');
		cancelstockDemandBillGrid.down('datefield[name=cancelBillBeginDate]').setValue('');
		cancelstockDemandBillGrid.down('datefield[name=cancelBillEndDate]').setValue('');
		cancelstockDemandBillGrid.down('datetimefield[name=planCancelBeginTime]').setValue('');
	    cancelstockDemandBillGrid.down('datetimefield[name=planCancelEndTime]').setValue('');
		cancelstockDemandBillGrid.down('combobox[name=status]').setValue('-1');
		cancelstockDemandBillGrid.down('combobox[name=cancelCause]').setValue(-1);
		cancelstockDemandBillGrid.down('combobox[name=supplierId]').setValue('');
		cancelstockDemandBillGrid.down('checkbox[name=showForbidden]').reset();
		this.onSearchCancelstockBillItem(button);
	},
	//下架按钮事件
	onUpdateCancelDemandBillItem : function(grid,record){
		//加载退库操作编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "cancelstock.CancelstockBillEditCtl");
		//显示退库操作window
		var win = ACBEE.Ext.Util.getWin('cancelstockbilleditview');
		//保存原退库需求单Id
	  	win.oldCancelstockDemandBillId=record.data.cancelstockDemandBillId;
		//保存当前表格的store
	  	win.parentStore=grid.getStore();
	 	//将选中记录的数据装载到编辑窗口中
	  	if(record.get('actualCancelstockGroup') != 0 && record.get('actualCancelstockGroup') != null && 
	  	   record.get('actualCancelTime') != 0 && record.get('actualCancelTime') != null){
			ACBEE.Ext.Util.disableCompoment(null, win.down('form'), true);
		}
		win.down('form').loadRecord(record);
		win.setTitle('退库操作[' + record.get('demandNo') + ']');
	    win.show();
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(14== cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-offShelves')) {//点击了下架
              this.onUpdateCancelDemandBillItem(grid, record);
			}
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('offShelves')) {
			this.onUpdateCancelDemandBillItem(grid, record);
		}
	}
});