/**
 * 预约退库信息编辑controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.controller.cancelstock.CancelstockDemandBillEditCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'cancelstock.CancelstockDemandBillEditView',
		'cancelstock.ProductBatchView'
	],
	stores:[
	    'WMS.store.common.ProductBatchStr',
	    'WMS.store.cancelstock.CancelStockDemandBillGridStr'
	],
	requires: [
	    'WMS.controller.cancelstock.ProductBatchViewCtl',
	    'WMS.view.cancelstock.ProductBatchView'
   	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//添加按钮事件
			'cancelstockdemandbilleditview  button[name=btn-add]': {
				click: this.onAddCancelstockDemandGoods
			},
			//保存按钮事件
			'cancelstockdemandbilleditview  button[name=btn-save]': {
				click: this.onSave
			},
			//打印按钮事件
			'cancelstockdemandbilleditview  button[name=btn-print]': {
				click: this.onPrint
			},
			//导入事件
			'cancelstockdemandbilleditview  button[name=btn-import]': {
				click: this.onImport
			},
			//导出事件
			'cancelstockdemandbilleditview  button[name=btn-export]': {
				click: this.onExport
			},
			//删除按钮事件
			'cancelstockdemandbilleditview  button[name=btn-delete]': {
				click: this.onDeleteCancelstockDemandGoods
			},
			'cancelstockdemandbilleditview grid':{
	    		cellclick: this.onGridEditCellClick
			},
			'cancelstockdemandbilleditview':{
				beforeshow: this.OnBeforeShow
			},
			//供应商改变事件
	    	'cancelstockdemandbilleditview combobox[name=supplierId]': {
	    		change: this.onSupplierChange
	    	}
		});
	},
	//供应商改变事件
	onSupplierChange : function(combobox, record, value){
		var form = combobox.up('form');
		var supplierId = form.down('hiddenfield[name=supplierCode]');
	    supplierId.setValue(combobox.getValue());
	},
	OnBeforeShow : function(win, e){
		var store = win.down('grid').getStore();
		store.load({
			url: 'cancel/searchCancelStockDemandBillItemList.action',
			params: {cancelstockDemandBillId: win.oldCancelstockDemandBillId}
		});
		
		//编制退库需求单
		if(0 == win.oldCancelstockDemandBillId) {
			//获取服务器时间，设置预约日期和计划到货时间
			ACBEE.Ext.Util.ajaxRequest("date/getServerTime.action",null,function(result){
				if(undefined != result && null != result) {
					win.down('datefield[name=appointmentDate]').setValue(Ext.Date.format(new Date(result), "Y-m-d"));
				}
		  	});
		}
		
		//刷新供应商下拉框数据
		win.down('combobox[name=supplierId]').getStore().reload();
    	//刷新退库原因下拉框数据
		win.down('combobox[name=cancelCause]').getStore().reload();
		//刷新退库库区下拉框数据
		win.down('combobox[name=areaId]').getStore().reload();
		
		if(win.down('combobox[name=areaId]').getValue() == -1){//若areaId的值为-1，则显示：'--请选择--'
			win.down('combobox[name=areaId]').setValue('--请选择--')
		}
		
	},
	//添加按钮事件
	onAddCancelstockDemandGoods: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		var grid = win.down('grid');
		var store = grid.getStore();
		var record = Ext.create('WMS.model.cancelstock.CancelStockDemandBillItemMdl');
		store.add(record);
	},
	//打印按钮事件
	onPrint : function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		ACBEE.Ext.Util.showReport({
			report: 'cancelstockDemandBill',
			cancelstockDemandBillItemId: win.oldCancelstockDemandBillId
		});
	},
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		//取得表单对象
		var form = win.down('form');
		//取得表格对象
		var grid = win.down('grid');

		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！");
			return false;
		}
		if(form.down('combobox[name=areaId]').getValue() > 0){
		}else{//areaId的值为请选择，则areaId的值设为-1
			form.down('combobox[name=areaId]').setValue(-1);
		}
		var hasError = false;
		//获取服务器时间
		ACBEE.Ext.Util.ajaxRequest("date/getServerTime.action",null,function(result){
			if(undefined != result && null != result) {
				//取得当前服务器日期
				var curDate = Ext.Date.format(new Date(result), "Y-m-d");
				var appointmentDate = win.down('datefield[name=appointmentDate]').getValue();
				appointmentDate = Ext.Date.format(new Date(appointmentDate), "Y-m-d");
				if(appointmentDate < curDate) {
					ACBEE.Ext.Util.showAlertBox("预约日期不能早于当前日期[" + curDate + "]！", null, 300);
					hasError = true;
					return false;
				}
				
				//取得当前服务器时间
				var curTime = Ext.Date.format(new Date(result), "Y-m-d H:i:s");
				var planArrivalTime = win.down('datetimefield[name=planCancelTime]').getValue();
				planArrivalTime = Ext.Date.format(new Date(planArrivalTime), "Y-m-d H:i:s");
				if(planArrivalTime < curTime) {
					ACBEE.Ext.Util.showAlertBox("计划退库时间不能早于当前时间[" + curTime + "]！", null, 300);
					hasError = true;
					return false;
				}
			} else {
				ACBEE.Ext.Util.showAlertBox("无法取得服务器时间，保存退库预约单失败！", null, 300);
				hasError = true;
				return false;
			} 
				
	  	});
		
		if(hasError) {
			return false;
		}
		//验证表格数据
		if(!this.checkGridData(grid)) {
			return false;
		}

		var store = grid.getStore();
		var totalQuantity = 0;
		var totalPrice = 0.0;
		for (var i = 0; i < store.getCount(); i++) {
			price = store.getAt(i).get('price');
			planCancelQuantity = store.getAt(i).get('planCancelQuantity');
			totalQuantity = totalQuantity * 1 + planCancelQuantity * 1;
			totalPrice = totalPrice * 1 + ((price * 1) * (planCancelQuantity * 1));
		}
		
		//取得表格数据
		var goods = ACBEE.Ext.Util.getStoreArrayData(grid.getStore());
		var oldCancelstockDemandBillId=win.oldCancelstockDemandBillId;
		//提交表单数据到后台
		ACBEE.Ext.Util.submitFormData(form, 'cancel/saveCancelstockDemandBill.action', {
			oldCancelstockDemandBillId: oldCancelstockDemandBillId,
			goods:goods,
			totalPrice:totalPrice,
			totalQuantity:totalQuantity,
			flag : 0
		}, "预约退库需求单生成成功", "预约退库需求单生成失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
	},
	/**
	 * 处理导入成功的数据
	 */
	onDealImportSucceedData: function(store, successList) {
		if(null == successList || undefined == successList) {
			return;
		}
		
		var record;
		var index = -1;
		var msg = '';
		for(var i=0;i<successList.length;i++){
			//查找原store中是否已经存在货物号
			index = store.find('goodsCode', successList[i].goodsCode);
        	if(-1 != index) {
        		if("" != msg) {
        			msg += "，";
        		}
        		msg += successList[i].goodsCode;
        		continue;
        	}
			
			record = Ext.create('WMS.model.cancelstock.CancelStockDemandBillGridMdl', {
				goodsCode: successList[i].goodsCode,
				goodsName: successList[i].goodsName,
				goodsId: successList[i].goodsId,
				specs: successList[i].specs,
				productBatch: successList[i].productBatch,
				planCancelQuantity: successList[i].planCancelQuantity,
				price: successList[i].price
			});
			store.add(record);
		}
		
		if("" != msg) {
			msg = "货物号为：［" + msg + "］的货物已经存在表格中，不再追加！";
			ACBEE.Ext.Util.showAlertBox(msg, null, 400);
		}
	},
	//导入按钮事件
	onImport:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		ACBEE.Ext.Util.importExcelFile(this.application, "cancel/importCancelStockDemandBillItemList.action", 
			"退库需求单-货物明细信息",  button.up('grid').getStore(), this.onDealImportSucceedData, {
			refreshGrid: false
		});
	},
	//导出按钮事件
	onExport:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		//导出预约退库信息
		ACBEE.Ext.Util.exportExcelFile(grid, "退库需求单-货物明细信息");
	},
	//删除按钮事件
	onDeleteCancelstockDemandGoods: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		var grid = win.down('grid');
		var records=grid.getSelectionModel().getSelection(); 
		for(var i=0;i<records.length;i++){
			grid.getStore().remove(records[i]);
		}
		grid.view.refresh();
	},
	//弹出生产批号列表
	onGridEditCellClick : function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts){
		if(3 == cellIndex){
			if(grid.up('window').status == 0 || undefined == grid.up('window').status){
				//加载生产批号列表控制器
			    ACBEE.Ext.Util.loadController(this.application, "cancelstock.ProductBatchViewCtl");
				//显示生产批号列表window
				var win = ACBEE.Ext.Util.getWin('productbatchview');
				win.goodsId = record.data.goodsId;
				win.supplierId =grid.up('window').down('hiddenfield').getValue();
				win.rowIndex = rowIndex;
				win.editView = "cancelstockdemandbilleditview";
				win.showAt(e.getXY());
			}
		}
	},
	//验证表格数据
	checkGridData: function(grid) {
		var store = grid.getStore();
		if(null == store || undefined == store || 0 == store.getCount()) {
			ACBEE.Ext.Util.showAlertBox("请添加至少一条货物明细", null, 300);
			return false;
		}
		var goodsCode;
		var planCancelQuantity;
		var productBatch;
		//货物号与生产批号拼接的字符串
		var goodsLinkplanCancelQuantity = "";
		//遍历表格数据
		for (var i = 0; i < store.getCount(); i++) {
			goodsCode = store.getAt(i).get('goodsCode');
			productBatch = store.getAt(i).get('productBatch');
			if(undefined == goodsCode) {
				ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的货物号不能为空", null, 300);
				return false;
			}
			planCancelQuantity = store.getAt(i).get('planCancelQuantity');
				if("" == planCancelQuantity) {
				ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的计划退库数量不能为空", null, 300);
				return false;
			}
			/*if(goodsLinkplanCancelQuantity != ""){
				var splitArray = goodsLinkProductBatch.split(',');
				for(var j = 0; j<splitArray.length-1;j++){
					if(splitArray[j]==(goodsCode + productBatch)){
						ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的货物编号重复", null, 300);
						return false;
					} else {
						goodsLinkProductBatch += (goodsCode + productBatch)+',';
					}
				}
			} else{
				goodsLinkProductBatch = (goodsCode + productBatch)+',';
			}*/
				for(var j=0; j<i;j++){
					if(store.getAt(j).get('goodsCode') == store.getAt(i).get('goodsCode')){
						ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的货物编号重复", null, 300);
						return false;
					}
				}
		}
		return true;
	}
});