/**
 * 退库库位号列表controller.
 * @author 高元称
 * @version 1.0.0, 2015-09-01
 */
Ext.define('WMS.controller.cancelstock.LocationNoViewCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'cancelstock.LocationNoView',
		'cancelstock.CancelstockBillEditView'
	],
	stores:[
	    'WMS.store.common.LocationNoStr'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			// 确定按钮事件
			'locationnoview  button[name=btn-sure]': {
				click: this.onSure
			},
			'locationnoview':{
				beforeshow: this.OnBeforeShow
			}
		});
	},
	OnBeforeShow : function(win,e){
		var store = win.down('grid').getStore();
		store.load({
			url: 'stock/getLocationNo.action',
			params: {
				goodsId: win.goodsId,
				productBatch : win.productBatch,
				supplierId : win.supplierId,
				flag : 1
			}
		});
		 win.down('grid').on("itemdblclick",function(grid, record, item, index, e, eOpts){
		 	var store = Ext.getCmp(win.editView).down('grid').getStore();
		 	store.getAt(win.rowIndex).set('locationNo',record.data.locationNo);
			if(win.flag == "outstock"){
				store.getAt(win.rowIndex).set('actualOutstockLocation',record.data.locationId);
			}
			else{
				store.getAt(win.rowIndex).set('locationId',record.data.locationId);
			}
			win.close();
		 });
	},
	//确定按钮事件
	onSure: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		var grid = win.down('grid');
		var store = Ext.getCmp(win.editView).down('grid').getStore();
		var records=grid.getSelectionModel().getSelection(); 
		if(records.length > 1){
			ACBEE.Ext.Util.showAlertBox("只能选择一个退库库位号！！！", null, 300);
		} else if (records.length == 0){
			ACBEE.Ext.Util.showAlertBox("你没有选择任何一个退库库位号！！！", null, 300);
		} else {
			store.getAt(win.rowIndex).set('locationNo',records[0].data.locationNo);
			if(win.flag == "outstock"){
				store.getAt(win.rowIndex).set('actualOutstockLocation',records[0].data.locationId);
			}
			else{
				store.getAt(win.rowIndex).set('locationId',records[0].data.locationId);
			}
			win.close();
		}
	}
});