/**
 * Excel导入失败数据controller.
 * @author 奚志敏
 * @version 1.0.0, 2015-08-18
 */
Ext.define('WMS.controller.common.ExcelFailDataCtl',{
	extend: 'Ext.app.Controller',
	views: [
	    'common.ExcelFailDataView'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		
		this.control({
			//窗口事件
			'excelfaildataview': {
				afterrender: this.onAfterRender
			},
			//导出按钮事件
			'excelfaildataview button[name=btn-export]': {
				click: this.onExport
			}
		});
	},
	//窗口渲染后事件
	onAfterRender: function(win, eOpts){
		var failGrid = win.down('grid');
		
		if(null != win.failData && "" != win.failData) {
        	var jsonData = Ext.JSON.decode(win.failData.replace(/\"\{/g,"{").replace(/\}\"/g,"}"));
			var store = Ext.create('Ext.data.Store',{
				fields: jsonData.map.fields,
				data: jsonData.map.contents
		    });
			store.load();
			failGrid.reconfigure(store, jsonData.map.fieldheaders);
    	} else {
    		ACBEE.Ext.Util.showAlertBox("没有导入失败数据！");
    		win.close();
    	}
	},
	//导出按钮事件
	onExport: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		var grid = win.down('grid');
		var fileName = win.title;
		
		//导出excel文件
		ACBEE.Ext.Util.exportExcelFile(grid, fileName, ['sn']);
	}
});