/**
 * Excel文件导入公用controller.
 * @author 奚志敏
 * @version 1.0.0, 2015-08-17
 */
Ext.define('WMS.controller.common.ExcelImportCtl',{
	extend: 'Ext.app.Controller',
	requires: [
   	    'WMS.controller.common.ExcelFailDataCtl'
	],
	views: [
	    'common.ExcelImportView'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		
		this.control({
			//导入按钮事件
			'excelimportview  button[name=btn-import]': {
				click: this.onImport
			}
		});
	},
	/**
	 * 导入按钮事件
	 */
	onImport: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		//取得表单对象
		var form = win.down('form');
		
		//取得文件名
		var fileName = form.down('filefield[name=file]').getValue();
		
		if(fileName == "") {
			ACBEE.Ext.Util.showAlertBox("请选择需要导入的Excel文件！", null, 300);
			return false;
		}
		
		//将文件名转换成小写
		fileName = fileName.toLowerCase();
		//设定能上传的文件类型
		var regFile = new RegExp(/\.(xls|xlsx)$/);
		//检测文件名是否符合上传类型
		if(regFile.test(fileName) == false) {
			ACBEE.Ext.Util.showAlertBox("文件类型错误，只能导入Excel文件(*.xls或*.xlsx)", null, 300);
			return false;
		}
		
		var me = this;
		//提交表单内容到后台
		ACBEE.Ext.Util.submitFormData(form, win.url, {
	    }, win.itemName + "导入成功", win.itemName + "导入失败！！！", function(result) {
	    	if(null != win.parentStore && undefined != win.parentStore
	    		&& (null == win.params || undefined == win.params
	    		|| (null != win.params && undefined != win.params 
	    			&& null != win.params.refreshGrid && undefined != win.params.refreshGrid && win.params.refreshGrid))) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			//关闭本窗口
			win.close();			
			
			if (null != win.onAfterImport && undefined != win.onAfterImport) {
				//执行导入后事件
				win.onAfterImport(win.parentStore, result.map.successList, win.params);
			}
			ACBEE.Ext.Util.showAlertBox(result.msg, null, 300/*, function() {
				if(null != win.onAfterImport && undefined != win.onAfterImport) {
					//执行导入后事件
					win.onAfterImport(win.parentStore, result.map.successList, win.params);
				}
			}*/);
		}, function(action) {
			//关闭本窗口
			win.close();
		
			//此处判断是处理当后台处理出错或登录超时
			if(null == action.result || undefined == action.result
				|| null == action.result.map || undefined == action.result.map 
				|| null == action.result.map.fields || undefined == action.result.map.fields ) {
				return false;
			}
			
			if(null != win.parentStore && undefined != win.parentStore
		    	&& (null == win.params || undefined == win.params
			    || (null != win.params.refreshGrid && undefined != win.params.refreshGrid && win.params.refreshGrid))) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			
			if(null != win.onAfterImport && undefined != win.onAfterImport) {
				//执行导入后事件
				win.onAfterImport(win.parentStore, action.result.map.successList, win.params);
			}
			
			//加载导入错误数据控制器
			ACBEE.Ext.Util.loadController(me.application, "common.ExcelFailDataCtl");
			//显示导入错误数据window
			var failWin = ACBEE.Ext.Util.getWin('excelfaildataview');
			failWin.setTitle(win.itemName + '导入失败数据');
			//保存错误数据
			failWin.failData = action.response.responseText;
			failWin.show();
		});
	}
});