/**
 * 业务引导图controller.
 * @author 奚志敏
 * @version 1.0.0, 2015-09-11
 */
Ext.define('WMS.controller.guide.BizGuideCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'guide.BizGuideView'
	],
	requires: [
	    'WMS.view.guide.BizGuideView'
   	],
	init:function(){
		//调用父方法
		this.callParent();
		
	    this.control({
	    	//panel事件
	    	'bizguideview' : {
	    		//布局后事件
	    		afterlayout: this.onAfterLayout
	    	}
	    });
	},
	//布局后事件
	onAfterLayout: function(panel, layout, eOpts) {
		var guideImg = panel.down('image[name=img_guide]');
		//根据不同模块，更换导航图片
		guideImg.setSrc('images/guide/' + panel.iconCls + '.png');
		
		var top = parseInt((panel.getHeight() - guideImg.getHeight()) / 2);
		var left = parseInt((panel.getWidth() - guideImg.getWidth()) / 2);
		guideImg.setXY([left + 217, top + 112]);
	}
});