/**
 * 入库上架操作信息编辑controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-21
 */
Ext.define('WMS.controller.instock.InstockBillEditCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'instock.InstockBillEditView'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//保存按钮事件
			'instockbilleditview  button[name=btn-save]': {
				click: this.onSave
			},
			//列表点击事件
			'instockbilleditview grid':{
	    		cellclick: this.onGridEditCellClick
			},
			//实际入库位初期化列表
			'instockbilleditview combobox[name=locationCbx]':{
				expand: this.onCellComboboxClick
			},
			'instockbilleditview':{
				beforeshow: this.OnBeforeShow
			}
		});
	},
	onGridEditCellClick : function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts){
		if (7 == cellIndex){
			// 单元格点击赋值静态变量
			WMS.controller.instock.InstockBillEditCtl.areaId = record.data.areaId;	
		}
		if (7 == cellIndex){
			var locationNoCbx = grid.up('grid').down('combobox[name=actualLocation]');
			if(locationNoCbx != null){
				var locationStore = locationNoCbx.getStore();
				locationStore.clearValue();
				locationStore.proxy.extraParams = {
					areaId: WMS.controller.instock.InstockBillEditCtl.areaId,
		    	 	areaNature:-1,
		    	 	status : 1
				};
				locationStore.load();
			}
		}
	},
	// 重新加载实际入库位数据 
	onCellComboboxClick:function(combobox, record, value){
		var locationStore = combobox.getStore();
		locationStore.proxy.extraParams = {
			areaId: WMS.controller.instock.InstockBillEditCtl.areaId,
    	 	areaNature:-1,
    	 	status : 1
		};
		locationStore.load();
	},
	OnBeforeShow : function(win,e){
		var store = win.down('grid').getStore();
		store.load({
			url: 'instockBill/searchInstockBillItemList.action',
			params: {instockBillId: win.oldInstockBillId}
		});
		
		//刷新表格中的库位号下拉框数据
		locationStore.reload();
	},
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		//取得表单对象
		var form = win.down('form');
		//取得表格对象
		var grid = win.down('grid');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！");
			return false;
		}
		
		//验证表格数据
		if(!this.checkGridData(grid)) {
			return false;
		}
		//取得表格数据
		var goods = ACBEE.Ext.Util.getStoreArrayData(grid.getStore());
		var instockBillId=win.oldInstockBillId;
		//提交表单数据到后台
		ACBEE.Ext.Util.submitFormData(form, 'instockBill/saveInstockGroundingBill.action', {
			instockBillId: instockBillId,
			goods:goods
		}, "入库上架操作成功", "入库上架操作失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
	},
	//验证表格数据
	checkGridData: function(grid) {
		var store = grid.getStore();
		var actualLocation;
		var groundingStatus;
		//未上架、实际库位为空个数
		var downCount = 0;
		//未上架个数
		 var count = 0;
		//遍历表格数据
		for (var i = 0; i < store.getCount(); i++) {
			actualLocation = store.getAt(i).get('actualLocation');
			groundingStatus = store.getAt(i).get('groundingStatus');
			if (groundingStatus==0){
				count++;
			}
		    if(null == actualLocation && groundingStatus==0){//未上架的并且实际数量为空
		   		downCount++;
		    } 
		}
		if(downCount == count){
			ACBEE.Ext.Util.showAlertBox("必须上架一批货物！", null, 300);
			return false;
		} 
		return true;
	}
});