/**
 * 入库上架操作信息管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-21
 */
Ext.define('WMS.controller.instock.InstockBillSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'instock.InstockBillSearchView'
	],
	requires: [
	    'WMS.view.instock.InstockBillEditView',
	    'WMS.controller.instock.InstockBillEditCtl'
   	],
   	stores:[
	    'WMS.store.instock.InstockBillItemGoodsViewStr'
	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//复选框显示禁用项改变事件
	    	'instockbillsearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
	    	//查询按钮事件
	    	'instockbillsearchview button[name=btn-search]': {
	    		click: this.onSearchInstockBill
	    	},
	    	//清空按钮事件
	    	'instockbillsearchview button[name=btn-clear]': {
	    		click: this.onClearInstockBill
	    	},
	    	//表格事件
	    	'instockbillsearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	
    	//刷新供应商下拉框数据
    	grid.down('combobox[name=supplierId]').getStore().reload();
    },
	 //复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		var form = combobox.up('form');
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();

		//根据显示禁用项的值重新加载供应商下拉框数据
		var supplierCbx = form.down('combobox[name=supplierId]');
		var supplierStore = supplierCbx.getStore();
		if(!showForbidden){//不显示禁用项时取状态为启用的供应商
			//修改供应商store参数
			supplierStore.proxy.extraParams = {
				status: 1
			};
		}else{
			//修改供应商store参数
			supplierStore.proxy.extraParams = {
				status: -1
			};
		}
		//重加载供应商下拉框数据
		supplierStore.load();
		
		//显示禁用项改变时，供应商改为全部
		if(showForbidden != null){
			supplierCbx.setValue();
		}
	     //调用查询按钮事件
		this.onSearchInstockBill(combobox);
	},
	//查询按钮事件处理
	onSearchInstockBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var instockBillGrid = button.up('grid');
		//取得表单对象
		var form = instockBillGrid.down('form');
		//验证表单
		if(!form.isValid()){
        	ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
        	return false;
		}
		
		//获得查询条件
		//取得入库需求号
		var demandNo = instockBillGrid.down('textfield[name=demandNo]').getValue();
		//取得预约开始日期
		if(instockBillGrid.down('datefield[name=instockBillBeginDate]').getValue()==null)
			var instockBillBeginDate=null;
	    else
		    instockBillBeginDate = Ext.Date.format(new Date(instockBillGrid.down('datefield[name=instockBillBeginDate]').getValue()),'Y-m-d H:i:s');
		//取得预约结束日期
		if(instockBillGrid.down('datefield[name=instockBillEndDate]').getValue()==null)
			var instockBillEndDate=null;
	    else    
		    instockBillEndDate = Ext.Date.format(new Date(instockBillGrid.down('datefield[name=instockBillEndDate]').getValue()),'Y-m-d H:i:s');
		 //取得计划到货开始时间
		if(instockBillGrid.down('datetimefield[name=planBillBeginDate]').getValue()==null)
	    	var planBillBeginDate=null;
	    else
			planBillBeginDate = Ext.Date.format(new Date(instockBillGrid.down('datetimefield[name=planBillBeginDate]').getValue()),'Y-m-d H:i:s');
		//取得计划到货结束时间
	    if(instockBillGrid.down('datetimefield[name=planBillEndDate]').getValue()==null)
    		var planBillEndDate=null;
    	else
			planBillEndDate = Ext.Date.format(new Date(instockBillGrid.down('datetimefield[name=planBillEndDate]').getValue()),'Y-m-d H:i:s');
		//取得供应商
		var supplierId = instockBillGrid.down('combobox[name=supplierId]').getValue();
		//取得订单号
		var orderNo = instockBillGrid.down('textfield[name=orderNo]').getValue();
		/*//获取入库库区
		var areaId = instockBillGrid.down('combobox[name=areaId]').getValue();*/
		//获取入库状态
		var status = instockBillGrid.down('combobox[name=status]').getValue();
	    //取得显示禁用项
	    var showForbidden=instockBillGrid.down('checkbox[name=showForbidden]').getValue();
		
		//取得入库需求单的store
		var store = instockBillGrid.getStore();
		//设置查询参数
		store.proxy.extraParams = {
			demandNo : demandNo,
			instockBillBeginDate : instockBillBeginDate,
			instockBillEndDate : instockBillEndDate,
			planBillBeginDate : planBillBeginDate,
			planBillEndDate : planBillEndDate,
			supplierId : supplierId,
			orderNo : orderNo,
			supplierStatus: showForbidden ? -1 : 1,
			//areaId : areaId,
			status : status,
			flag : 2
		};
		store.loadPage(1);
	},
	//清空按钮事件
	onClearInstockBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var instockBillGrid = button.up('grid');
		///清空查询条件
		instockBillGrid.down('textfield[name=demandNo]').setValue('');
		instockBillGrid.down('datefield[name=instockBillBeginDate]').setValue('');
		instockBillGrid.down('datefield[name=instockBillEndDate]').setValue('');
		instockBillGrid.down('datetimefield[name=planBillBeginDate]').setValue('');
	    instockBillGrid.down('datetimefield[name=planBillEndDate]').setValue('');
		instockBillGrid.down('combobox[name=supplierId]').setValue('');
		//instockBillGrid.down('combobox[name=areaId]').setValue(-1);
		instockBillGrid.down('combobox[name=status]').setValue('-1');
		instockBillGrid.down('checkbox[name=showForbidden]').reset();
		this.onSearchInstockBill(button);
	},
	//上架按钮事件
	onUpdateInstockBill:function (grid,record){
		//加载上架控制器
        ACBEE.Ext.Util.loadController(this.application, "instock.InstockBillEditCtl");
		//显示上架window
		var win = ACBEE.Ext.Util.getWin('instockbilleditview');
		//保存当前表格的store
	  	win.parentStore=grid.getStore();
	  	//保存入库单Id
	  	win.oldInstockBillId=record.data.instockBillId;
	 	//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('货物上架 [' + record.get('demandNo') + ']');
	    win.show();
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(16== cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-grounding')) {//点击了上架
				this.onUpdateInstockBill(grid,record);
			} 
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('grounding')) {
			this.onUpdateInstockBill(grid, record);
		}
	}
});