/**
 * 核实数量信息编辑controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.controller.instock.InstockCheckNumberEditCtl',{
    extend: 'Ext.app.Controller',
	views: [
		'instock.InstockCheckNumberEditView',
		'instock.InstockDemandBillSpecsView'
	],
	stores:[
	    'WMS.store.instock.InstockDemandBillItemGoodsViewStr'
	],
	requires: [
	    'WMS.controller.instock.InstockDemandBillSpecsEditCtl',
	    'WMS.view.instock.InstockDemandBillSpecsView'
   	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//保存按钮事件
			'instockchecknumbereditview  button[name=btn-save]': {
				click: this.onSave
			},
			'instockchecknumbereditview':{
				beforeshow: this.OnBeforeShow,
				//单元格单击事件
	    		cellclick: this.onGridEditCellClick
			},
			'instockchecknumbereditview grid':{
	    		cellclick: this.onGridEditCellClick
			},
			//添加确定事件
			'instockdemandbillspecsview  button[name=btn-sure]' :{
				click : this.onSure
			}
		});
	},
	OnBeforeShow : function(win,e){
		var store = win.down('grid').getStore();
		store.load({
			url: 'instockDemandBill/searchInstockDemandBillItemList.action',
			params: {instockDemandBillId: win.oldInstockDemandBillId}
		});
		
		//刷新实际入库组下拉框数据
		win.down('combobox[name=actualInstockGroup]').getStore().reload();
		//刷新表格中的卸货方式下拉框数据
		unloadWayStore.reload();
	},
	//验证表格数据
	checkGridData: function(grid) {
		var store = grid.getStore();
		var actualArrivalQuantity;
		var unloadWay;
		var packingSpecs;
		//遍历表格数据
		for (var i = 0; i < store.getCount(); i++) {
			actualArrivalQuantity = store.getAt(i).get('actualArrivalQuantity');
			if(undefined == actualArrivalQuantity) {
				ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的实际到货数量不能为空", null, 300);
				return false;
			}
			
			unloadWay = store.getAt(i).get('unloadWay');
			if("" == unloadWay) {
				ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的卸货方式不能为空", null, 300);
				return false;
			}
			packingSpecs = store.getAt(i).get('packingSpecs');
				if(undefined == packingSpecs) {
				ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的包装规格不能为空", null, 300);
				return false;
			}
		}
		return true;
	},
	//弹出包装规格编辑
	onGridEditCellClick : function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ){
		if(8 == cellIndex){
			//加载包装规格编辑控制器
	        ACBEE.Ext.Util.loadController(this.application, "instock.InstockDemandBillSpecsEditCtl");
			//显示包装规格window
			var win = ACBEE.Ext.Util.getWin('instockdemandbillspecsview');
			//获取包装规格
			var packingSpecs = record.data.packingSpecs;
			if(packingSpecs != undefined){
				var form = win.down('form');
				var strData = packingSpecs.split(',');
				var panelNum = form.items.items;
				for(var i=0;i<strData.length;i++){
					var numberDate = strData[i].split('*');
				    	var panelControllers = panelNum[i+1].items.items;
				    	panelControllers[0].setValue(numberDate[0]);
				    	panelControllers[2].setValue(numberDate[1]);
				}
			} else {
				//获取实际到货数量
				var actualArrivalQuantity = record.data.actualArrivalQuantity;
				//如果实际到货数量为空，则提示
				if(actualArrivalQuantity == null || actualArrivalQuantity == ""){
					ACBEE.Ext.Util.showAlertBox("请先填写实际到货数量！！！", null, 300);
					return false;
				}
			}
			win.rowIndex = rowIndex;
			win.showAt(e.getXY());
		}
	},
	//确定按钮事件
	onSure : function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		var form = win.down('form');
		//结果
		var goodsNum = 0;
		//包装数量*托盘数组成的字符串
		var packString = "";
		//获取数量核实store
		var store = Ext.getCmp('instockchecknumbereditview').down('grid').getStore();
		//获取实际到货数量
		var actualArrivalQuantity = store.getAt(win.rowIndex).get('actualArrivalQuantity');
		//获取panel个数
		var panelNum = form.items.items;
		//遍历panel，取得panel中的包装数量和托盘数
		for(var i=1;i<panelNum.length-1;i++){
			//获取panel中控件个数
			var panelControllers = panelNum[i].items.items;
			if(panelControllers[0].value !="" && panelControllers[0].value !=null && panelControllers[2].value!="" && panelControllers[2].value !=null){
				if(panelControllers[0].value == 0 || panelControllers[2].value == 0){
					ACBEE.Ext.Util.showAlertBox("托盘数和包装数量不能输入零,如果添加自动清除！！！", null, 300);
				} else {
					goodsNum += parseInt(parseInt(panelControllers[0].value)*parseInt(panelControllers[2].value)); 
				 	packString += panelControllers[0].value + "*"+ panelControllers[2].value+',';
				}
			}
		}
		//判断实际到货数量与累加起来的数量是否相等
		if(parseInt(goodsNum) == parseInt(actualArrivalQuantity)){
			//去掉最后一个逗号
			var reg=/,$/gi; 
			packString=packString.replace(reg,""); 
			store.getAt(win.rowIndex).set('packingSpecs',packString);
			win.close();
		} else {
			ACBEE.Ext.Util.showAlertBox("不等于实际到货数量 ,请重新输入！！！", null, 300);
		}
	},
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		//取得表单对象
		var form = win.down('form');
		//取得表格对象
		var grid = win.down('grid');
		
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！");
			return false;
		}
		
		//验证表格数据
		if(!this.checkGridData(grid)) {
			return false;
		}

		var hasError = false;
		//获取服务器时间
		ACBEE.Ext.Util.ajaxRequest("date/getServerTime.action",null,function(result){
			if(undefined != result && null != result) {
				//取得当前服务器日期
				var curDate = Ext.Date.format(new Date(result), "Y-m-d");
				//获取预约日期
				var appointmentDate = win.down('displayfield[name=appointmentDate]').getValue();
				appointmentDate =  Ext.Date.format(new Date(appointmentDate), "Y-m-d");
				//获取实际到货时间
				var actualArrivalTime = win.down('datefield[name=actualArrivalTime]').getValue();
				actualArrivalTime = Ext.Date.format(new Date(actualArrivalTime), "Y-m-d");
				if(actualArrivalTime > curDate) {
					ACBEE.Ext.Util.showAlertBox("实际到货时间不能晚于当前日期[" + curDate + "]！", null, 300);
					hasError = true;
					return false;
				}
				if(actualArrivalTime < appointmentDate) {
					ACBEE.Ext.Util.showAlertBox("实际到货日期不能早于预约日期[" + appointmentDate + "]！", null, 300);
					hasError = true;
					return false;
				}
			}
	  	});
		
		if(hasError) {
			return false;
		}

		var store = grid.getStore();
		var totalQuantity = 0;
		var totalPrice = 0.0;
		for (var i = 0; i < store.getCount(); i++) {
			price = store.getAt(i).get('price');
			planArrivalQuantity = store.getAt(i).get('planArrivalQuantity');
			totalQuantity = totalQuantity * 1 + planArrivalQuantity * 1;
			totalPrice = totalPrice * 1 + ((price * 1) * (planArrivalQuantity * 1));
		}
		
		//取得表格数据
		var goods = ACBEE.Ext.Util.getStoreArrayData(grid.getStore());
		var oldInstockDemandBillId=win.oldInstockDemandBillId;
		//提交表单数据到后台
		ACBEE.Ext.Util.submitFormData(form, 'instockDemandBill/saveInstockDemandBill.action', {
			oldInstockDemandBillId: oldInstockDemandBillId,
			goods:goods,
			totalPrice:totalPrice,
			totalQuantity:totalQuantity,
			flag : 1
		}, "入库预约单核实成功", "入库预约单核实失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
	}
});