/**
 * 核实数量信息管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.controller.instock.InstockCheckNumberSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'instock.InstockCheckNumberSearchView'
	],
	requires: [
	    'WMS.view.instock.InstockCheckNumberEditView',
	    'WMS.controller.instock.InstockCheckNumberEditCtl'
   	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//复选框显示禁用项改变事件
	    	'instockchecknumbersearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
	    	//查询按钮事件
	    	'instockchecknumbersearchview button[name=btn-search]': {
	    		click: this.onSearchInstockCheckNumber
	    	},
	    	//清空按钮事件
	    	'instockchecknumbersearchview button[name=btn-clear]': {
	    		click: this.onClearInstockDemandBill
	    	},
	    	//表格事件
	    	'instockchecknumbersearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	
    	//刷新供应商下拉框数据
    	grid.down('combobox[name=supplierId]').getStore().reload();
    },
	 //复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		var form = combobox.up('form');
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();

		//根据显示禁用项的值重新加载供应商下拉框数据
		var supplierCbx = form.down('combobox[name=supplierId]');
		var supplierStore = supplierCbx.getStore();
		if(!showForbidden){//不显示禁用项时取状态为启用的供应商
			//修改供应商store参数
			supplierStore.proxy.extraParams = {
				status: 1
			};
		}else{
			//修改供应商store参数
			supplierStore.proxy.extraParams = {
				status: -1
			};
		}
		//重加载供应商下拉框数据
		supplierStore.load();
		
		//显示禁用项改变时，供应商改为全部
		if(showForbidden != null){
			supplierCbx.setValue();
		}
	     //调用查询按钮事件
		this.onSearchInstockCheckNumber(combobox);
	},
	//查询按钮事件处理
	onSearchInstockCheckNumber:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var instockCheckNumberGrid = button.up('grid');
		//取得表单对象
		var form = instockCheckNumberGrid.down('form');
		//验证表单
		if(!form.isValid()){
        	ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
        	return false;
		}
		
		//获得查询条件
		//取得入库需求号
		var demandNo = instockCheckNumberGrid.down('textfield[name=demandNo]').getValue();
		//取得预约开始日期
		if(instockCheckNumberGrid.down('datefield[name=instockDemandBillBeginDate]').getValue()==null)
			var instockDemandBillBeginDate=null;
	    else
		    instockDemandBillBeginDate = Ext.Date.format(new Date(instockCheckNumberGrid.down('datefield[name=instockDemandBillBeginDate]').getValue()),'Y-m-d H:i:s');
		//取得预约结束日期
		if(instockCheckNumberGrid.down('datefield[name=instockDemandBillEndDate]').getValue()==null)
			var instockDemandBillEndDate=null;
	    else    
		    instockDemandBillEndDate = Ext.Date.format(new Date(instockCheckNumberGrid.down('datefield[name=instockDemandBillEndDate]').getValue()),'Y-m-d H:i:s');
		 //取得计划到货开始时间
		if(instockCheckNumberGrid.down('datetimefield[name=planDemandBillBeginDate]').getValue()==null)
	    	var planDemandBillBeginDate=null;
	    else
			planDemandBillBeginDate = Ext.Date.format(new Date(instockCheckNumberGrid.down('datetimefield[name=planDemandBillBeginDate]').getValue()),'Y-m-d H:i:s');
		//取得计划到货结束时间
	    if(instockCheckNumberGrid.down('datetimefield[name=planDemandBillEndDate]').getValue()==null)
    		var planDemandBillEndDate=null;
    	else
			planDemandBillEndDate = Ext.Date.format(new Date(instockCheckNumberGrid.down('datetimefield[name=planDemandBillEndDate]').getValue()),'Y-m-d H:i:s');
		//取得供应商
		var supplierId = instockCheckNumberGrid.down('combobox[name=supplierId]').getValue();
		//取得订单号
		var orderNo = instockCheckNumberGrid.down('textfield[name=orderNo]').getValue();
	    //取得显示禁用项
	    var showForbidden=instockCheckNumberGrid.down('checkbox[name=showForbidden]').getValue();
		
		//取得入库需求单的store
		var store = instockCheckNumberGrid.getStore();
		//设置查询参数
		store.proxy.extraParams = {
			demandNo : demandNo,
			instockDemandBillBeginDate : instockDemandBillBeginDate,
			instockDemandBillEndDate : instockDemandBillEndDate,
			planDemandBillBeginDate : planDemandBillBeginDate,
			planDemandBillEndDate : planDemandBillEndDate,
			supplierId : supplierId,
			orderNo : orderNo,
			supplierStatus: showForbidden ? -1 : 1,
			flag : 0
		};
		store.loadPage(1);
	},
	//清空按钮事件
	onClearInstockDemandBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var instockCheckNumberGrid = button.up('grid');
		///清空查询条件
		instockCheckNumberGrid.down('textfield[name=demandNo]').setValue('');
		instockCheckNumberGrid.down('datefield[name=instockDemandBillBeginDate]').setValue('');
		instockCheckNumberGrid.down('datefield[name=instockDemandBillEndDate]').setValue('');
		instockCheckNumberGrid.down('datetimefield[name=planDemandBillBeginDate]').setValue('');
	    instockCheckNumberGrid.down('datetimefield[name=planDemandBillEndDate]').setValue('');
		instockCheckNumberGrid.down('combobox[name=supplierId]').setValue('');
		instockCheckNumberGrid.down('textfield[name=orderNo]').setValue('');
		instockCheckNumberGrid.down('checkbox[name=showForbidden]').reset();
		this.onSearchInstockCheckNumber(button);
	},
	//修改按钮事件
	onUpdateInstockDemandBill:function (grid,record){
		//加载库区编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "instock.InstockCheckNumberEditCtl");
		//显示库区window
		var win = ACBEE.Ext.Util.getWin('instockchecknumbereditview');
		//保存当前表格的store
	  	win.parentStore=grid.getStore();
	  	//保存入库需求单Id
	  	win.oldInstockDemandBillId=record.data.instockDemandBillId;
	 	//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('核实入库需求单 [' + record.get('demandNo') + ']');
	    win.show();
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(12== cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-checkNumber')) {//点击了核实数量
				this.onUpdateInstockDemandBill(grid,record)
			} 
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('checkNumber')) {
			this.onUpdateInstockDemandBill(grid, record);
		}
	}
});