/**
 * 预约入库信息编辑controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.controller.instock.InstockDemandBillEditCtl',{
    extend: 'Ext.app.Controller',
	views: [
		'instock.InstockDemandBillEditView'
	],
	stores:[
	    'WMS.store.instock.InstockDemandBillItemGoodsViewStr'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//添加按钮事件
			'instockdemandbilleditview  button[name=btn-add]': {
				click: this.onAddGoodsInfo
			},
			//删除按钮事件
			'instockdemandbilleditview  button[name=btn-delete]': {
				click: this.onDelete
			},
			//导入按钮事件
			'instockdemandbilleditview  button[name=btn-import]': {
				click: this.onImport
			},
			//导出按钮事件
			'instockdemandbilleditview  button[name=btn-export]': {
				click: this.onExport
			},
			//保存按钮事件
			'instockdemandbilleditview  button[name=btn-save]': {
				click: this.onSave
			},
			//打印按钮事件
			'instockdemandbilleditview  button[name=btn-print]': {
				click: this.onPrint
			},
			'instockdemandbilleditview':{
				beforeshow: this.OnBeforeShow
			}
		});
	},
	OnBeforeShow : function(win,e){
		var store = win.down('grid').getStore();
		store.load({
			url: 'instockDemandBill/searchInstockDemandBillItemList.action',
			params: {instockDemandBillId: win.oldInstockDemandBillId}
		});
		
		//编制入库需求单
		if(0 == win.oldInstockDemandBillId) {
			//获取服务器时间，设置预约日期和计划到货时间
			ACBEE.Ext.Util.ajaxRequest("date/getServerTime.action",null,function(result){
				if(undefined != result && null != result) {
					win.down('datefield[name=appointmentDate]').setValue(Ext.Date.format(new Date(result), "Y-m-d"));
				}
		  	});
		}
		
		//刷新供应商下拉框数据
		win.down('combobox[name=supplierId]').getStore().reload();
		//刷新入库性质下拉框数据
		win.down('combobox[name=instockNature]').getStore().reload();
		//刷新预约入库组下拉框数据
		win.down('combobox[name=instockGroup]').getStore().reload();
		//刷新表格中的入库库区下拉框数据
		instockStore.reload();
	},
	//添加按钮事件
	onAddGoodsInfo: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		var grid = win.down('grid');
		var store = grid.getStore();
		var record = Ext.create('WMS.model.instock.InstockDemandBillItemGridMdl');
		store.add(record);
	},
	//打印按钮事件
	onPrint : function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		ACBEE.Ext.Util.showReport({
			report: 'instockDemanderBill',
			instockDemanderBillId: win.oldInstockDemandBillId
		});
	},
	//删除按钮事件
	onDelete: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		var grid = win.down('grid');
		var records=grid.getSelectionModel().getSelection(); 
		for(var i=0;i<records.length;i++){
			grid.getStore().remove(records[i]);
		}
		grid.view.refresh();
	},
	/**
	 * 处理导入成功的数据
	 */
	onDealImportSucceedData: function(store, successList) {
		// BugID:725
		// Describe:<修正前：Ext接收后台信息，提示框关闭前处理事件，修正后：提示框关闭后处理事件。>
		// ReWriter:楊偉艾
		// ReWrite date:<2015-12-23>
		var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"正在加载数据，请稍候..."});
		myMask.show();
		
		if(null == successList || undefined == successList) {
			return;
		}
		
		var record;
		var index = -1;
		var msg = '';
		for(var i=0;i<successList.length;i++){
			//查找原store中是否已经存在货物号
			index = store.find('goodsCode', successList[i].goodsCode);
        	if(-1 != index) {
        		if("" != msg) {
        			msg += "，";
        		}
        		msg += successList[i].goodsCode;
        		continue;
        	}
			
			record = Ext.create('WMS.model.instock.InstockDemandBillItemGridMdl', {
				goodsCode: successList[i].goodsCode,
				goodsName: successList[i].goodsName,
				goodsId: successList[i].goodsId,
				specs: successList[i].specs,
				productBatch: successList[i].productBatch,
				planArrivalQuantity: successList[i].planArrivalQuantity,
				price: successList[i].price,
				areaId: successList[i].areaId
			});
			store.add(record);
		}
		myMask.hide();
		if("" != msg) {
			msg = "货物号为：［" + msg + "］的货物已经存在表格中，不再追加！";
			ACBEE.Ext.Util.showAlertBox(msg, null, 400);
		}
	},
	//导入按钮事件
	onImport: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		ACBEE.Ext.Util.importExcelFile(this.application, "instockDemandBill/importInstockDemandBillItemGoods.action", 
			"入库需求单-货物明细信息",  button.up('grid').getStore(), this.onDealImportSucceedData, {
			refreshGrid: false
		});
	},
	//导出按钮事件
	onExport: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
		//导出预约出库信息
		ACBEE.Ext.Util.exportExcelFile(grid, "入库需求单-货物明细信息", ['areaId']);
	},
	//验证表格数据
	checkGridData: function(grid) {
		var store = grid.getStore();
		if(null == store || undefined == store || 0 == store.getCount()) {
			ACBEE.Ext.Util.showAlertBox("请添加至少一条货物明细", null, 300);
			return false;
		}
		
		var goodsCode;
		var areaId;
		var productBatch;
		var planArrivalQuantity;
		//货物号与生产批号拼接的字符串
		var goodsLinkareaId = "";
		//遍历表格数据
		for (var i = 0; i < store.getCount(); i++) {
			goodsCode = store.getAt(i).get('goodsCode');
			productBatch = store.getAt(i).get('productBatch');
			if("" == goodsCode) {
				ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的货物号不能为空", null, 300);
				return false;
			}
			planArrivalQuantity = store.getAt(i).get('planArrivalQuantity');
				if("" == planArrivalQuantity) {
				ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的计划到货数量不能为空", null, 300);
				return false;
			}
			
			areaId = store.getAt(i).get('areaId');
			if("" == areaId) {
				ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的入库库区不能为空", null, 300);
				return false;
			}
		/*	if(goodsLinkareaId != ""){
				var splitArray = goodsLinkareaId.split(',');
				for(var j = 0; j<splitArray.length-1;j++){
					if(splitArray[j]==(goodsCode + areaId)){
						ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的货物信息重复", null, 300);
						return false;
					} else {
						goodsLinkareaId += (goodsCode + areaId)+',';
					}
				}
			} else{
				goodsLinkareaId = (goodsCode + areaId)+',';
			}*/	
			for(var j=0; j<i;j++){
				if(store.getAt(j).get('goodsCode') == store.getAt(i).get('goodsCode') && store.getAt(j).get('areaId') == store.getAt(i).get('areaId')){
					ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的货物编号重复", null, 300);
					return false;
				}
			}
		}
		return true;
	},
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		//取得表单对象
		var form = win.down('form');
		//取得表格对象
		var grid = win.down('grid');
		
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！");
			return false;
		}
		
		var hasError = false;
		//获取服务器时间
		ACBEE.Ext.Util.ajaxRequest("date/getServerTime.action",null,function(result){
			if(undefined != result && null != result) {
				//取得当前服务器日期
				var curDate = Ext.Date.format(new Date(result), "Y-m-d");
				var appointmentDate = win.down('datefield[name=appointmentDate]').getValue();
				appointmentDate = Ext.Date.format(new Date(appointmentDate), "Y-m-d");
				if(appointmentDate < curDate) {
					ACBEE.Ext.Util.showAlertBox("预约日期不能早于当前日期[" + curDate + "]！", null, 300);
					hasError = true;
					return false;
				}
				
				//取得当前服务器时间
				var curTime = Ext.Date.format(new Date(result), "Y-m-d H:i:s");
				var planArrivalTime = win.down('datetimefield[name=planArrivalTime]').getValue();
				planArrivalTime = Ext.Date.format(new Date(planArrivalTime), "Y-m-d H:i:s");
				if(planArrivalTime < curTime) {
					ACBEE.Ext.Util.showAlertBox("计划到货时间不能早于当前时间[" + curTime + "]！", null, 300);
					hasError = true;
					return false;
				}
			} else {
				ACBEE.Ext.Util.showAlertBox("无法取得服务器时间，保存入库预约单失败！", null, 300);
				hasError = true;
				return false;
			} 
				
	  	});
		
		if(hasError) {
			return false;
		}
		
		//验证表格数据
		if(!this.checkGridData(grid)) {
			return false;
		}
		
		var store = grid.getStore();
		var totalQuantity = 0;
		var totalPrice = 0.0;
		for (var i = 0; i < store.getCount(); i++) {
			price = store.getAt(i).get('price');
			planArrivalQuantity = store.getAt(i).get('planArrivalQuantity');
			totalQuantity = totalQuantity * 1 + planArrivalQuantity * 1;
			totalPrice = totalPrice * 1 + ((price * 1) * (planArrivalQuantity * 1));
		}
		//取得表格数据
		var goods = ACBEE.Ext.Util.getStoreArrayData(grid.getStore());
		var oldInstockDemandBillId=win.oldInstockDemandBillId;
		//提交表单数据到后台
		ACBEE.Ext.Util.submitFormData(form, 'instockDemandBill/saveInstockDemandBill.action', {
			oldInstockDemandBillId: oldInstockDemandBillId,
			goods:goods,
			totalPrice:totalPrice,
			totalQuantity:totalQuantity,
			flag : 0
		}, "入库预约单生成成功", "入库预约单生成失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
	}
});