/**
 * 预约入库信息管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.controller.instock.InstockDemandBillSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'instock.InstockDemandBillSearchView'
	],
	requires: [
	    'WMS.view.instock.InstockDemandBillEditView',
	    'WMS.controller.instock.InstockDemandBillEditCtl'
   	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//复选框显示禁用项改变事件
	    	'instockdemandbillsearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
        	//编制按钮事件
	    	'instockdemandbillsearchview button[name=btn-drawUp]': {
	    		click: this.onAddInstockDemandBill
	    	},
	    	//查询按钮事件
	    	'instockdemandbillsearchview button[name=btn-search]': {
	    		click: this.onSearchInstockDemandBill
	    	},
	    	//删除按钮事件
	    	'instockdemandbillsearchview button[name=btn-delete]': {
	    		click: this.onDeleteInstockDemandBill
	    	},
	    	//清空按钮事件
	    	'instockdemandbillsearchview button[name=btn-clear]': {
	    		click: this.onClearInstockDemandBill
	    	},
	    	//表格事件
	    	'instockdemandbillsearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	
    	//刷新供应商下拉框数据
    	grid.down('combobox[name=supplierId]').getStore().reload();
    },
	 //复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		var form = combobox.up('form');
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();

		//根据显示禁用项的值重新加载供应商下拉框数据
		var supplierCbx = form.down('combobox[name=supplierId]');
		var supplierStore = supplierCbx.getStore();
		if(!showForbidden){//不显示禁用项时取状态为启用的供应商
			//修改供应商store参数
			supplierStore.proxy.extraParams = {
				status: 1
			};
		}else{
			//修改供应商store参数
			supplierStore.proxy.extraParams = {
				status: -1
			};
		}
		//重加载供应商下拉框数据
		supplierStore.load();
		
		//显示禁用项改变时，供应商改为全部
		if(showForbidden != null){
			supplierCbx.setValue();
		}
	     //调用查询按钮事件
		this.onSearchInstockDemandBill(combobox);
	},
	//编制按钮事件处理
	onAddInstockDemandBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载入库需求单编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "instock.InstockDemandBillEditCtl");
		//显示入库需求单window
		var win = ACBEE.Ext.Util.getWin('instockdemandbilleditview');
		//清除表单内容
	    win.down('form').getForm().reset();
  	  	var store=win.down('grid').getStore();
  	  	if(store.getCount()>0){
  	  		store.removeAll();
  	  	}
		//设置入库需求单Id为零
	  	win.oldInstockDemandBillId=0;
	  	//生成入库需求号
	  	//得到入库需求号对象
	  	var demandNo = win.down('textfield[name=demandNo]');
	  	ACBEE.Ext.Util.ajaxRequest("instockDemandBill/generateInstockDemandBillNum.action",null,function(result){
	  		if(null != demandNo){
	  			demandNo.setValue(result.map.instockDemandBillNum);
	  		}
	  	});
		//保存当前表格的store
	  	win.parentStore=button.up('grid').getStore();
	  	win.show();
	},
	//查询按钮事件处理
	onSearchInstockDemandBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var instockDemandBillGrid = button.up('grid');
		//取得表单对象
		var form = instockDemandBillGrid.down('form');
		//验证表单
		if(!form.isValid()){
        	ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
        	return false;
		}
		
		//获得查询条件
		//取得入库需求号
		var demandNo = instockDemandBillGrid.down('textfield[name=demandNo]').getValue();
		//取得预约开始日期
		if(instockDemandBillGrid.down('datefield[name=instockDemandBillBeginDate]').getValue()==null)
			var instockDemandBillBeginDate=null;
	    else
		    instockDemandBillBeginDate = Ext.Date.format(new Date(instockDemandBillGrid.down('datefield[name=instockDemandBillBeginDate]').getValue()),'Y-m-d H:i:s');
		//取得预约结束日期
		if(instockDemandBillGrid.down('datefield[name=instockDemandBillEndDate]').getValue()==null)
			var instockDemandBillEndDate=null;
	    else    
		    instockDemandBillEndDate = Ext.Date.format(new Date(instockDemandBillGrid.down('datefield[name=instockDemandBillEndDate]').getValue()),'Y-m-d H:i:s');
		 //取得计划到货开始时间
		if(instockDemandBillGrid.down('datetimefield[name=planDemandBillBeginDate]').getValue()==null)
	    	var planDemandBillBeginDate=null;
	    else
			planDemandBillBeginDate = Ext.Date.format(new Date(instockDemandBillGrid.down('datetimefield[name=planDemandBillBeginDate]').getValue()),'Y-m-d H:i:s');
		//取得计划到货结束时间
	    if(instockDemandBillGrid.down('datetimefield[name=planDemandBillEndDate]').getValue()==null)
    		var planDemandBillEndDate=null;
    	else
			planDemandBillEndDate = Ext.Date.format(new Date(instockDemandBillGrid.down('datetimefield[name=planDemandBillEndDate]').getValue()),'Y-m-d H:i:s');
		//取得供应商
		var supplierId = instockDemandBillGrid.down('combobox[name=supplierId]').getValue();
		//取得订单号
		var orderNo = instockDemandBillGrid.down('textfield[name=orderNo]').getValue();
	    //取得显示禁用项
	    var showForbidden=instockDemandBillGrid.down('checkbox[name=showForbidden]').getValue();
		//取得状态
		var status = instockDemandBillGrid.down('combobox[name=status]').getValue();
		
		//取得入库需求单的store
		var store = instockDemandBillGrid.getStore();
		//设置查询参数
		store.proxy.extraParams = {
			demandNo : demandNo,
			instockDemandBillBeginDate : instockDemandBillBeginDate,
			instockDemandBillEndDate : instockDemandBillEndDate,
			planDemandBillBeginDate : planDemandBillBeginDate,
			planDemandBillEndDate : planDemandBillEndDate,
			supplierId : supplierId,
			orderNo : orderNo,
			status: status,
			supplierStatus: showForbidden ? -1 : 1,
			flag : 2
		};
		store.loadPage(1);
	},
	//删除按钮事件处理
	onDeleteInstockDemandBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
			
		//提交删除表格多条数据
		ACBEE.Ext.Util.ajaxDelGridData(grid, 'instockDemandBillId', 'instockDemandBill/delInstockDemandBill.action', '入库需求单');
	},
	//清空按钮事件
	onClearInstockDemandBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var instockDemandBillGrid = button.up('grid');
		///清空查询条件
		instockDemandBillGrid.down('textfield[name=demandNo]').setValue('');
		instockDemandBillGrid.down('datefield[name=instockDemandBillBeginDate]').setValue('');
		instockDemandBillGrid.down('datefield[name=instockDemandBillEndDate]').setValue('');
		instockDemandBillGrid.down('datetimefield[name=planDemandBillBeginDate]').setValue('');
	    instockDemandBillGrid.down('datetimefield[name=planDemandBillEndDate]').setValue('');
		instockDemandBillGrid.down('combobox[name=supplierId]').setValue('');
		instockDemandBillGrid.down('textfield[name=orderNo]').setValue('');
		instockDemandBillGrid.down('combobox[name=status]').setValue('-1');
		instockDemandBillGrid.down('checkbox[name=showForbidden]').reset();
		this.onSearchInstockDemandBill(button);
	},
	//修改按钮事件
	onUpdateInstockDemandBill:function (grid,record){
		//加载入库需求单编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "instock.InstockDemandBillEditCtl");
		//显示入库需求单window
		var win = ACBEE.Ext.Util.getWin('instockdemandbilleditview');
		//保存原入库需求单Id
	  	win.oldInstockDemandBillId=record.data.instockDemandBillId;
		//保存当前表格的store
	  	win.parentStore=grid.getStore();
		if(record.get('status') !=0){
			var save=win.down('button[name=btn-save]');
			var add=win.down('button[name=btn-add]');
			var importData=win.down('button[name=btn-import]');
			var deleteData=win.down('button[name=btn-delete]');
			ACBEE.Ext.Util.disableCompoment([save,add,importData,deleteData], win.down('form'), true);
			win.status = record.get('status');
		}
	 	//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('修改入库需求单 [' + record.get('demandNo') + ']');
	    win.show();
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(17== cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-edit')) {//点击了编辑
				this.onUpdateInstockDemandBill(grid, record);
			} else if(target.hasCls('btn-delete')) {//点击了删除
				var delInfo = '入库需求单 [' + record.get('demandNo') + ']';
				var id = record.get('instockDemandBillId');
			
				//提交删除当前行数据
				ACBEE.Ext.Util.ajaxDelSingleData(grid, delInfo, id, 'instockDemandBill/delInstockDemandBill.action');
			} 
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('edit')) {
			this.onUpdateInstockDemandBill(grid, record);
		}
	}
});