/**
 * 入库任务分配信息编辑controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-21
 */
Ext.define('WMS.controller.instock.InstockTaskEditCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'instock.InstockTaskEditView'
	],
	stores:[
	    'WMS.store.instock.InstockBillItemGoodsViewStr'
	],
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//保存按钮事件
			'instocktaskeditview  button[name=btn-save]': {
				click: this.onSave
			},
			//打印按钮事件
			'instocktaskeditview  button[name=btn-print]': {
				click: this.onPrint
			},
			'instocktaskeditview':{
				beforeshow: this.OnBeforeShow
			}
		});
	},
	OnBeforeShow : function(win,e){
		var store = win.down('grid').getStore();
		store.load({
			url: 'instockBill/searchInstockBillItemList.action',
			params: {instockBillId: win.oldInstockBillId}
		});
		
		//刷新上架组下拉框数据
		win.down('combobox[name=groundingGroup]').getStore().reload();
	},
	//打印按钮事件
	onPrint : function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		ACBEE.Ext.Util.showReport({
			report: 'instockBill',
			instockBillId: win.oldInstockBillId
		});
	},
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		//取得表单对象
		var form = win.down('form');
		//取得表格对象
		var grid = win.down('grid');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！");
			return false;
		}
		
		var oldInstockBillId=win.oldInstockBillId;
		//提交表单数据到后台
		ACBEE.Ext.Util.submitFormData(form, 'instockBill/saveInstockBill.action', {
			oldInstockBillId: oldInstockBillId
		}, "入库任务分配成功", "入库任务分配失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
	}
});