/**
 * 出库下架操作信息编辑controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-21
 */
Ext.define('WMS.controller.outstock.OutstockBillEditCtl',{
   extend: 'Ext.app.Controller',
	views: [
		'outstock.OutstockBillEditView',
		'cancelstock.LocationNoView'
	],
	stores:[
	    'WMS.store.outstock.OutstockBillItemGoodsViewStr',
	     'WMS.store.common.LocationNoStr'
	],
	requires: [
	    'WMS.controller.cancelstock.LocationNoViewCtl',
	    'WMS.view.cancelstock.LocationNoView'
   	],
   	statics:{
   		goodsId : '',
   		supplierId : '',
   		locationId : '',
   		areaId : ''
   	},
	init: function() {
		//调用父类方法
		this.callParent();
		this.control({
			//保存按钮事件
			'outstockbilleditview  button[name=btn-save]': {
				click: this.onSave
			},
			//加载前事件
			'outstockbilleditview':{
				beforeshow: this.OnBeforeShow
			},
			//列表点击事件
			'outstockbilleditview grid':{
	    		cellclick: this.onGridEditCellClick
			},
			//入库时间初期化列表
			'outstockbilleditview combobox[name=instockTime]':{
				expand: this.onCellComboboxClick
			},
			//入库时间初期化列表
			'outstockbilleditview combobox[name=areaCbx]':{
				expand: this.onCellComboboxClick
			},
			//实际出库位初期化列表
			'outstockbilleditview combobox[name=locationCbx]':{
				expand: this.onCellComboboxClick
			}
		});
	},
	OnBeforeShow : function(win, e){
		var store = win.down('grid').getStore();
		store.load({
			url: 'outstockBill/searchOutstockBillItemList.action',
			params: {outstockBillId: win.oldOutstockBillId}
		});
		
		//刷新实际出库组下拉框数据
		win.down('combobox[name=actualOutstockGroup]').getStore().reload();
	},
	onGridEditCellClick : function (grid, td, cellIndex, record, tr, rowIndex, e, eOpts){
		if ((9 == cellIndex) || (10 == cellIndex) || (12 == cellIndex)){
			// 单元格点击赋值静态变量
			WMS.controller.outstock.OutstockBillEditCtl.goodsId = record.data.goodsId;	
			WMS.controller.outstock.OutstockBillEditCtl.supplierId = record.data.supplierId;
			WMS.controller.outstock.OutstockBillEditCtl.locationId = record.data.locationNo;
			WMS.controller.outstock.OutstockBillEditCtl.areaId = record.data.areaName;
		}
		if (9 == cellIndex){//库区下拉框
			var areaNameCbx = grid.up('grid').down('combobox[name=areaName]');
			WMS.controller.outstock.OutstockBillEditCtl.goodsId = record.data.goodsId;	
			WMS.controller.outstock.OutstockBillEditCtl.supplierId = record.data.supplierId;
			WMS.controller.outstock.OutstockBillEditCtl.locationId = null;
			WMS.controller.outstock.OutstockBillEditCtl.areaId = null;
			if(areaNameCbx != null){
				var areaStore = areaNameCbx.getStore();
				areaStore.clearValue();
				areaStore.proxy.extraParams = {
					goodsId: WMS.controller.outstock.OutstockBillEditCtl.goodsId,
	    	 		supplierId: WMS.controller.outstock.OutstockBillEditCtl.supplierId
				};
				areaStore.load();
			}
		}
		if (10 == cellIndex){//库位下拉框
			var locationNoCbx = grid.up('grid').down('combobox[name=locationNo]');
			var areaNameCbx = grid.up('grid').down('combobox[name=areaName]');
			if(WMS.controller.outstock.OutstockBillEditCtl.areaId == null){
				ACBEE.Ext.Util.showAlertBox("请先选择库区，再选库位！", null, 300);
				return false;
				WMS.controller.outstock.OutstockBillEditCtl.goodsId = 0;	
				WMS.controller.outstock.OutstockBillEditCtl.supplierId = 0;
				WMS.controller.outstock.OutstockBillEditCtl.locationId =0;
				WMS.controller.outstock.OutstockBillEditCtl.areaId = 0;
				//alert('请先选择库区，再选库位！');
			}else if(areaNameCbx != null){
				var locationStore = locationNoCbx.getStore();
				WMS.controller.outstock.OutstockBillEditCtl.goodsId = record.data.goodsId;	
				WMS.controller.outstock.OutstockBillEditCtl.supplierId = record.data.supplierId;
				WMS.controller.outstock.OutstockBillEditCtl.locationId =null;
				WMS.controller.outstock.OutstockBillEditCtl.areaId = record.data.areaName;
				locationStore.clearValue();
				locationStore.proxy.extraParams = {
					goodsId: WMS.controller.outstock.OutstockBillEditCtl.goodsId,
	    	 		supplierId: WMS.controller.outstock.OutstockBillEditCtl.supplierId,
	    	 		areaId: WMS.controller.outstock.OutstockBillEditCtl.areaId
				};
				locationStore.load();
			}
		}
		if (12 == cellIndex) {//入库时间下拉框
			var instockTimeCbx = grid.up('grid').down('combobox[name=instockTime]');
			if(instockTimeCbx != null){
				var instockTimeStore = instockTimeCbx.getStore();
				instockTimeStore.proxy.extraParams = {
						goodsId: WMS.controller.outstock.OutstockBillEditCtl.goodsId,
		    	 		supplierId: WMS.controller.outstock.OutstockBillEditCtl.supplierId,
		    	 		locationId: WMS.controller.outstock.OutstockBillEditCtl.locationId
				};
				instockTimeStore.load();
			}
		}
	},
	// 共通过滤方法，重新加载实际入库位和入库时间数据 
	onCellComboboxClick:function(combobox, record, value){
		var instockTimeStore = combobox.getStore();
			instockTimeStore.proxy.extraParams = {
					goodsId: WMS.controller.outstock.OutstockBillEditCtl.goodsId,
	    	 		supplierId: WMS.controller.outstock.OutstockBillEditCtl.supplierId,
	    	 		locationId: WMS.controller.outstock.OutstockBillEditCtl.locationId,
	    	 		areaId: WMS.controller.outstock.OutstockBillEditCtl.areaId
			};
			instockTimeStore.load();
	},
	//验证表格数据
	checkGridData: function(grid) {
		var store = grid.getStore();
		var locationNo;
		var status;
		//未下架、实际出库库位为空个数
		var downCount = 0;
		//未下架个数
		var count = 0;
		//遍历表格数据
		for (var i = 0; i < store.getCount(); i++) {
			actualArrivalQuantity = store.getAt(i).get('actualArrivalQuantity');
			actualOutstockQuantity = store.getAt(i).get('actualOutstockQuantity');
			outstockTactics = store.getAt(i).get('outstockTactics');
			if (outstockTactics != 3){//出库策略为先进先出、后进先出
				if(null == actualOutstockQuantity) {
					ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的实际出库数量不能为空", null, 300);
					return false;
				}
				if (actualArrivalQuantity < actualOutstockQuantity){
					ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的实际出库数量不能大于计划数量", null, 300);
					return false;
				}
				if(null != actualOutstockQuantity) {
					locationNo = store.getAt(i).get('locationNo');
					if(null == locationNo) {
						ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的实际出库库位不能为空", null, 300);
						return false;
					}
					instockTime = store.getAt(i).get('instockTime');	
					if(null == instockTime || "" == instockTime) {
						ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的入库时间不能为空", null, 300);
						return false;
					}
				}
			}else{//出库策略为人工选择
				if(null == actualOutstockQuantity) {//实际出库数量为空，则库位可以为空
				}else{//实际出库数量不为0，则库位不可以为空
					locationNo = store.getAt(i).get('locationNo');
					if(null == locationNo) {
						ACBEE.Ext.Util.showAlertBox("货物明细表格中的第" + (i+1) + "行的实际出库库位不能为空", null, 300);
						return false;
					}
				}
			}
			if(null != actualOutstockQuantity){
				count++;
			}
		}
		if(count == 0){
			ACBEE.Ext.Util.showAlertBox("必须出库一批货物(至少填写一条明细的出库数量)！", null, 300);
			return false;
		} 
		return true;
	},
	//保存按钮事件
	onSave: function(button) {
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		var win = button.up('window');
		//取得表单对象
		var form = win.down('form');
		//取得表格对象
		var grid = win.down('grid');
		//验证表单
		if(!form.isValid()){//表单有错误
			ACBEE.Ext.Util.showAlertBox("表单有错误，请修改后再保存！");
			return false;
		}
		
		//验证表格数据
		if(!this.checkGridData(grid)) {
			return false;
		}
		//取得表格数据
		var goods = ACBEE.Ext.Util.getStoreArrayData(grid.getStore());
		var oldOutstockBillId=win.oldOutstockBillId;
		//提交表单数据到后台
		ACBEE.Ext.Util.submitFormData(form, 'outstockBill/saveOutstockOffshelvesBill.action', {
			oldOutstockBillId: oldOutstockBillId,
			goods:goods
		}, "出库下架操作成功", "出库下架操作失败！！！", function() {
	    	if(undefined != win.parentStore) {
				//刷新父窗体表格
				win.parentStore.reload();
			}
			win.close();
		});
	}
});