/**
 * 出库下架操作信息管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-21
 */
Ext.define('WMS.controller.outstock.OutstockBillSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'outstock.OutstockBillSearchView'
	],
	requires: [
	    'WMS.view.outstock.OutstockBillEditView',
	    'WMS.controller.outstock.OutstockBillEditCtl'
   	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//复选框显示禁用项改变事件
	    	'outstockbillsearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
	    	//查询按钮事件
	    	'outstockbillsearchview button[name=btn-search]': {
	    		click: this.onSearchOutstockBill
	    	},
	    	//清空按钮事件
	    	'outstockbillsearchview button[name=btn-clear]': {
	    		click: this.onClearOutstockBill
	    	},
	    	//表格事件
	    	'outstockbillsearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	
    	//刷新出库性质下拉框数据
    	grid.down('combobox[name=outstockNature]').getStore().reload();
    	//刷新需方商下拉框数据
    	grid.down('combobox[name=demanderId]').getStore().reload();
    },
	 //复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		var form = combobox.up('form');
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();

		//根据显示禁用项的值重新加载需方商下拉框数据
		var demanderCbx = form.down('combobox[name=demanderId]');
		var outstockNatureCbx = form.down('combobox[name=outstockNature]');
		var demanderStore = demanderCbx.getStore();
		var outstockNatureStore = outstockNatureCbx.getStore();
		if(!showForbidden){//不显示禁用项时取状态为启用的需方商、出库性质
			//修改需方商store参数
			demanderStore.proxy.extraParams = {
				status: 1
			};
			//修改出库性质store参数
			outstockNatureStore.proxy.extraParams = {
				dictType: 4,
        	 	status: 1
			};
		}else{
			//修改需方商store参数
			demanderStore.proxy.extraParams = {
				status: -1
			};
			//修改出库性质store参数
			outstockNatureStore.proxy.extraParams = {
				dictType: 4,
        	 	status: -1
			};
		}
		//重加载需方商下拉框数据
		demanderStore.load();
		outstockNatureStore.load();
		
		//显示禁用项改变时，需方商改为全部
		if(showForbidden != null){
			demanderCbx.setValue();
			outstockNatureCbx.setValue(-1);
		}
	     //调用查询按钮事件
		this.onSearchOutstockBill(combobox);
	},
	//查询按钮事件处理
	onSearchOutstockBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var outstockBillGrid = button.up('grid');
		//取得表单对象
		var form = outstockBillGrid.down('form');
		//验证表单
		if(!form.isValid()){
        	ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
        	return false;
		}
		
		//获得查询条件
		//取得出库需求号
		var demandNo = outstockBillGrid.down('textfield[name=demandNo]').getValue();
		//取得预约开始日期
		if(outstockBillGrid.down('datefield[name=outstockBillBeginDate]').getValue()==null)
			var outstockBillBeginDate=null;
	    else
		    outstockBillBeginDate = Ext.Date.format(new Date(outstockBillGrid.down('datefield[name=outstockBillBeginDate]').getValue()),'Y-m-d H:i:s');
		//取得预约结束日期
		if(outstockBillGrid.down('datefield[name=outstockBillEndDate]').getValue()==null)
			var outstockBillEndDate=null;
	    else    
		    outstockBillEndDate = Ext.Date.format(new Date(outstockBillGrid.down('datefield[name=outstockBillEndDate]').getValue()),'Y-m-d H:i:s');
		 //取得计划出库开始时间
		if(outstockBillGrid.down('datetimefield[name=planOutstockBillBeginDate]').getValue()==null)
	    	var planOutstockBillBeginDate=null;
	    else
			planOutstockBillBeginDate = Ext.Date.format(new Date(outstockBillGrid.down('datetimefield[name=planOutstockBillBeginDate]').getValue()),'Y-m-d H:i:s');
		//取得计划出库结束时间
	    if(outstockBillGrid.down('datetimefield[name=planOutstockBillEndDate]').getValue()==null)
    		var planOutstockBillEndDate=null;
    	else
			planOutstockBillEndDate = Ext.Date.format(new Date(outstockBillGrid.down('datetimefield[name=planOutstockBillEndDate]').getValue()),'Y-m-d H:i:s');
        //取得订单号
		var orderNo = outstockBillGrid.down('textfield[name=orderNo]').getValue();
        //取得需方商
		var demanderId = outstockBillGrid.down('combobox[name=demanderId]').getValue();
        //取得出库状态
		var status = outstockBillGrid.down('combobox[name=status]').getValue();
        //取得出库性质
		var outstockNature = outstockBillGrid.down('combobox[name=outstockNature]').getValue();
	    //取得显示禁用项
	    var showForbidden=outstockBillGrid.down('checkbox[name=showForbidden]').getValue();
			
		//取得退库需求单的store
		var store = outstockBillGrid.getStore();
		//设置查询参数
		store.proxy.extraParams = {
			demandNo : demandNo,
			orderNo : orderNo,
			demanderId : demanderId,
			status : status,
			outstockNature: outstockNature,
			outstockBillBeginDate : outstockBillBeginDate,
			outstockBillEndDate : outstockBillEndDate,
			planOutstockBillBeginDate : planOutstockBillBeginDate,
			planOutstockBillEndDate : planOutstockBillEndDate,
			demanderStatus: showForbidden ? -1 : 1
		};
		store.loadPage(1);
	},
	//清空按钮事件
	onClearOutstockBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var outstockBillGrid = button.up('grid');
		///清空查询条件
		outstockBillGrid.down('textfield[name=demandNo]').setValue('');
		outstockBillGrid.down('textfield[name=orderNo]').setValue('');
		outstockBillGrid.down('datefield[name=outstockBillBeginDate]').setValue('');
		outstockBillGrid.down('datefield[name=outstockBillEndDate]').setValue('');
		outstockBillGrid.down('datetimefield[name=planOutstockBillBeginDate]').setValue('');
	    outstockBillGrid.down('datetimefield[name=planOutstockBillEndDate]').setValue('');
		outstockBillGrid.down('combobox[name=status]').setValue('-1');
		outstockBillGrid.down('combobox[name=demanderId]').setValue('');
		outstockBillGrid.down('combobox[name=outstockNature]').setValue(-1);
		outstockBillGrid.down('checkbox[name=showForbidden]').reset();
		this.onSearchOutstockBill(button);
	},
	//出库下架
	onOffShelves : function(grid, record){
		//加载出库下架编辑控制器
		ACBEE.Ext.Util.loadController(this.application, "outstock.OutstockBillEditCtl");
		//显示出库下架window
		var win = ACBEE.Ext.Util.getWin('outstockbilleditview');
		//保存原出库需求单Id
		win.oldOutstockBillId=record.data.outstockBillId;
		//保存当前表格的store
		win.parentStore=grid.getStore();
		//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('出库下架[' + record.get('demandNo') + ']');
		if(record.get('status') != 0 && record.get('actualOutstockGroup') != null){
			ACBEE.Ext.Util.disableCompoment(null, win.down('form'), true);
		}
		win.show();
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(14== cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-offShelves')) {//点击了下架
				this.onOffShelves(grid, record);
			} 
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('offShelves')) {
			this.onOffShelves(grid, record);
		}
	}
});