/**
 * 预约出库信息管理controller.
 * @author 高元称
 * @version 1.0.0, 2015-07-20
 */
Ext.define('WMS.controller.outstock.OutstockDemandBillSearchCtl',{
	extend: 'Ext.app.Controller',
	views: [
		'outstock.OutstockDemandBillSearchView'
	],
	requires: [
	    'WMS.view.outstock.OutstockDemandBillEditView',
	    'WMS.controller.outstock.OutstockDemandBillEditCtl'
   	],
	init:function(){
		//调用父方法
		this.callParent();
	    this.control({
	    	//复选框显示禁用项改变事件
	    	'outstockdemandbillsearchview checkbox[name=showForbidden]': {
	    		change: this.onShowForbidden
	    	},
        	//编制按钮事件
	    	'outstockdemandbillsearchview button[name=btn-drawUp]': {
	    		click: this.onAddOutstockDemandBill
	    	},
	    	//查询按钮事件
	    	'outstockdemandbillsearchview button[name=btn-search]': {
	    		click: this.onSearchOutstockDemandBill
	    	},
	    	//删除按钮事件
	    	'outstockdemandbillsearchview button[name=btn-delete]': {
	    		click: this.onDeleteOutstockDemandBill
	    	},
	    	//清空按钮事件
	    	'outstockdemandbillsearchview button[name=btn-clear]': {
	    		click: this.onClearOutstockDemandBill
	    	},
	    	//表格事件
	    	'outstockdemandbillsearchview' : {
	    		//视图渲染后事件
				afterrender: this.onAfterRender,
				//单元格单击事件
	    		cellclick: this.onGridCellClick,
	    		//表格双击事件
	    		itemdblclick: this.onGridItemDblClick
	    	}
	    });
	},
	/**
     * 视图渲染后事件
     */
    onAfterRender: function(grid, eOpts) {
    	//根据用户权限加载功能按钮
    	ACBEE.Ext.Util.loadFunctionBtns(grid, grid.functionCodes);
    	
    	//刷新需方商下拉框数据
    	grid.down('combobox[name=demanderId]').getStore().reload();
    },
	 //复选框显示禁用项改变事件
    onShowForbidden: function(combobox, record, value){
		var form = combobox.up('form');
		//得到显示禁用项的值
		var showForbidden = combobox.getValue();

		//根据显示禁用项的值重新加载需方商下拉框数据
		var demanderCbx = form.down('combobox[name=demanderId]');
		var demanderStore = demanderCbx.getStore();
		if(!showForbidden){//不显示禁用项时取状态为启用的需方商
			//修改需方商store参数
			demanderStore.proxy.extraParams = {
				status: 1
			};
		}else{
			//修改需方商store参数
			demanderStore.proxy.extraParams = {
				status: -1
			};
		}
		//重加载需方商下拉框数据
		demanderStore.load();
		
		//显示禁用项改变时，需方商改为全部
		if(showForbidden != null){
			demanderCbx.setValue();
		}
	     //调用查询按钮事件
		this.onSearchOutstockDemandBill(combobox);
	},
	//编制按钮事件处理
	onAddOutstockDemandBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//加载出库需求单编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "outstock.OutstockDemandBillEditCtl");
		//显示出库需求单window
		var win = ACBEE.Ext.Util.getWin('outstockdemandbilleditview');
		//清除表单内容
	    win.down('form').getForm().reset();
  	  	var store=win.down('grid').getStore();
  	  	if(store.getCount()>0){
  	  		store.removeAll();
  	  	}
		//设置操作员Id为0
	  	win.oldOutstockDemandBillId=0;
	  	//生成出库需求号
	  	//得到出库需求号对象
	  	var demandNo = win.down('textfield[name=demandNo]');
	  	ACBEE.Ext.Util.ajaxRequest("outstock/generateOutstockDemandBillNum.action",null,function(result){
	  		if(null != demandNo){
	  			demandNo.setValue(result.map.outstockDemandBillNum);
	  		}
	  	});
		//保存当前表格的store
	  	win.parentStore=button.up('grid').getStore();
		var save=win.down('button[name=btn-save]');
		var add=win.down('button[name=btn-add]');
		var deleteData=win.down('button[name=btn-delete]');
		var importData=win.down('button[name=btn-import]');
		ACBEE.Ext.Util.disableCompoment([save,add,importData,deleteData], win.down('form'), false);
		win.status = undefined;
		win.setTitle('预约出库信息编辑');
	  	win.show();
	},
	//查询按钮事件处理
	onSearchOutstockDemandBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var grid = button.up('grid');
		//取得表单对象
		var form = grid.down('form');
		//验证表单
		if(!form.isValid()){
        	ACBEE.Ext.Util.showAlertBox("查询条件有错误，请修改后再查询！", null, 300);
        	return false;
		}
		
		//获得查询条件
		//取得出库需求号
		var demandNo = grid.down('textfield[name=demandNo]').getValue();
		//取得预约开始日期
		if(grid.down('datefield[name=outstockBillBeginDate]').getValue()==null)
			var outstockBillBeginDate=null;
	    else
		    outstockBillBeginDate = Ext.Date.format(new Date(grid.down('datefield[name=outstockBillBeginDate]').getValue()),'Y-m-d H:i:s');
		//取得预约结束日期
		if(grid.down('datefield[name=outstockBillEndDate]').getValue()==null)
			var outstockBillEndDate=null;
	    else    
		    outstockBillEndDate = Ext.Date.format(new Date(grid.down('datefield[name=outstockBillEndDate]').getValue()),'Y-m-d H:i:s');
		 //取得计划出库开始时间
		if(grid.down('datetimefield[name=planOutstockBillBeginDate]').getValue()==null)
	    	var planOutstockBillBeginDate=null;
	    else
			planOutstockBillBeginDate = Ext.Date.format(new Date(grid.down('datetimefield[name=planOutstockBillBeginDate]').getValue()),'Y-m-d H:i:s');
		//取得计划出库结束时间
	    if(grid.down('datetimefield[name=planOutstockBillEndDate]').getValue()==null)
    		var planOutstockBillEndDate=null;
    	else
			planOutstockBillEndDate = Ext.Date.format(new Date(grid.down('datetimefield[name=planOutstockBillEndDate]').getValue()),'Y-m-d H:i:s');
        //取得订单号
		var orderNo = grid.down('textfield[name=orderNo]').getValue();
        //取得需方商
		var demanderId = grid.down('combobox[name=demanderId]').getValue();
        //取得出库状态
		var status = grid.down('combobox[name=status]').getValue();
	    //取得显示禁用项
	    var showForbidden=grid.down('checkbox[name=showForbidden]').getValue();
			
		//取得退库需求单的store
		var store = grid.getStore();
		//设置查询参数
		store.proxy.extraParams = {
			demandNo : demandNo,
			orderNo : orderNo,
			demanderId : demanderId,
			status : status,
			outstockBillBeginDate : outstockBillBeginDate,
			outstockBillEndDate : outstockBillEndDate,
			planOutstockBillBeginDate : planOutstockBillBeginDate,
			planOutstockBillEndDate : planOutstockBillEndDate,
			demanderStatus: showForbidden ? -1 : 1
		};
		store.loadPage(1);
	},
	//删除按钮事件处理
	onDeleteOutstockDemandBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//取得按钮所在表格
		var grid = button.up('grid');
			
		//提交删除表格多条数据
		ACBEE.Ext.Util.ajaxDelGridData(grid, 'outstockDemandBillId', 'outstock/delOutstockDemandBill.action', '出库需求单');
	},
	//清空按钮事件
	onClearOutstockDemandBill:function(button){
		//检测登录
		if(!ACBEE.Ext.Util.checkSession()) {
			ACBEE.Ext.Util.showAlertBox("登录超时，请重新登录系统！", null, 300, function() {
				location.href = "login.html";
			});
			return false;
		}
		//得到查询按钮所在的表格
		var grid = button.up('grid');
		///清空查询条件
		grid.down('textfield[name=demandNo]').setValue('');
		grid.down('textfield[name=orderNo]').setValue('');
		grid.down('datefield[name=outstockBillBeginDate]').setValue('');
		grid.down('datefield[name=outstockBillEndDate]').setValue('');
		grid.down('datetimefield[name=planOutstockBillBeginDate]').setValue('');
	    grid.down('datetimefield[name=planOutstockBillEndDate]').setValue('');
		grid.down('combobox[name=status]').setValue('-1');
		grid.down('combobox[name=demanderId]').setValue(-1);
		grid.down('checkbox[name=showForbidden]').reset();
		this.onSearchOutstockDemandBill(button);
	},
	//编辑事件
	onUpdateOutstockDemandBill : function(grid, record){
		//加载出库需求单编辑控制器
        ACBEE.Ext.Util.loadController(this.application, "outstock.OutstockDemandBillEditCtl");
		//显示出库需求单window
		var win = ACBEE.Ext.Util.getWin('outstockdemandbilleditview');
		//保存原出库需求单Id
	  	win.oldOutstockDemandBillId=record.data.outstockDemandBillId;
		//保存当前表格的store
	  	win.parentStore=grid.getStore();
	  	var save=win.down('button[name=btn-save]');
		var add=win.down('button[name=btn-add]');
		var deleteData=win.down('button[name=btn-delete]');
		var importData=win.down('button[name=btn-import]');
		if(record.get('status') !=0){
			ACBEE.Ext.Util.disableCompoment([save,add,importData,deleteData], win.down('form'), true);
			win.status = record.get('status');
		} else {
			ACBEE.Ext.Util.disableCompoment([save,add,importData,deleteData], win.down('form'), false);
			win.status = record.get('status');
		}
	 	//将选中记录的数据装载到编辑窗口中
		win.down('form').loadRecord(record);
		win.setTitle('修改出库需求单[' + record.get('demandNo') + ']');
	    win.show();
	},
	/**
	 * 表格单元格单击事件处理方法
	 */
	onGridCellClick: function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
		if(16== cellIndex) {//操作列
			var target = Ext.get(e.getTarget()); //获取事件对象 
			if(target.hasCls('btn-edit')) {//点击了编辑
				this.onUpdateOutstockDemandBill(grid, record);
			} else if(target.hasCls('btn-delete')) {//点击了删除
				var delInfo = '出库需求单[' + record.get('demandNo') + ']';
				var id = record.get('outstockDemandBillId');
				//提交删除当前行数据
				ACBEE.Ext.Util.ajaxDelSingleData(grid, delInfo, id, 'outstock/delOutstockDemandBill.action');
			}
		}
	},
	/**
	 * 表格双击事件处理方法
	 */
	onGridItemDblClick: function(grid, record, item, index, e, eOpts) {
		//有编辑权限，则打开编辑界面
		if(-1 != grid.panel.functionCodes.indexOf('edit')) {
			this.onUpdateOutstockDemandBill(grid, record);
		}
	}
});